/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Map;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONAware;
import org.zkoss.json.JSONObject;
import org.zkoss.json.parser.JSONParser;

public class JSONValue {
    public static Object parse(Reader in) throws IOException {
        if (in == null) {
            return null;
        }
        JSONParser parser = new JSONParser();
        return parser.parse(in);
    }

    public static Object parse(String s) {
        if (s == null) {
            return null;
        }
        try {
            StringReader in = new StringReader(s);
            return JSONValue.parse(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJSONString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + JSONValue.escape((String)value) + "\"";
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONAware) {
            return ((JSONAware)value).toJSONString();
        }
        if (value instanceof Map) {
            return JSONObject.toJSONString((Map)value);
        }
        if (value instanceof Collection) {
            return JSONArray.toJSONString((Collection)value);
        }
        if (value.getClass().isArray()) {
            if (value instanceof Object[]) {
                return JSONArray.toJSONString((Object[])value);
            }
            if (value instanceof int[]) {
                return JSONArray.toJSONString((int[])value);
            }
            if (value instanceof double[]) {
                return JSONArray.toJSONString((double[])value);
            }
            if (value instanceof long[]) {
                return JSONArray.toJSONString((long[])value);
            }
            if (value instanceof float[]) {
                return JSONArray.toJSONString((float[])value);
            }
            if (value instanceof short[]) {
                return JSONArray.toJSONString((short[])value);
            }
            if (value instanceof byte[]) {
                return JSONArray.toJSONString((byte[])value);
            }
            if (value instanceof boolean[]) {
                return JSONArray.toJSONString((boolean[])value);
            }
            if (value instanceof char[]) {
                return JSONArray.toJSONString((char[])value);
            }
        }
        if (value instanceof Enum) {
            return "\"" + JSONValue.escape(value.toString()) + "\"";
        }
        return value.toString();
    }

    public static String toJSONString(int value) {
        return Integer.toString(value);
    }

    public static String toJSONString(long value) {
        return Long.toString(value);
    }

    public static String toJSONString(short value) {
        return Long.toString(value);
    }

    public static String toJSONString(double value) {
        return Double.toString(value);
    }

    public static String toJSONString(float value) {
        return Float.toString(value);
    }

    public static String toJSONString(byte value) {
        return Byte.toString(value);
    }

    public static String toJSONString(boolean value) {
        return Boolean.toString(value);
    }

    public static String toJSONString(char value) {
        return JSONValue.toJSONString("" + value);
    }

    static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        JSONValue.escape(s, sb);
        return sb.toString();
    }

    static void escape(String s, StringBuffer sb) {
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
    }
}

