/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.image.encoder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.zkoss.image.encoder.ImageEncoder;
import org.zkoss.image.encoder.JPEGEncoder;
import org.zkoss.image.encoder.PNGEncoder;
import org.zkoss.lang.SystemException;

public class ImageEncoders {
    private static final Map<String, Class> _encoders;

    public static ImageEncoder newInstance(String format) {
        Class klass = _encoders.get(format.toLowerCase(Locale.ENGLISH));
        if (klass == null) {
            throw new IllegalArgumentException("Unsupported format: " + format);
        }
        try {
            return (ImageEncoder)klass.newInstance();
        }
        catch (Throwable ex) {
            throw SystemException.Aide.wrap(ex);
        }
    }

    public static Class setEncoderClass(String format, Class klass) {
        if (!ImageEncoder.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException(ImageEncoder.class + " must be implemented by " + klass);
        }
        return _encoders.put(format.toLowerCase(Locale.ENGLISH), klass);
    }

    public static Class getEncoderClass(String format) {
        return _encoders.get(format.toLowerCase(Locale.ENGLISH));
    }

    static {
        HashMap<String, Class> encoders = new HashMap<String, Class>(4);
        encoders.put("png", PNGEncoder.class);
        encoders.put("jpeg", JPEGEncoder.class);
        _encoders = Collections.synchronizedMap(encoders);
    }
}

