/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.TimeZone;

public class TimeZones {
    private static final InheritableThreadLocal<TimeZone> _thdTZone = new InheritableThreadLocal();

    public static final TimeZone getCurrent() {
        TimeZone l = (TimeZone)_thdTZone.get();
        return l != null ? l : TimeZone.getDefault();
    }

    public static final TimeZone setThreadLocal(TimeZone timezone) {
        TimeZone old = (TimeZone)_thdTZone.get();
        _thdTZone.set(timezone);
        return old;
    }

    public static final TimeZone getThreadLocal() {
        return (TimeZone)_thdTZone.get();
    }

    public static final TimeZone getTimeZone(int ofsmins) {
        StringBuffer sb = new StringBuffer(8).append("GMT");
        if (ofsmins >= 0) {
            sb.append('+');
        } else {
            sb.append('-');
            ofsmins = -ofsmins;
        }
        int hr = ofsmins / 60;
        int min = ofsmins % 60;
        if (min == 0) {
            sb.append(hr);
        } else {
            if (hr < 10) {
                sb.append('0');
            }
            sb.append(hr).append(':');
            if (min < 10) {
                sb.append('0');
            }
            sb.append(min);
        }
        return TimeZone.getTimeZone(sb.toString());
    }
}

