/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.lang.PotentialDeadLockException;
import org.zkoss.lang.SystemException;
import org.zkoss.util.CacheMap;
import org.zkoss.util.WaitLock;
import org.zkoss.util.resource.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCache<K, V>
extends CacheMap<Object, Object> {
    private static final Logger log = LoggerFactory.getLogger(ResourceCache.class);
    protected final Loader<K, V> _loader;
    private int _checkPeriod;

    public ResourceCache(Loader<K, V> loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this._loader = loader;
        this._checkPeriod = ResourceCache.getInitCheckPeriod();
    }

    public ResourceCache(Loader<K, V> loader, int initsz) {
        super(initsz);
        if (loader == null) {
            throw new NullPointerException();
        }
        this._loader = loader;
        this._checkPeriod = ResourceCache.getInitCheckPeriod();
    }

    private static int getInitCheckPeriod() {
        int v = Library.getIntProperty("org.zkoss.util.resource.checkPeriod", 5);
        return v > 0 ? v * 1000 : v;
    }

    public Loader<K, V> getLoader() {
        return this._loader;
    }

    public int getCheckPeriod() {
        return this._checkPeriod;
    }

    public ResourceCache setCheckPeriod(int checkPeriod) {
        this._checkPeriod = checkPeriod;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object src) {
        Object object;
        WaitLock lock;
        block31: {
            lock = null;
            while (true) {
                Info ri = null;
                object = this;
                synchronized (object) {
                    Object o = super.get(src);
                    if (o instanceof WaitLock) {
                        lock = (WaitLock)o;
                    } else {
                        if (o == null) {
                            lock = new WaitLock();
                            super.put(src, lock);
                            break block31;
                        }
                        ri = (Info)o;
                    }
                }
                if (ri != null) {
                    object = ri;
                    synchronized (object) {
                        if (ri.isValid()) {
                            return ri.getResource();
                        }
                    }
                    object = this;
                    synchronized (object) {
                        if (super.get(src) == ri) {
                            super.remove(src);
                        }
                    }
                }
                if (!lock.waitUntilUnlock(300000)) break;
            }
            PotentialDeadLockException ex = new PotentialDeadLockException("Unable to load from " + src + "\nCause: conflict too long.");
            log.warn("", (Throwable)ex);
            throw ex;
        }
        try {
            boolean cache;
            Info ri = new Info(src);
            Object resource = ri.getResource();
            if (resource instanceof Loader.Resource) {
                Loader.Resource lr = (Loader.Resource)resource;
                resource = lr.resource;
                cache = lr.cacheable;
            } else {
                cache = resource != null;
            }
            ResourceCache<K, V> resourceCache = this;
            synchronized (resourceCache) {
                if (cache) {
                    super.put(src, ri);
                } else {
                    super.remove(src);
                }
            }
            resourceCache = resource;
            return (V)resourceCache;
        }
        catch (Throwable ex) {
            object = this;
            synchronized (object) {
                super.remove(src);
            }
            throw SystemException.Aide.wrap(ex);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Object put(Object src, Object val) {
        throw new UnsupportedOperationException("Used only internally");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object src) {
        ResourceCache resourceCache = this;
        synchronized (resourceCache) {
            return super.remove(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ResourceCache resourceCache = this;
        synchronized (resourceCache) {
            super.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Info {
        private final K _src;
        private V _resource;
        private long _lastModified;
        private long _nextCheck;

        public Info(K src) throws Exception {
            this._src = src;
            this.load();
        }

        public final V getResource() {
            return this._resource;
        }

        public boolean isValid() {
            boolean valid;
            long now = System.currentTimeMillis();
            if (!ResourceCache.this._loader.shallCheck(this._src, now - this._nextCheck)) {
                return true;
            }
            long lastmod = ResourceCache.this._loader.getLastModified(this._src);
            if (lastmod == -1L) {
                return false;
            }
            boolean bl = valid = lastmod == this._lastModified;
            if (!valid) {
                log.info("Source is changed: " + this._src);
            }
            return valid;
        }

        protected void load() throws Exception {
            this._resource = ResourceCache.this._loader.load(this._src);
            if (this._resource != null) {
                this._lastModified = ResourceCache.this._loader.getLastModified(this._src);
                this._nextCheck = System.currentTimeMillis() + (long)ResourceCache.this._checkPeriod;
            }
        }
    }
}

