/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel.impl.parser;

import org.zkoss.zel.ELClass;
import org.zkoss.zel.ELException;
import org.zkoss.zel.MethodExpression;
import org.zkoss.zel.MethodInfo;
import org.zkoss.zel.MethodNotFoundException;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zel.ValueExpression;
import org.zkoss.zel.ValueReference;
import org.zkoss.zel.VariableMapper;
import org.zkoss.zel.impl.lang.EvaluationContext;
import org.zkoss.zel.impl.parser.Node;
import org.zkoss.zel.impl.parser.SimpleNode;
import org.zkoss.zel.impl.util.MessageFactory;
import org.zkoss.zel.impl.util.Validation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstIdentifier
extends SimpleNode {
    public AstIdentifier(int id) {
        super(id);
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        ValueExpression expr;
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper != null && (expr = varMapper.resolveVariable(this.image)) != null) {
            return expr.getType(ctx.getELContext());
        }
        ctx.setPropertyResolved(false);
        ctx.putContext(AstIdentifier.class, this.jjtGetNumSiblings());
        ctx.putContext(Node.class, this);
        Class<?> result = ctx.getELResolver().getType(ctx, null, this.image);
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
        }
        return result;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        ValueExpression expr;
        if (ctx.isLambdaArgument(this.image)) {
            return ctx.getLambdaArgument(this.image);
        }
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper != null && (expr = varMapper.resolveVariable(this.image)) != null) {
            return expr.getValue(ctx.getELContext());
        }
        ctx.setPropertyResolved(false);
        ctx.putContext(AstIdentifier.class, this.jjtGetNumSiblings());
        ctx.putContext(Node.class, this);
        Object elResult = ctx.getELResolver().getValue(ctx, null, this.image);
        Class<?> result = ctx.getImportHandler().resolveClass(this.image);
        if (result != null) {
            return new ELClass(result);
        }
        result = ctx.getImportHandler().resolveStatic(this.image);
        if (result != null) {
            try {
                return result.getField(this.image).get(null);
            }
            catch (IllegalArgumentException e) {
                throw new ELException(e);
            }
            catch (IllegalAccessException e) {
                throw new ELException(e);
            }
            catch (NoSuchFieldException e) {
                throw new ELException(e);
            }
            catch (SecurityException e) {
                throw new ELException(e);
            }
        }
        result = elResult;
        if (ctx.isPropertyResolved()) {
            if (result instanceof Class) {
                return new ELClass(result);
            }
            return result;
        }
        String hideException = System.getProperty("org.zkoss.zel.hideNullTypeException");
        if (hideException == null || "true".equals(hideException.toLowerCase())) {
            ctx.setPropertyResolved(true);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        ValueExpression expr;
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper != null && (expr = varMapper.resolveVariable(this.image)) != null) {
            return expr.isReadOnly(ctx.getELContext());
        }
        ctx.setPropertyResolved(false);
        boolean result = ctx.getELResolver().isReadOnly(ctx, null, this.image);
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
        }
        return result;
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        ValueExpression expr;
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper != null && (expr = varMapper.resolveVariable(this.image)) != null) {
            expr.setValue(ctx.getELContext(), value);
            return;
        }
        ctx.setPropertyResolved(false);
        ctx.putContext(AstIdentifier.class, this.jjtGetNumSiblings());
        ctx.putContext(Node.class, this);
        ctx.getELResolver().setValue(ctx, null, this.image, value);
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled.null", this.image));
        }
    }

    @Override
    public Object invoke(EvaluationContext ctx, Class<?>[] paramTypes, Object[] paramValues) throws ELException {
        return this.getMethodExpression(ctx).invoke(ctx.getELContext(), paramValues);
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class<?>[] paramTypes) throws ELException {
        return this.getMethodExpression(ctx).getMethodInfo(ctx.getELContext());
    }

    @Override
    public void setImage(String image) {
        if (!Validation.isIdentifier(image)) {
            throw new ELException(MessageFactory.get("error.identifier.notjava", image));
        }
        this.image = image;
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) {
        VariableMapper varMapper = ctx.getVariableMapper();
        if (varMapper == null) {
            return null;
        }
        ValueExpression expr = varMapper.resolveVariable(this.image);
        if (expr == null) {
            return null;
        }
        return expr.getValueReference(ctx);
    }

    private final MethodExpression getMethodExpression(EvaluationContext ctx) throws ELException {
        Object obj = null;
        VariableMapper varMapper = ctx.getVariableMapper();
        ValueExpression ve = null;
        if (varMapper != null && (ve = varMapper.resolveVariable(this.image)) != null) {
            obj = ve.getValue(ctx);
        }
        if (ve == null) {
            ctx.setPropertyResolved(false);
            obj = ctx.getELResolver().getValue(ctx, null, this.image);
        }
        if (obj instanceof MethodExpression) {
            return (MethodExpression)obj;
        }
        if (obj == null) {
            throw new MethodNotFoundException("Identity '" + this.image + "' was null and was unable to invoke");
        }
        throw new ELException("Identity '" + this.image + "' does not reference a MethodExpression instance, returned type: " + obj.getClass().getName());
    }
}

