/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.util.resource.LabelLocator;
import org.zkoss.web.servlet.Servlets;

public class ServletLabelLocator
implements LabelLocator {
    private static final Logger log = LoggerFactory.getLogger(ServletLabelLocator.class);
    private final ServletContext _ctx;
    private final String _path;

    public ServletLabelLocator(ServletContext ctx) {
        this(ctx, null);
    }

    public ServletLabelLocator(ServletContext ctx, String path) {
        if (ctx == null) {
            throw new IllegalArgumentException("null");
        }
        this._ctx = ctx;
        this._path = path;
    }

    public URL locate(Locale locale) throws IOException {
        String path;
        boolean fallback = false;
        if (this._path != null) {
            path = this._path;
        } else {
            path = Library.getProperty((String)"org.zkoss.util.label.web.location");
            if (path == null) {
                path = "/WEB-INF/zk-label.properties";
                fallback = true;
            }
        }
        URL url = this.locate0(path, locale);
        if (url == null) {
            if (fallback) {
                url = this.locate0("/WEB-INF/i3-label.properties", locale);
            } else if (locale == null) {
                log.error("File not found in " + this._ctx.getServletContextName() + ": " + path);
            }
        }
        return url;
    }

    private URL locate0(String path, Locale locale) throws IOException {
        int j = ((String)path).lastIndexOf(46);
        String prefix = j >= 0 ? ((String)path).substring(0, j) : path;
        String suffix = j >= 0 ? ((String)path).substring(j) : "";
        path = locale == null ? prefix + suffix : prefix + "_" + locale + suffix;
        return ((String)path).toLowerCase(Locale.ENGLISH).startsWith("file://") ? Servlets.getResource(this._ctx, (String)path) : this._ctx.getResource((String)path);
    }

    public int hashCode() {
        return this._ctx.hashCode() + Objects.hashCode((Object)this._path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ServletLabelLocator && ((ServletLabelLocator)o)._ctx.equals(this._ctx) && Objects.equals((Object)((ServletLabelLocator)o)._path, (Object)this._path);
    }

    public String toString() {
        return "ServletLabelLocator" + (String)(this._path != null ? ": " + this._path : "");
    }
}

