/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.impl;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Classes;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.dsp.DspException;
import org.zkoss.web.servlet.dsp.action.Action;
import org.zkoss.web.servlet.dsp.impl.ActionContextImpl;
import org.zkoss.web.servlet.dsp.impl.InterpretContext;
import org.zkoss.web.servlet.dsp.impl.Node;
import org.zkoss.web.servlet.dsp.impl.ParseContext;
import org.zkoss.xel.Expression;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;

class ActionNode
extends Node {
    private static final Log log = Log.lookup((Class)ActionNode.class);
    private final Class _cls;
    private List _attrs;
    private final int _nLines;

    ActionNode(Class cls, int nLines) {
        this._cls = cls;
        this._nLines = nLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interpret(InterpretContext ic) throws DspException, IOException {
        Action parent = ic.action;
        try {
            ic.action = this.newAction();
            if (this._attrs != null) {
                Iterator it = this._attrs.iterator();
                while (it.hasNext()) {
                    ((Attr)it.next()).apply(ic, ic.action);
                }
            }
            ic.action.render(new ActionContextImpl(ic, parent, this, this._nLines), this._children != null);
        }
        finally {
            ic.action = parent;
        }
    }

    private Action newAction() throws DspException {
        try {
            return (Action)this._cls.newInstance();
        }
        catch (Exception ex) {
            log.realCauseBriefly((Throwable)ex);
            throw DspException.Aide.wrap((Throwable)ex, "Failed to create " + this._cls);
        }
    }

    int getLineNumber() {
        return this._nLines;
    }

    void renderFragment(InterpretContext ic) throws DspException, IOException {
        if (this._children == null) {
            return;
        }
        Iterator it = this._children.iterator();
        while (it.hasNext()) {
            ((Node)it.next()).interpret(ic);
        }
    }

    void addAttribute(String nm, String val, ParseContext ctx) throws NoSuchMethodException, ClassCastException, XelException {
        if (nm == null || val == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._attrs == null) {
            this._attrs = new LinkedList();
        }
        Method mtd = (Method)Classes.getAccessibleObject((Class)this._cls, (String)nm, (Class[])new Class[]{null}, (int)7);
        Class<?> type = mtd.getParameterTypes()[0];
        if (val.indexOf("${") >= 0) {
            this._attrs.add(new Attr(mtd, ctx.getExpressionFactory().parseExpression((XelContext)ctx, val, type)));
        } else {
            this._attrs.add(new Attr(mtd, Classes.coerce(type, (Object)val)));
        }
    }

    public String toString() {
        return "Action[" + this._cls.getName() + ']';
    }

    private static class Attr {
        private final Method _method;
        private final Object _value;

        private Attr(Method mtd, Object val) {
            this._method = mtd;
            this._value = val;
        }

        private void apply(InterpretContext ic, Action action) throws DspException {
            Object[] args = new Object[1];
            try {
                args[0] = this._value instanceof Expression ? ((Expression)this._value).evaluate(ic.xelc) : this._value;
                this._method.invoke((Object)action, args);
            }
            catch (Exception ex) {
                log.realCauseBriefly((Throwable)ex);
                throw DspException.Aide.wrap((Throwable)ex, "Failed to invoke " + this._method + " with " + args[0] + (args[0] != null ? " @" + args[0].getClass().getName() : ""));
            }
        }
    }
}

