/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.Files;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.dsp.ExtendletDspContext;
import org.zkoss.web.servlet.dsp.Interpretation;
import org.zkoss.web.servlet.dsp.Interpreter;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ExtendletLoader;

public class DspExtendlet
implements Extendlet {
    private static final Log log = Log.lookup(DspExtendlet.class);
    private ExtendletContext _webctx;
    private ResourceCache<String, Interpretation> _cache;

    public void init(ExtendletConfig config) {
        this._webctx = config.getExtendletContext();
        DspLoader loader = new DspLoader();
        this._cache = new ResourceCache((Loader)loader, 131);
        this._cache.setMaxSize(1024);
        this._cache.setLifetime(3600000);
        int checkPeriod = loader.getCheckPeriod();
        this._cache.setCheckPeriod(checkPeriod >= 0 ? checkPeriod : 3600000);
    }

    public boolean getFeature(int feature) {
        return feature == 1;
    }

    public void service(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        Interpretation cnt = (Interpretation)this._cache.get((Object)path);
        if (cnt == null) {
            if (Servlets.isIncluded((ServletRequest)request)) {
                log.error("Failed to load the resource: " + path);
                throw new FileNotFoundException("Failed to load the resource: " + path);
            }
            response.sendError(404, path);
            return;
        }
        StringWriter sw = this._webctx.shallCompress((ServletRequest)request, DspExtendlet.get2ndExtension(path)) ? new StringWriter(4096) : null;
        cnt.interpret(new ExtendletDspContext(this._webctx, request, response, path, sw));
        if (sw != null) {
            String result = sw.toString();
            sw = null;
            try {
                byte[] bs;
                byte[] data;
                ServletOutputStream os = response.getOutputStream();
                String charset = response.getCharacterEncoding();
                if (charset == null || charset.length() == 0) {
                    charset = "UTF-8";
                }
                if ((data = result.getBytes(charset)).length > 200 && (bs = Https.gzip(request, response, null, data)) != null) {
                    data = bs;
                }
                response.setContentLength(data.length);
                os.write(data);
            }
            catch (IllegalStateException ex) {
                response.getWriter().write(result);
            }
            response.flushBuffer();
        }
    }

    private static final String get2ndExtension(String path) {
        int k;
        int j = path.lastIndexOf(46);
        if (j < 0 || path.indexOf(47, j + 1) >= 0) {
            return null;
        }
        int n = k = j > 0 ? path.lastIndexOf(46, j - 1) : -1;
        if (k < 0 || path.indexOf(47, k + 1) >= 0) {
            return null;
        }
        return path.substring(k + 1, j).toLowerCase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DspLoader
    extends ExtendletLoader<Interpretation> {
        private DspLoader() {
        }

        @Override
        protected Interpretation parse(InputStream is, String path, String orgpath) throws Exception {
            String content = Files.readAll((Reader)new InputStreamReader(is, "UTF-8")).toString();
            String ctype = Interpreter.getContentType(path);
            if (ctype == null) {
                ctype = ";charset=UTF-8";
            } else if (ctype.indexOf(59) < 0 && !ContentTypes.isBinary((String)ctype)) {
                ctype = ctype + ";charset=UTF-8";
            }
            return new Interpreter().parse(content, ctype, null, DspExtendlet.this._webctx.getLocator());
        }

        @Override
        protected ExtendletContext getExtendletContext() {
            return DspExtendlet.this._webctx;
        }
    }
}

