/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.theme.breeze;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.sys.SEORenderer;
import org.zkoss.zk.ui.util.ThemeProvider;
import org.zkoss.zk.ui.util.WebAppInit;
import org.zkoss.zkplus.theme.StandardThemeProvider;
import org.zkoss.zkplus.theme.Themes;

public class BreezeThemeWebAppInit
implements WebAppInit,
SEORenderer {
    private static final String BREEZE_NAME = "breeze";
    private static final String BREEZE_DISPLAY = "Breeze";
    private static final int BREEZE_PRIORITY = 500;
    private static final String THEME_INITED_DESKTOP = "org.zkoss.theme.desktop.inited";

    public void init(WebApp webapp) throws Exception {
        if (webapp.getConfiguration().getThemeProvider() == null) {
            webapp.getConfiguration().setThemeProvider((ThemeProvider)new StandardThemeProvider());
        }
        Themes.register((String)"classicblue", (String)"Classic Blue", (int)1000);
        Themes.register((String)BREEZE_NAME, (String)BREEZE_DISPLAY, (int)500);
    }

    public void render(Page page, Writer out) throws IOException {
        Desktop desktop = page.getDesktop();
        boolean inited = Boolean.TRUE.equals(desktop.getAttribute(THEME_INITED_DESKTOP));
        if (!inited) {
            desktop.setAttribute(THEME_INITED_DESKTOP, (Object)Boolean.TRUE);
            String name = Themes.getCurrentTheme();
            if (!"classicblue".equals(name)) {
                out.write("<script src='" + Executions.encodeURL((String)("~./js/zul." + name + ".wpd")) + "'></script>");
            }
        }
    }
}

