/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zhtml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.zkoss.zhtml.Utils;
import org.zkoss.zhtml.impl.AbstractTag;
import org.zkoss.zhtml.impl.PageRenderer;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;

public class Html
extends AbstractTag {
    public Html() {
        super("html");
    }

    public void invalidate() {
        Execution exec = Executions.getCurrent();
        if (exec != null && exec.isAsyncUpdate(this.getPage())) {
            throw new UnsupportedOperationException("html.invalidate() now allowed");
        }
        super.invalidate();
    }

    public void redraw(Writer out) throws IOException {
        Execution exec = Executions.getCurrent();
        StringWriter bufout = new StringWriter();
        Page page = this.getPage();
        Object ret = PageRenderer.beforeRenderHtml(exec, page, bufout);
        super.redraw(bufout);
        PageRenderer.afterRenderHtml(exec, page, bufout, ret);
        StringBuffer buf = bufout.getBuffer();
        if (exec != null) {
            Utils.addAllZkTags(exec, this.getPage(), buf, "html");
        }
        out.write(buf.toString());
    }

    protected boolean shallHideId() {
        return true;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null) {
            throw new UiException("Html must be the root component, not " + parent);
        }
        super.beforeParentChanged(parent);
    }
}

