/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.impl.SystemConverters;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.debugger.BindingAnnotationInfoChecker;
import org.zkoss.lang.Strings;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotateBinderHelper {
    private final Binder _binder;
    private static final String INIT_ANNO = "init";
    private static final String BIND_ANNO = "bind";
    private static final String LOAD_ANNO = "load";
    private static final String SAVE_ANNO = "save";
    private static final String REFERENCE_ANNO = "ref";
    private static final String ID_ANNO = "id";
    private static final String VALIDATOR_ANNO = "validator";
    private static final String CONVERTER_ANNO = "converter";
    private static final String TEMPLATE_ANNO = "template";
    private static final String COMMAND_ANNO = "command";
    private static final String GLOBAL_COMMAND_ANNO = "global-command";
    public static final String FORM_ATTR = "form";
    public static final String VIEW_MODEL_ATTR = "viewModel";
    public static final String BINDER_ATTR = "binder";
    public static final String VALIDATION_MESSAGES_ATTR = "validationMessages";
    public static final String CHILDREN_ATTR = "children";
    public static final String CHILDREN_KEY = "$CHILDREN$";

    public AnnotateBinderHelper(Binder binder) {
        this._binder = binder;
    }

    public void initComponentBindings(Component comp) {
        this.processAllComponentsBindings(comp);
    }

    private void processAllComponentsBindings(Component comp) {
        Binder selfBinder = BinderUtil.getBinder(comp);
        if (selfBinder != null) {
            return;
        }
        BindingAnnotationInfoChecker checker = ((BinderCtrl)((Object)this._binder)).getBindingAnnotationInfoChecker();
        if (checker != null) {
            checker.checkBinding(this._binder, comp);
        }
        this.processComponentBindings0(comp);
        for (Component kid : comp.getChildren()) {
            this.processAllComponentsBindings(kid);
        }
    }

    private void processComponentBindings0(Component comp) {
        List<String> props = AnnotationUtil.getNonSystemProperties(comp);
        for (String propName : props) {
            if (this.isEventProperty(propName)) {
                this.processCommandBinding(comp, propName);
                this.processGlobalCommandBinding(comp, propName);
                continue;
            }
            if (FORM_ATTR.equals(propName)) {
                this.processFormBindings(comp);
                continue;
            }
            if (CHILDREN_ATTR.equals(propName)) {
                this.processChildrenBindings(comp);
                continue;
            }
            if (VIEW_MODEL_ATTR.equals(propName) || BINDER_ATTR.equals(propName) || VALIDATION_MESSAGES_ATTR.equals(propName)) continue;
            this.processPropertyBindings(comp, propName);
        }
    }

    private boolean isEventProperty(String propName) {
        return propName.startsWith("on") && propName.length() >= 3 && Character.isUpperCase(propName.charAt(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommandBinding(Component comp, String propName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Collection anncol = compCtrl.getAnnotations(propName, COMMAND_ANNO);
        if (anncol.size() == 0) {
            return;
        }
        if (anncol.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one command binding for event " + propName + " of " + comp, comp));
        }
        Annotation ann = (Annotation)anncol.iterator().next();
        Map attrs = ann.getAttributes();
        HashMap<String, String[]> args = null;
        ArrayList<String> cmdExprs = new ArrayList<String>();
        for (Map.Entry entry : attrs.entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                cmdExprs.add(AnnotationUtil.testString(tagExpr, ann));
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            for (String cmd : cmdExprs) {
                this._binder.addCommandBinding(comp, propName, cmd, parsedArgs);
            }
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGlobalCommandBinding(Component comp, String propName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Collection anncol = compCtrl.getAnnotations(propName, GLOBAL_COMMAND_ANNO);
        if (anncol.size() == 0) {
            return;
        }
        if (anncol.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one global-command binding for event " + propName + " of " + comp, comp));
        }
        Annotation ann = (Annotation)anncol.iterator().next();
        Map attrs = ann.getAttributes();
        HashMap<String, String[]> args = null;
        ArrayList<String> cmdExprs = new ArrayList<String>();
        for (Map.Entry entry : attrs.entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                cmdExprs.add(AnnotationUtil.testString(tagExpr, ann));
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            for (String cmd : cmdExprs) {
                this._binder.addGlobalCommandBinding(comp, propName, cmd, parsedArgs);
            }
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private void processPropertyBindings(Component comp, String propName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        ExpressionAnnoInfo validatorInfo = this.parseValidator(comp, propName);
        ExpressionAnnoInfo converterInfo = this.parseConverter(comp, propName);
        Collection initannos = compCtrl.getAnnotations(propName, INIT_ANNO);
        if (initannos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one @init for " + propName + " of " + comp, (Annotation)initannos.iterator().next()));
        }
        if (initannos.size() == 1) {
            this.processPropertyInit(comp, propName, (Annotation)initannos.iterator().next(), converterInfo);
        }
        Collection annos = compCtrl.getAnnotations(propName);
        for (Annotation anno : annos) {
            if (anno.getName().equals(BIND_ANNO)) {
                this.processPropertyPromptBindings(comp, propName, anno, converterInfo, validatorInfo);
                continue;
            }
            if (anno.getName().equals(LOAD_ANNO)) {
                this.processPropertyLoadBindings(comp, propName, anno, converterInfo);
                continue;
            }
            if (anno.getName().equals(SAVE_ANNO)) {
                this.processPropertySaveBindings(comp, propName, anno, converterInfo, validatorInfo);
                continue;
            }
            if (!anno.getName().equals(REFERENCE_ANNO)) continue;
            this.processReferenceBinding(comp, propName, anno);
        }
        ExpressionAnnoInfo templateInfo = this.parseTemplate(comp, propName);
        if (templateInfo != null) {
            this._binder.setTemplate(comp, propName, templateInfo.expr, templateInfo.args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReferenceBinding(Component comp, String propName, Annotation ann) {
        String loadExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addReferenceBinding(comp, propName, loadExpr, parsedArgs);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPropertyInit(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String initExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                initExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addPropertyInitBinding(comp, propName, initExpr, parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPropertyPromptBindings(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo, ExpressionAnnoInfo validatorInfo) {
        String expr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                expr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("@bind is for prompt binding only, doesn't support before commands, check property " + propName + " of " + comp, ann));
            }
            if ("after".equals(tag)) {
                throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("@bind is for prompt binding only, doesn't support after commands, check property " + propName + " of " + comp, ann));
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.UtilContext ctx = BinderUtil.pushContext();
            ctx.setIgnoreAccessCreationWarn(true);
            ctx.setCurrentLocation(ann.getLocation());
            this._binder.addPropertyLoadBindings(comp, propName, expr, null, null, parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
            this._binder.addPropertySaveBindings(comp, propName, expr, null, null, parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args, validatorInfo == null ? null : validatorInfo.expr, validatorInfo == null ? null : validatorInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private void addCommand(Component comp, List<String> cmds, String[] cmdExprs) {
        for (String cmdExpr : cmdExprs) {
            this.addCommand(comp, cmds, cmdExpr);
        }
    }

    private void addCommand(Component comp, List<String> cmds, String cmdExpr) {
        String cmd = BindEvaluatorXUtil.eval(this._binder.getEvaluatorX(), comp, cmdExpr, String.class);
        if (Strings.isEmpty((String)cmd)) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("command of expression " + cmdExpr + " is empty", comp));
        }
        cmds.add(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPropertyLoadBindings(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String loadExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addPropertyLoadBindings(comp, propName, loadExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPropertySaveBindings(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo, ExpressionAnnoInfo validatorInfo) {
        String saveExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                saveExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addPropertySaveBindings(comp, propName, saveExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args, validatorInfo == null ? null : validatorInfo.expr, validatorInfo == null ? null : validatorInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private void processFormBindings(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        BindEvaluatorX eval = this._binder.getEvaluatorX();
        ExpressionAnnoInfo validatorInfo = this.parseValidator(comp, FORM_ATTR);
        String formId = null;
        Collection idannos = compCtrl.getAnnotations(FORM_ATTR, ID_ANNO);
        if (idannos.size() == 0) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("@id is not found for a form binding of " + comp, comp));
        }
        if (idannos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one @id for a form binding of " + comp, (Annotation)idannos.iterator().next()));
        }
        Annotation idanno = (Annotation)idannos.iterator().next();
        String idExpr = idanno.getAttribute("value");
        if (idExpr != null) {
            formId = BindEvaluatorXUtil.eval(eval, comp, idExpr, String.class);
        }
        if (formId == null) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("value of @id is not found for a form binding of " + compCtrl + ", exprssion is " + idExpr, idanno));
        }
        Collection initannos = compCtrl.getAnnotations(FORM_ATTR, INIT_ANNO);
        if (initannos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one @init for form of " + comp, (Annotation)initannos.iterator().next()));
        }
        if (initannos.size() == 1) {
            this.processFormInit(comp, formId, (Annotation)initannos.iterator().next());
        }
        Collection annos = compCtrl.getAnnotations(FORM_ATTR);
        for (Annotation anno : annos) {
            if (anno.getName().equals(LOAD_ANNO)) {
                this.processFormLoadBindings(comp, formId, anno);
                continue;
            }
            if (!anno.getName().equals(SAVE_ANNO)) continue;
            this.processFormSaveBindings(comp, formId, anno, validatorInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFormInit(Component comp, String formId, Annotation ann) {
        String initExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                initExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addFormInitBinding(comp, formId, initExpr, parsedArgs);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFormLoadBindings(Component comp, String formId, Annotation ann) {
        String loadExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addFormLoadBindings(comp, formId, loadExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFormSaveBindings(Component comp, String formId, Annotation ann, ExpressionAnnoInfo validatorInfo) {
        String saveExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                saveExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addFormSaveBindings(comp, formId, saveExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, validatorInfo == null ? null : validatorInfo.expr, validatorInfo == null ? null : validatorInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private void processChildrenBindings(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        ExpressionAnnoInfo converterInfo = this.parseConverter(comp, CHILDREN_ATTR);
        Collection initannos = compCtrl.getAnnotations(CHILDREN_ATTR, INIT_ANNO);
        if (initannos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one @init for children of " + comp, (Annotation)initannos.iterator().next()));
        }
        if (initannos.size() == 1) {
            this.processChildrenInit(comp, (Annotation)initannos.iterator().next(), converterInfo);
        }
        Collection annos = compCtrl.getAnnotations(CHILDREN_ATTR);
        for (Annotation anno : annos) {
            if (anno.getName().equals(BIND_ANNO)) {
                this.processChildrenPromptBindings(comp, anno, converterInfo);
                continue;
            }
            if (!anno.getName().equals(LOAD_ANNO)) continue;
            this.processChildrenLoadBindings(comp, anno, converterInfo);
        }
        ExpressionAnnoInfo templateInfo = this.parseTemplate(comp, CHILDREN_ATTR);
        if (templateInfo != null) {
            this._binder.setTemplate(comp, CHILDREN_KEY, templateInfo.expr, templateInfo.args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChildrenInit(Component comp, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String initExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                initExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addChildrenInitBinding(comp, initExpr, parsedArgs, converterInfo == null ? this.getDefaultChildBindingConverter() : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private String getDefaultChildBindingConverter() {
        if (SystemConverters.get("childrenBinding") != null) {
            return "'childrenBinding'";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChildrenPromptBindings(Component comp, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String expr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                expr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("@bind is for prompt binding only, doesn't support before commands, check property children of " + comp, comp));
            }
            if ("after".equals(tag)) {
                throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("@bind is for prompt binding only, doesn't support after commands, check property children of " + comp, comp));
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addChildrenLoadBindings(comp, expr, null, null, parsedArgs, converterInfo == null ? this.getDefaultChildBindingConverter() : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChildrenLoadBindings(Component comp, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String loadExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addChildrenLoadBindings(comp, loadExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, converterInfo == null ? this.getDefaultChildBindingConverter() : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private ExpressionAnnoInfo parseConverter(Component comp, String propName) {
        Collection annos = ((ComponentCtrl)comp).getAnnotations(propName, CONVERTER_ANNO);
        if (annos.size() == 0) {
            return null;
        }
        if (annos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one converter for " + propName + " of " + comp, comp));
        }
        Annotation ann = (Annotation)annos.iterator().next();
        ExpressionAnnoInfo info = new ExpressionAnnoInfo();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                info.expr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("value of converter is empty, check " + propName + " of " + comp, comp));
        }
        info.args = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        return info;
    }

    private ExpressionAnnoInfo parseValidator(Component comp, String propName) {
        Collection annos = ((ComponentCtrl)comp).getAnnotations(propName, VALIDATOR_ANNO);
        if (annos.size() == 0) {
            return null;
        }
        if (annos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one validator for " + propName + " of " + comp, comp));
        }
        Annotation ann = (Annotation)annos.iterator().next();
        ExpressionAnnoInfo info = new ExpressionAnnoInfo();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                info.expr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("value of validator is empty, check " + propName + " of " + comp, comp));
        }
        info.args = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        return info;
    }

    private ExpressionAnnoInfo parseTemplate(Component comp, String propName) {
        Collection annos = ((ComponentCtrl)comp).getAnnotations(propName, TEMPLATE_ANNO);
        if (annos.size() == 0) {
            return null;
        }
        if (annos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one template for " + propName + " of " + comp, comp));
        }
        Annotation ann = (Annotation)annos.iterator().next();
        ExpressionAnnoInfo info = new ExpressionAnnoInfo();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                info.expr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Must specify a template for " + propName + " of " + comp, comp));
        }
        info.args = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        return info;
    }

    private static class ExpressionAnnoInfo {
        Map<String, Object> args;
        String expr;

        private ExpressionAnnoInfo() {
        }
    }
}

