/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.FormExt;
import org.zkoss.bind.Property;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.Validator;
import org.zkoss.bind.impl.BindContextImpl;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.FormBindingImpl;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.impl.info.SaveInfo;
import org.zkoss.bind.sys.debugger.impl.info.ValidationInfo;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.ValueReference;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveFormBindingImpl
extends FormBindingImpl
implements SaveFormBinding {
    private static final long serialVersionUID = 1463169907348730644L;
    private final ExpressionX _validator;
    private final Map<String, Object> _validatorArgs;
    private static final String $VALUEREF$ = "$VALUEREF$";

    public SaveFormBindingImpl(Binder binder, Component comp, String formId, String saveExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String validatorExpr, Map<String, Object> validatorArgs) {
        super(binder, comp, formId, saveExpr, conditionType, command, bindingArgs);
        BindEvaluatorX eval = binder.getEvaluatorX();
        this._validator = validatorExpr == null ? null : this.parseValidator(eval, validatorExpr);
        this._validatorArgs = validatorArgs;
    }

    @Override
    public Map<String, Object> getValidatorArgs() {
        return this._validatorArgs;
    }

    @Override
    protected boolean ignoreTracker() {
        return true;
    }

    private ExpressionX parseValidator(BindEvaluatorX eval, String validatorExpr) {
        return eval.parseExpressionX(null, validatorExpr, Object.class);
    }

    @Override
    public Validator getValidator() {
        if (this._validator == null) {
            return null;
        }
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        Object obj = eval.getValue(null, this.getComponent(), this._validator);
        if (obj instanceof Validator) {
            return (Validator)obj;
        }
        if (obj instanceof String) {
            return this.getBinder().getValidator((String)obj);
        }
        throw new ClassCastException("result of expression '" + this._validator.getExpressionString() + "' is not a Validator, is " + obj);
    }

    @Override
    public void save(BindContext ctx) {
        Binder binder = this.getBinder();
        BindEvaluatorX eval = binder.getEvaluatorX();
        Component comp = this.getComponent();
        Form form = this.getFormBean();
        BindingExecutionInfoCollector collector = ((BinderCtrl)((Object)this.getBinder())).getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new SaveInfo("form-save", comp, this.getConditionString(ctx), this.getFormId(), this.getPropertyString(), form, this.getArgs(), null));
        }
        if (form instanceof FormExt) {
            for (String field : ((FormExt)((Object)form)).getSaveFieldNames()) {
                ExpressionX expr = this.getFieldExpression(eval, field);
                if (expr == null) continue;
                ExpressionX formExpr = this.getFormExpression(eval, field);
                Object value = eval.getValue(null, comp, formExpr);
                eval.setValue(ctx, comp, expr, value);
            }
        }
    }

    private String getConditionString(BindContext ctx) {
        StringBuilder condition = new StringBuilder();
        if (this.getConditionType() == ConditionType.BEFORE_COMMAND) {
            condition.append("before = '").append(this.getCommandName()).append("'");
        } else if (this.getConditionType() == ConditionType.AFTER_COMMAND) {
            condition.append("after = '").append(this.getCommandName()).append("'");
        } else {
            condition.append(ctx.getTriggerEvent() == null ? "" : "event = " + ctx.getTriggerEvent().getName());
        }
        return condition.length() == 0 ? null : condition.toString();
    }

    @Override
    public Property getValidate(BindContext ctx) {
        Binder binder = this.getBinder();
        BindEvaluatorX eval = binder.getEvaluatorX();
        Component comp = this.getComponent();
        Form form = this.getFormBean();
        ExpressionX expr = this.getBaseExpression(eval);
        if (expr != null) {
            Object base = eval.getValue(ctx, comp, expr);
            return new PropertyImpl(base, ".", form);
        }
        return null;
    }

    @Override
    public Set<Property> getValidates(BindContext ctx) {
        HashSet<Property> properties = new HashSet<Property>(2);
        Binder binder = this.getBinder();
        BindEvaluatorX eval = binder.getEvaluatorX();
        Component comp = this.getComponent();
        Form form = this.getFormBean();
        if (form instanceof FormExt) {
            for (String field : ((FormExt)((Object)form)).getSaveFieldNames()) {
                ExpressionX expr = this.getFieldExpression(eval, field);
                if (expr == null) continue;
                ValueReference valref = eval.getValueReference(ctx, comp, expr);
                if (valref == null) {
                    throw new UiException("value reference not found by expression [" + expr.getExpressionString() + "], check if you are trying to save to a variable only expression");
                }
                ExpressionX formExpr = this.getFormExpression(eval, field);
                Object value = eval.getValue(null, comp, formExpr);
                properties.add(new PropertyImpl(valref.getBase(), (String)valref.getProperty(), value));
            }
        }
        return properties;
    }

    @Override
    public boolean hasValidator() {
        return this._validator != null;
    }

    public String getValidatorExpressionString() {
        return this._validator == null ? null : BindEvaluatorXUtil.getExpressionString(this._validator);
    }

    @Override
    public void validate(ValidationContext vctx) {
        Validator validator = this.getValidator();
        if (validator == null) {
            throw new NullPointerException("cannot find validator for " + this);
        }
        validator.validate(vctx);
        BindingExecutionInfoCollector collector = ((BinderCtrl)((Object)this.getBinder())).getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new ValidationInfo("prop", this.getComponent(), this.getValidatorExpressionString(), validator.toString(), vctx.isValid(), ((BindContextImpl)vctx.getBindContext()).getValidatorArgs(), null));
        }
    }

    private ValueReference getValueReference(BindContext ctx) {
        ValueReference valref = (ValueReference)this.getAttribute(ctx, $VALUEREF$);
        if (valref == null) {
            Component comp = this.getComponent();
            BindEvaluatorX eval = this.getBinder().getEvaluatorX();
            valref = eval.getValueReference(ctx, comp, this._accessInfo.getProperty());
            if (valref == null) {
                throw new UiException("value reference not found by expression [" + this._accessInfo.getProperty().getExpressionString() + "], check if you are trying to save to a variable only expression");
            }
            this.setAttribute(ctx, $VALUEREF$, valref);
        }
        return valref;
    }

    private Method getValidatorMethod(Class<? extends Validator> cls) {
        try {
            return cls.getMethod("validate", ValidationContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

