/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.hibernate;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WebApp;

public class HibernateUtil {
    public static final String CONFIG = "HibernateUtil.config";
    private static final Logger log = LoggerFactory.getLogger(HibernateUtil.class);
    private static SessionFactory _factory;

    public static SessionFactory getSessionFactory() {
        return HibernateUtil.initSessionFactory((WebApp)null);
    }

    public static Session currentSession() throws HibernateException {
        return HibernateUtil.getSessionFactory().getCurrentSession();
    }

    public static void closeSession() throws HibernateException {
        HibernateUtil.currentSession().close();
    }

    static SessionFactory initSessionFactory(WebApp app) {
        if (_factory == null) {
            Desktop desktop;
            Execution exec;
            if (app == null && (exec = Executions.getCurrent()) != null && (desktop = exec.getDesktop()) != null) {
                app = desktop.getWebApp();
            }
            String resource = null;
            if (app != null) {
                resource = app.getConfiguration().getPreference(CONFIG, null);
            }
            if (resource == null) {
                resource = Library.getProperty((String)CONFIG);
            }
            return HibernateUtil.initSessionFactory(resource);
        }
        return _factory;
    }

    static SessionFactory initSessionFactory(String resource) {
        if (_factory == null) {
            try {
                _factory = resource == null ? new AnnotationConfiguration().configure().buildSessionFactory() : new AnnotationConfiguration().configure(resource).buildSessionFactory();
                log.debug("Hibernate configuration file loaded: " + (resource == null ? "hibernate.cfg.xml" : resource));
            }
            catch (Throwable ex) {
                log.error("Initial SessionFactory creation failed." + ex);
                throw new ExceptionInInitializerError(ex);
            }
        }
        return _factory;
    }

    static void cleanupSessionFactory() {
        if (_factory != null) {
            _factory.close();
            _factory = null;
        }
    }
}

