/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.AbstractSimpleDateTimeConstraint;
import org.zkoss.zul.Datebox;

public class SimpleLocalTimeConstraint
extends AbstractSimpleDateTimeConstraint<LocalTime> {
    public SimpleLocalTimeConstraint(int flags) {
        super(flags);
    }

    public SimpleLocalTimeConstraint(int flags, String errmsg) {
        super(flags, errmsg);
    }

    public SimpleLocalTimeConstraint(Pattern regex, String errmsg) {
        super(regex, errmsg);
    }

    public SimpleLocalTimeConstraint(int flags, Pattern regex, String errmsg) {
        super(flags, regex, errmsg);
    }

    public SimpleLocalTimeConstraint(int flags, LocalTime begin, LocalTime end, String errmsg) {
        super(flags, errmsg);
        this._beg = begin;
        this._end = end;
        this.fixConstraint();
    }

    public SimpleLocalTimeConstraint(String constraint) {
        super(constraint);
    }

    @Override
    protected void fixConstraint() {
        if ((this._flags & 1) != 0 && this._end == null) {
            this._end = LocalTime.now();
        }
        if ((this._flags & 2) != 0 && this._beg == null) {
            this._beg = LocalTime.now();
        }
    }

    @Override
    public void validate(Component comp, Object value) throws WrongValueException {
        super.validate(comp, value);
        if (value instanceof Date) {
            Instant instant = ((Date)value).toInstant();
            this.validate0(comp, LocalDateTime.ofInstant(instant, SimpleLocalTimeConstraint.getZoneId(this._tzone)).toLocalTime());
        }
    }

    @Override
    protected LocalTime parseFrom(String val) throws UiException {
        try {
            return LocalTime.from(SimpleLocalTimeConstraint.getDateFormat(this._tzone).parse(val.trim()));
        }
        catch (DateTimeException ex) {
            throw new UiException("Not a time: " + val + ". Format: HHmmss", (Throwable)ex);
        }
    }

    private static DateTimeFormatter getDateFormat(TimeZone tzone) {
        return DateTimeFormatter.ofPattern("HHmmss", Locales.getCurrent()).withZone(SimpleLocalTimeConstraint.getZoneId(tzone));
    }

    private static ZoneId getZoneId(TimeZone tzone) {
        return Optional.ofNullable(tzone).orElse(TimeZones.getCurrent()).toZoneId();
    }

    @Override
    protected String valueToString(Component comp, LocalTime value) {
        if (value == null) {
            return "";
        }
        if (comp instanceof Datebox) {
            ZoneId zoneId = SimpleLocalTimeConstraint.getZoneId(this._tzone);
            return ((Datebox)comp).coerceToString(Date.from(ZonedDateTime.of(LocalDate.now(zoneId), value, zoneId).toInstant()));
        }
        return SimpleLocalTimeConstraint.getDateFormat(this._tzone).format(value);
    }
}

