/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.LabelImageElement;
import org.zkoss.zul.impl.Utils;

public class A
extends LabelImageElement
implements org.zkoss.zul.api.A,
Disable {
    private String _dir = "normal";
    private String _href;
    private String _target;
    private int _tabindex;
    private boolean _disabled;

    public A() {
    }

    public A(String label) {
        super(label);
    }

    public A(String label, String image) {
        super(label, image);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public String getDir() {
        return this._dir;
    }

    public void setDir(String dir) throws WrongValueException {
        if (!"normal".equals(dir) && !"reverse".equals(dir)) {
            throw new WrongValueException(dir);
        }
        if (!Objects.equals((Object)this._dir, (Object)dir)) {
            this._dir = dir;
            this.smartUpdate("dir", this._dir);
        }
    }

    public String getHref() {
        return this._href;
    }

    public void setHref(String href) {
        if (href != null && href.length() == 0) {
            href = null;
        }
        if (!Objects.equals((Object)this._href, (Object)href)) {
            this._href = href;
            this.smartUpdate("href", new EncodedHref());
        }
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        if (target != null && target.length() == 0) {
            target = null;
        }
        if (!Objects.equals((Object)this._target, (Object)target)) {
            this._target = target;
            this.smartUpdate("target", this._target);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            this.smartUpdate("tabindex", this._tabindex);
        }
    }

    private String getEncodedHref() {
        Desktop dt = this.getDesktop();
        return this._href != null && dt != null ? dt.getExecution().encodeURL(this._href) : null;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._tabindex != 0) {
            renderer.render("tabindex", this._tabindex);
        }
        if (!"normal".equals(this._dir)) {
            this.render(renderer, "dir", this._dir);
        }
        this.render(renderer, "disabled", this._disabled);
        String href = this.getEncodedHref();
        this.render(renderer, "href", href);
        this.render(renderer, "target", this._target);
        Utils.renderCrawlableA(href, this.getLabel());
    }

    protected void renderCrawlable(String label) throws IOException {
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-a";
    }

    static {
        A.addClientEvent((Class)A.class, (String)"onFocus", (int)8192);
        A.addClientEvent((Class)A.class, (String)"onBlur", (int)8192);
    }

    private class EncodedHref
    implements DeferredValue {
        private EncodedHref() {
        }

        public Object getValue() {
            return A.this.getEncodedHref();
        }
    }
}

