/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;

public abstract class AbstractListModel
implements ListModel,
Selectable,
Serializable {
    private transient List _listeners = new LinkedList();
    private Set _selection = new HashSet();

    protected void fireEvent(int type, int index0, int index1) {
        ListDataEvent evt = new ListDataEvent(this, type, index0, index1);
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            ((ListDataListener)it.next()).onChange(evt);
        }
    }

    public void addListDataListener(ListDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this._listeners.remove(l);
    }

    public Set getSelection() {
        return Collections.unmodifiableSet(this._selection);
    }

    public void addSelection(Object obj) {
        this._selection.add(obj);
    }

    public void removeSelection(Object obj) {
        this._selection.remove(obj);
    }

    public void clearSelection() {
        this._selection.clear();
    }

    protected void removeAllSelection(Collection c) {
        this._selection.removeAll(c);
    }

    protected void retainAllSelection(Collection c) {
        this._selection.retainAll(c);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, (Collection)this._listeners);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList();
        Serializables.smartRead((ObjectInputStream)s, (Collection)this._listeners);
    }
}

