/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Objects;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.Openable;
import org.zkoss.zul.ext.Selectable;

public abstract class AbstractTreeModel
implements TreeModel,
Selectable,
Openable,
Serializable {
    private Object _root;
    private transient List _listeners = new LinkedList();
    private Set _selection = new HashSet();
    private Set _openSet = new HashSet();

    public AbstractTreeModel(Object root) {
        this._root = root;
    }

    public Object getRoot() {
        return this._root;
    }

    public void fireEvent(Object node, int indexFrom, int indexTo, int evtType) {
        TreeDataEvent evt = new TreeDataEvent(this, evtType, node, indexFrom, indexTo);
        Iterator it = this._listeners.iterator();
        while (it.hasNext()) {
            ((TreeDataListener)it.next()).onChange(evt);
        }
    }

    public int getIndexOfChild(Object parent, Object child) {
        int cnt = this.getChildCount(parent);
        for (int j = 0; j < cnt; ++j) {
            if (!Objects.equals((Object)child, (Object)this.getChild(parent, j))) continue;
            return j;
        }
        return -1;
    }

    public void addTreeDataListener(TreeDataListener l) {
        this._listeners.add(l);
    }

    public void removeTreeDataListener(TreeDataListener l) {
        this._listeners.remove(l);
    }

    public Set getSelection() {
        return Collections.unmodifiableSet(this._selection);
    }

    public void addSelection(Object obj) {
        this._selection.add(obj);
    }

    public void removeSelection(Object obj) {
        this._selection.remove(obj);
    }

    public void clearSelection() {
        this._selection.clear();
    }

    protected void removeAllSelection(Collection c) {
        this._selection.removeAll(c);
    }

    protected void retainAllSelection(Collection c) {
        this._selection.retainAll(c);
    }

    public void setOpen(Object obj, boolean open) {
        if (open) {
            this._openSet.add(obj);
        } else {
            this._openSet.remove(obj);
        }
    }

    public boolean isOpen(Object obj) {
        return this._openSet.contains(obj);
    }

    public void clearOpen() {
        this._openSet.clear();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, (Collection)this._listeners);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList();
        Serializables.smartRead((ObjectInputStream)s, (Collection)this._listeners);
    }

    public int[] getPath(Object parent, Object lastNode) {
        return Tree.getPath(this, parent, lastNode);
    }
}

