/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.zkoss.lang.Objects;
import org.zkoss.util.Dates;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Calendar
extends XulElement
implements org.zkoss.zul.api.Calendar {
    private Date _value;
    private String _name;

    public Calendar() {
        this(null);
    }

    public Calendar(Date value) {
        this._value = value != null ? value : Dates.today();
    }

    public TimeZone getTimeZone() {
        return null;
    }

    public void setTimeZone(TimeZone tzone) {
    }

    public Date getValue() {
        return this._value;
    }

    public void setValue(Date value) {
        if (value == null) {
            value = Dates.today();
        }
        if (!value.equals(this._value)) {
            this._value = value;
            this.smartUpdate("value", this._value);
        }
    }

    private DateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd", Locales.getCurrent());
        df.setTimeZone(TimeZones.getCurrent());
        return df;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-calendar" : this._zclass;
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onChange")) {
            Map data = request.getData();
            Object value = data.get("value");
            if (Objects.equals((Object)this._value, value)) {
                return;
            }
            this._value = (Date)value;
            InputEvent evt = new InputEvent(cmd, (Component)this, this.getDateFormat().format(value), value, AuRequests.getBoolean((Map)data, (String)"bySelectBack"), AuRequests.getInt((Map)data, (String)"start", (int)0));
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._name != null) {
            this.render(renderer, "name", this._name);
        }
        this.render(renderer, "value", this._value);
    }

    static {
        Calendar.addClientEvent((Class)Calendar.class, (String)"onChange", (int)16385);
    }
}

