/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.zkoss.zul.AbstractTreeModel;
import org.zkoss.zul.TreeModelExt;
import org.zkoss.zul.TreeNode;

public class DefaultTreeModel
extends AbstractTreeModel
implements TreeModelExt,
Serializable {
    private static final long serialVersionUID = 20110131094811L;

    public DefaultTreeModel(TreeNode root) {
        super(root);
        TreeNode parent = root.getParent();
        if (parent != null) {
            parent.remove(root);
        }
        root.setModel(this);
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public void sort(Comparator cmpr, boolean ascending) {
        TreeNode root = (TreeNode)this.getRoot();
        if (root != null) {
            this.sort0(root, cmpr);
            this.fireStructureChangedEvent(root);
        }
    }

    private void sort0(TreeNode node, Comparator cmpr) {
        if (node.getChildren() == null) {
            return;
        }
        Collections.sort(node.getChildren(), cmpr);
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            this.sort0((TreeNode)it.next(), cmpr);
        }
    }

    private void fireStructureChangedEvent(TreeNode node) {
        if (node.getChildCount() == 0) {
            return;
        }
        this.fireEvent(node, 0, 0, 3);
    }
}

