/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.zkoss.util.CollectionsX;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.TreeNode;

public class DefaultTreeNode
implements TreeNode,
Comparable,
Serializable {
    private DefaultTreeModel _model;
    private DefaultTreeNode _parent;
    private final List _children;
    private Object _data;
    private boolean _maxnull;

    public DefaultTreeNode(Object data, Collection children) {
        this(data, children, false);
    }

    public DefaultTreeNode(Object data, Collection children, boolean nullAsMax) {
        this._data = data;
        this._children = new TreeNodeChildrenList();
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.add((DefaultTreeNode)it.next());
            }
        }
        this._maxnull = nullAsMax;
    }

    public DefaultTreeNode(Object data, DefaultTreeNode[] children) {
        this(data, (Collection)new CollectionsX.ArrayCollection((Object[])children));
    }

    public DefaultTreeNode(Object data) {
        this(data, false);
    }

    public DefaultTreeNode(Object data, boolean nullAsMax) {
        this._data = data;
        this._children = null;
        this._maxnull = nullAsMax;
    }

    public void removeFromParent() {
        if (this._parent != null) {
            this._parent.remove(this);
        }
    }

    public DefaultTreeModel getModel() {
        return this._parent != null ? this._parent.getModel() : this._model;
    }

    public void setModel(DefaultTreeModel model) {
        if (model != null && this._parent != null) {
            throw new IllegalStateException("Only root allowed, " + this);
        }
        this._model = model;
    }

    public Object getData() {
        return this._data;
    }

    public void setData(Object data) {
        this._data = data;
        DefaultTreeModel model = this.getModel();
        TreeNode parent = this.getParent();
        if (model != null && parent != null) {
            int index = parent.getIndex(this);
            model.fireEvent(parent, index, index, 0);
        }
    }

    public List getChildren() {
        return this.isLeaf() ? null : this._children;
    }

    public TreeNode getChildAt(int childIndex) {
        return childIndex >= 0 && childIndex < this.getChildCount() ? (TreeNode)this._children.get(childIndex) : null;
    }

    public int getChildCount() {
        return this.isLeaf() ? 0 : this._children.size();
    }

    public TreeNode getParent() {
        return this._parent;
    }

    protected void setParent(DefaultTreeNode parent) {
        this._parent = parent;
    }

    public int getIndex(TreeNode node) {
        return this.isLeaf() ? -1 : this._children.indexOf(node);
    }

    public boolean isLeaf() {
        return this._children == null;
    }

    public void insert(TreeNode child, int index) {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Child is not allowed in leaf node");
        }
        this._children.add(index, child);
    }

    public void add(TreeNode child) {
        this.insert(child, this.getChildCount());
    }

    private static boolean isAncestor(TreeNode p, TreeNode c) {
        do {
            if (p != c) continue;
            return true;
        } while ((c = c.getParent()) != null);
        return false;
    }

    public void remove(int index) {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Child is not allowed in leaf node");
        }
        this._children.remove(index);
    }

    public void remove(TreeNode child) {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Child is not allowed in leaf node");
        }
        if (!this._children.remove(child)) {
            throw new IllegalArgumentException("not a child of this node");
        }
    }

    public int compareTo(Object obj) {
        DefaultTreeNode node = (DefaultTreeNode)obj;
        if (this._data == null) {
            return node == null ? 0 : (node.getData() == null ? 0 : (this._maxnull ? 1 : -1));
        }
        if (node == null) {
            return this._maxnull ? -1 : 1;
        }
        return ((Comparable)this._data).compareTo(node.getData());
    }

    protected class TreeNodeChildrenList
    extends AbstractList {
        protected ArrayList _list = new ArrayList();

        protected TreeNodeChildrenList() {
        }

        public Object get(int index) {
            return this._list.get(index);
        }

        public int size() {
            return this._list.size();
        }

        public void add(int index, Object obj) {
            DefaultTreeModel model;
            if (!(obj instanceof TreeNode)) {
                throw new IllegalArgumentException("New child must be an instance of TreeNode.");
            }
            TreeNode child = (TreeNode)obj;
            if (DefaultTreeNode.isAncestor(child, DefaultTreeNode.this)) {
                throw new IllegalArgumentException("New child is an ancestor");
            }
            TreeNode oldp = child.getParent();
            if (oldp != null) {
                oldp.remove(child);
            }
            this._list.add(index, child);
            if (child instanceof DefaultTreeNode) {
                ((DefaultTreeNode)child).setParent(DefaultTreeNode.this);
            }
            if ((model = DefaultTreeNode.this.getModel()) != null) {
                model.fireEvent(DefaultTreeNode.this, index, index, 1);
            }
        }

        public Object remove(int index) {
            DefaultTreeModel model;
            Object child = this._list.remove(index);
            if (child instanceof DefaultTreeNode) {
                ((DefaultTreeNode)child).setParent(null);
            }
            if ((model = DefaultTreeNode.this.getModel()) != null) {
                model.fireEvent(DefaultTreeNode.this, index, index, 2);
                model.removeSelection(child);
                model.setOpen(child, false);
            }
            return child;
        }

        public boolean remove(Object child) {
            int index = this._list.indexOf(child);
            if (index < 0) {
                return false;
            }
            this.remove(index);
            return true;
        }
    }
}

