/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.Group;
import org.zkoss.zul.Groupfoot;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.RowRendererExt;
import org.zkoss.zul.api.Foot;
import org.zkoss.zul.api.Paging;
import org.zkoss.zul.api.Row;
import org.zkoss.zul.api.Rows;
import org.zkoss.zul.event.DataLoadingEvent;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PageSizeEvent;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.event.RenderEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.DataLoader;
import org.zkoss.zul.impl.GridDataLoader;
import org.zkoss.zul.impl.GroupsListModel;
import org.zkoss.zul.impl.MeshElement;
import org.zkoss.zul.impl.Padding;
import org.zkoss.zul.impl.Utils;

public class Grid
extends MeshElement
implements org.zkoss.zul.api.Grid {
    private static final Log log = Log.lookup((Class)Grid.class);
    private static final long serialVersionUID = 20091111L;
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.Grid.onInitLaterPosted";
    private static final String ATTR_ON_PAGING_INIT_RENDER_POSTED = "org.zkoss.zul.Grid.onPagingInitLaterPosted";
    private static final int INIT_LIMIT = 100;
    private transient DataLoader _dataLoader;
    private transient org.zkoss.zul.Rows _rows;
    private transient Columns _cols;
    private transient org.zkoss.zul.Foot _foot;
    private transient Frozen _frozen;
    private transient Collection _heads;
    private transient ListModel _model;
    private transient RowRenderer _renderer;
    private transient ListDataListener _dataListener;
    private transient Paginal _pgi;
    private transient org.zkoss.zul.Paging _paging;
    private EventListener _pgListener;
    private EventListener _pgImpListener;
    private EventListener _modelInitListener;
    private String _scOddRow = null;
    private int _preloadsz = 7;
    private String _innerWidth = "100%";
    private int _currentTop = 0;
    private int _currentLeft = 0;
    private int _topPad;
    private boolean _renderAll;
    private transient boolean _rod;
    private String _emptyMessage;

    public Grid() {
        this.init();
    }

    private void init() {
        this._heads = new AbstractCollection(){

            public int size() {
                int sz = Grid.this.getChildren().size();
                if (Grid.this._rows != null) {
                    --sz;
                }
                if (Grid.this._foot != null) {
                    --sz;
                }
                if (Grid.this._paging != null) {
                    --sz;
                }
                if (Grid.this._frozen != null) {
                    --sz;
                }
                return sz;
            }

            public Iterator iterator() {
                return new Iter();
            }
        };
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (oldpage == null) {
            Executions.getCurrent().setAttribute("zkoss.Grid.deferInitModel_" + this.getUuid(), (Object)Boolean.TRUE);
            this._modelInitListener = new ModelInitListener();
            this.addEventListener("onInitModel", this._modelInitListener);
            Events.postEvent((int)20000, (Event)new Event("onInitModel", (Component)this));
        }
    }

    private void resetDataLoader() {
        if (this._dataLoader != null) {
            this._dataLoader.reset();
            this._dataLoader = null;
            this.smartUpdate("_lastoffset", 0);
        }
        this.smartUpdate("resetDataLoader", true);
        this._currentTop = 0;
        this._currentLeft = 0;
        this._topPad = 0;
    }

    public boolean isVflex() {
        String vflex = this.getVflex();
        if ("true".equals(vflex) || "min".equals(vflex)) {
            return true;
        }
        if (Strings.isBlank((String)vflex) || "false".equals(vflex)) {
            return false;
        }
        return Integer.parseInt(vflex) > 0;
    }

    public void setVflex(boolean vflex) {
        if (this.isVflex() != vflex) {
            this.setVflex(String.valueOf(vflex));
        }
    }

    public void setFixedLayout(boolean fixedLayout) {
        this.setSizedByContent(!fixedLayout);
    }

    public boolean isFixedLayout() {
        return !this.isSizedByContent();
    }

    public org.zkoss.zul.Rows getRows() {
        return this._rows;
    }

    public Rows getRowsApi() {
        return this.getRows();
    }

    public Columns getColumns() {
        return this._cols;
    }

    public org.zkoss.zul.api.Columns getColumnsApi() {
        return this.getColumns();
    }

    public org.zkoss.zul.Foot getFoot() {
        return this._foot;
    }

    public Frozen getFrozen() {
        return this._frozen;
    }

    public Foot getFootApi() {
        return this.getFoot();
    }

    public Collection getHeads() {
        return this._heads;
    }

    public Component getCell(int row, int col) {
        org.zkoss.zul.Rows rows = this.getRows();
        if (rows == null) {
            return null;
        }
        List children = rows.getChildren();
        if (children.size() <= row) {
            return null;
        }
        return (children = ((org.zkoss.zul.Row)children.get(row)).getChildren()).size() <= col ? null : (Component)children.get(col);
    }

    public String getAlign() {
        return null;
    }

    public void setAlign(String align) {
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this._pgi.setTotalSize(this._rows != null ? this.getDataLoader().getTotalSize() : 0);
                    this.addPagingListener(this._pgi);
                    if (this._pgi instanceof Component) {
                        this.smartUpdate("$u$paginal", ((Component)this._pgi).getUuid());
                    }
                }
            }
        }
    }

    private void newInternalPaging() {
        org.zkoss.zul.Paging paging = new org.zkoss.zul.Paging();
        paging.setAutohide(true);
        paging.setDetailed(true);
        paging.applyProperties();
        paging.setTotalSize(this._rows != null ? this.getDataLoader().getTotalSize() : 0);
        paging.setParent((Component)this);
        if (this._pgi != null) {
            this.addPagingListener(this._pgi);
        }
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new SerializableEventListener(){

                public void onEvent(Event event) {
                    PagingEvent evt = (PagingEvent)event;
                    Events.postEvent((Event)new PagingEvent(evt.getName(), (Component)Grid.this, evt.getPageable(), evt.getActivePage()));
                }
            };
        }
        pgi.addEventListener("onPaging", this._pgListener);
        if (this._pgImpListener == null) {
            this._pgImpListener = new SerializableEventListener(){

                public void onEvent(Event event) {
                    if (Grid.this._rows != null && Grid.this._model != null && Grid.this.inPagingMold()) {
                        Paginal pgi = Grid.this.getPaginal();
                        int pgsz = pgi.getPageSize();
                        int ofs = pgi.getActivePage() * pgsz;
                        if (Grid.this._rod) {
                            Grid.this.getDataLoader().syncModel(ofs, pgsz);
                        }
                        Grid.this.postOnPagingInitRender();
                    }
                    if (Grid.this.getModel() != null || Grid.this.getPagingPosition().equals("both")) {
                        Grid.this.invalidate();
                    } else if (Grid.this._rows != null) {
                        Grid.this._rows.invalidate();
                        if (Grid.this._frozen != null) {
                            Grid.this._frozen.invalidate();
                        }
                    }
                }
            };
        }
        pgi.addEventListener("onPagingImpl", this._pgImpListener);
    }

    private void removePagingListener(Paginal pgi) {
        pgi.removeEventListener("onPaging", this._pgListener);
        pgi.removeEventListener("onPagingImpl", this._pgImpListener);
    }

    public org.zkoss.zul.Paging getPagingChild() {
        return this._paging;
    }

    public Paging getPagingChildApi() {
        return this.getPagingChild();
    }

    protected Paginal pgi() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi;
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    public ListModel getModel() {
        return this._model;
    }

    public ListModel getListModel() {
        return this._model instanceof GroupsListModel ? null : this._model;
    }

    public GroupsModel getGroupsModel() {
        return this._model instanceof GroupsListModel ? ((GroupsListModel)this._model).getGroupsModel() : null;
    }

    public void setModel(ListModel model) {
        if (model != null) {
            Execution exec;
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                    if (this._model instanceof GroupsListModel) {
                        this._rows.getChildren().clear();
                    }
                    this.resetDataLoader();
                } else {
                    if (this._rows != null) {
                        this._rows.getChildren().clear();
                    }
                    this.smartUpdate("model", true);
                }
                this._model = model;
                this.initDataListener();
            }
            boolean defer = (exec = Executions.getCurrent()) == null ? false : exec.getAttribute("zkoss.Grid.deferInitModel_" + this.getUuid()) != null;
            boolean rod = this.evalRod();
            if (!defer || !rod) {
                this.getDataLoader().syncModel(-1, -1);
            } else if (this.inPagingMold()) {
                Paginal pgi = this.getPaginal();
                pgi.setTotalSize(this.getDataLoader().getTotalSize());
            }
            if (!Grid.doSort(this)) {
                this.postOnInitRender();
            }
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            if (this._rows != null) {
                this._rows.getChildren().clear();
            }
            this.smartUpdate("model", false);
        }
        this.getDataLoader().updateModelInfo();
    }

    public void setModel(GroupsModel model) {
        this.setModel(model != null ? new GroupsListModel(model) : null);
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Grid.this.onListDataChange(event);
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    private static boolean doSort(Grid grid) {
        Columns cols = grid.getColumns();
        if (!grid.isAutosort() || cols == null) {
            return false;
        }
        Iterator it = cols.getChildren().iterator();
        while (it.hasNext()) {
            Column hd = (Column)it.next();
            String dir = hd.getSortDirection();
            if ("natural".equals(dir)) continue;
            hd.doSort("ascending".equals(dir));
            return true;
        }
        return false;
    }

    public RowRenderer getRowRenderer() {
        return this._renderer;
    }

    public void setRowRenderer(RowRenderer renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            if (this._model != null) {
                if (renderer instanceof RowRendererExt || this._renderer instanceof RowRendererExt) {
                    this.getRows().getChildren().clear();
                    this.getDataLoader().syncModel(-1, -1);
                } else if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
                    this.getDataLoader().syncModel(-1, -1);
                } else {
                    Execution exec = Executions.getCurrent();
                    boolean defer = exec == null ? false : exec.getAttribute("zkoss.Grid.deferInitModel_" + this.getUuid()) != null;
                    boolean rod = this.evalRod();
                    if (!defer || !rod) {
                        this.getDataLoader().syncModel(-1, -1);
                    }
                }
            }
        }
    }

    public void setRowRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setRowRenderer((RowRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public int getPreloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        return size != null ? Integer.parseInt(size) : this._preloadsz;
    }

    public void setPreloadSize(int sz) {
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        this._preloadsz = sz;
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        this.doInitRenderer();
    }

    public void onPagingInitRender() {
        this.removeAttribute(ATTR_ON_PAGING_INIT_RENDER_POSTED);
        this.doInitRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitRenderer() {
        Renderer renderer = new Renderer();
        try {
            int ofs;
            int pgsz;
            if (this.inPagingMold()) {
                pgsz = this._pgi.getPageSize();
                ofs = this._pgi.getActivePage() * pgsz;
            } else {
                pgsz = this.getDataLoader().getLimit();
                ofs = this.getDataLoader().getOffset();
            }
            int cnt = this._rows.getChildren().size() + this.getDataLoader().getOffset();
            if (ofs >= cnt && (ofs = cnt - pgsz) < 0) {
                ofs = 0;
            }
            int j = 0;
            int realOfs = ofs - this.getDataLoader().getOffset();
            if (realOfs < 0) {
                realOfs = 0;
            }
            boolean open = true;
            ListIterator it = this._rows.getChildren().listIterator(realOfs);
            while (j < pgsz && it.hasNext()) {
                org.zkoss.zul.Row row = (org.zkoss.zul.Row)it.next();
                if (row.isVisible() && (open || row instanceof Groupfoot || row instanceof Group)) {
                    renderer.render(row);
                    ++j;
                }
                if (!(row instanceof Group)) continue;
                open = ((Group)row).isOpen();
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    private void postOnPagingInitRender() {
        if (this.getAttribute(ATTR_ON_PAGING_INIT_RENDER_POSTED) == null && this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_PAGING_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onPagingInitRender", (Component)this, null);
        }
    }

    private void onListDataChange(ListDataEvent event) {
        int type = event.getType();
        if (!(type != 1 && type != 0 || this.isIgnoreSortWhenChanged())) {
            Grid.doSort(this);
        } else {
            this.getDataLoader().doListDataChange(event);
            this.postOnInitRender();
        }
    }

    private static Label newRenderLabel(String value) {
        Label label = new Label(value != null && value.length() > 0 ? value : " ");
        label.setPre(true);
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderRow(org.zkoss.zul.Row row) {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            renderer.render(row);
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public void renderRowApi(Row rowApi) {
        org.zkoss.zul.Row row = (org.zkoss.zul.Row)rowApi;
        this.renderRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAll() {
        if (this._model == null) {
            return;
        }
        this._renderAll = true;
        this.getDataLoader().setLoadAll(this._renderAll);
        Renderer renderer = new Renderer();
        try {
            Iterator it = this._rows.getChildren().iterator();
            while (it.hasNext()) {
                renderer.render((org.zkoss.zul.Row)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public void renderRows(Set rows) {
        this.renderItems(rows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set rows) {
        if (this._model == null) {
            if (log.debugable()) {
                log.debug("No model no render");
            }
            return;
        }
        if (rows.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                renderer.render((org.zkoss.zul.Row)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public String getOddRowSclass() {
        return this._scOddRow == null ? this.getZclass() + "-odd" : this._scOddRow;
    }

    public void setOddRowSclass(String scls) {
        if (scls != null && scls.length() == 0) {
            scls = null;
        }
        if (!Objects.equals((Object)this._scOddRow, (Object)scls)) {
            this._scOddRow = scls;
            this.smartUpdate("oddRowSclass", scls);
        }
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
                if (this.getModel() != null) {
                    this.getDataLoader().syncModel(0, this.initRodSize());
                    this.postOnInitRender();
                }
                this.invalidate();
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
                this._topPad = 0;
                this._currentTop = 0;
                this._currentLeft = 0;
                Events.postEvent((int)10001, (Event)new PagingEvent("onPagingImpl", (Component)this._pgi, this._pgi.getActivePage()));
                this.invalidate();
            }
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-grid" : this._zclass;
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Rows) {
            if (this._rows != null && this._rows != newChild) {
                throw new UiException("Only one rows child is allowed: " + this + "\nNote: rows is created automatically if live data");
            }
        } else if (newChild instanceof Columns) {
            if (this._cols != null && this._cols != newChild) {
                throw new UiException("Only one columns child is allowed: " + this);
            }
        } else if (newChild instanceof Frozen) {
            if (this._frozen != null && this._frozen != newChild) {
                throw new UiException("Only one frozen child is allowed: " + this);
            }
        } else if (newChild instanceof org.zkoss.zul.Paging) {
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + this);
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
        } else if (newChild instanceof org.zkoss.zul.Foot) {
            if (this._foot != null && this._foot != newChild) {
                throw new UiException("Only one foot child is allowed: " + this);
            }
        } else if (!(newChild instanceof Auxhead)) {
            throw new UiException("Unsupported child for grid: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Rows) {
            if (super.insertBefore(newChild, refChild)) {
                this._rows = (org.zkoss.zul.Rows)newChild;
                return true;
            }
        } else if (newChild instanceof Columns) {
            if (super.insertBefore(newChild, refChild)) {
                this._cols = (Columns)newChild;
                return true;
            }
        } else if (newChild instanceof Frozen) {
            if (super.insertBefore(newChild, refChild)) {
                this._frozen = (Frozen)newChild;
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Paging) {
            if (super.insertBefore(newChild, refChild)) {
                this._paging = (org.zkoss.zul.Paging)newChild;
                this._pgi = this._paging;
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Foot) {
            if (super.insertBefore(newChild, refChild)) {
                this._foot = (org.zkoss.zul.Foot)newChild;
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    public boolean removeChild(Component child) {
        if (this._paging == child && this._pgi == child && this.inPagingMold()) {
            throw new IllegalStateException("The paging component cannot be removed manually. It is removed automatically when changing the mold");
        }
        if (!super.removeChild(child)) {
            return false;
        }
        if (this._rows == child) {
            this._rows = null;
        } else if (this._cols == child) {
            this._cols = null;
        } else if (this._frozen == child) {
            this._frozen = null;
        } else if (this._foot == child) {
            this._foot = null;
        } else if (this._paging == child) {
            this._paging = null;
            if (this._pgi == child) {
                this._pgi = null;
            }
        }
        return true;
    }

    boolean evalRod() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.grid.rod", false, true);
    }

    boolean isAutosort() {
        String attr = "org.zkoss.zul.grid.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val instanceof Boolean ? (Boolean)val : (val != null ? "true".equals(val) || "ignore.change".equals(val) : false);
    }

    private int preloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        int sz = size != null ? Integer.parseInt(size) : this._preloadsz;
        if ((sz = Utils.getIntAttribute((Component)this, "org.zkoss.zul.grid.preloadSize", sz, true)) < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        return sz;
    }

    private int initRodSize() {
        int sz = Utils.getIntAttribute((Component)this, "org.zkoss.zul.grid.initRodSize", 100, true);
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        return sz;
    }

    private boolean isIgnoreSortWhenChanged() {
        String attr = "org.zkoss.zul.grid.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val == null ? true : "ignore.change".equals(val);
    }

    DataLoader getDataLoader() {
        if (this._dataLoader == null) {
            this._rod = this.evalRod();
            String loadercls = Library.getProperty((String)"org.zkoss.zul.grid.DataLoader.class");
            try {
                this._dataLoader = this._rod && loadercls != null ? (DataLoader)Classes.forNameByThread((String)loadercls).newInstance() : new GridDataLoader();
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            this._dataLoader.init((Component)this, 0, this.initRodSize());
        }
        return this._dataLoader;
    }

    public Object clone() {
        Grid clone = (Grid)super.clone();
        clone.init();
        clone._pgImpListener = null;
        clone._pgListener = null;
        int offset = clone.getDataLoader().getOffset();
        int limit = clone.getDataLoader().getLimit();
        clone.resetDataLoader();
        clone.getDataLoader().init((Component)clone, offset, limit);
        int cnt = 0;
        if (clone._rows != null) {
            ++cnt;
        }
        if (clone._cols != null) {
            ++cnt;
        }
        if (clone._foot != null) {
            ++cnt;
        }
        if (clone._frozen != null) {
            ++cnt;
        }
        if (clone._paging != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        if (clone._model != null) {
            clone.getDataLoader().setLoadAll(this._renderAll);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof org.zkoss.zul.Rows) {
                this._rows = (org.zkoss.zul.Rows)child;
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Columns) {
                this._cols = (Columns)child;
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof org.zkoss.zul.Paging) {
                this._paging = (org.zkoss.zul.Paging)child;
                this._pgi = this._paging;
                this.addPagingListener(this._pgi);
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Frozen) {
                this._frozen = (Frozen)child;
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof org.zkoss.zul.Foot)) continue;
            this._foot = (org.zkoss.zul.Foot)child;
            if (--cnt != 0) continue;
            break;
        }
    }

    public String getEmptyMessage() {
        return this._emptyMessage;
    }

    public void setEmptyMessage(String emptyMessage) {
        if (!Objects.equals((Object)emptyMessage, (Object)this._emptyMessage)) {
            this._emptyMessage = emptyMessage;
            this.smartUpdate("emptyMessage", this._emptyMessage);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        Serializables.smartWrite((ObjectOutputStream)s, (Object)this._model);
        this.willSerialize(this._renderer);
        Serializables.smartWrite((ObjectOutputStream)s, (Object)this._renderer);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (ListModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (RowRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        this.init();
        this.afterUnmarshal(-1);
        if (this._model != null) {
            this.initDataListener();
            this.getDataLoader().setLoadAll(this._renderAll);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "oddRowSclass", this._scOddRow);
        if (this._model != null) {
            this.render(renderer, "model", true);
        }
        if (!"100%".equals(this._innerWidth)) {
            this.render(renderer, "innerWidth", this._innerWidth);
        }
        if (this._currentTop != 0) {
            renderer.render("_currentTop", this._currentTop);
        }
        if (this._currentLeft != 0) {
            renderer.render("_currentLeft", this._currentLeft);
        }
        renderer.render("_topPad", this._topPad);
        renderer.render("emptyMessage", this._emptyMessage);
        renderer.render("_totalSize", this.getDataLoader().getTotalSize());
        renderer.render("_offset", this.getDataLoader().getOffset());
        if (this._rod) {
            int sz;
            if (((Cropper)this.getDataLoader()).isCropper()) {
                renderer.render("_grid$rod", true);
            }
            if ((sz = this.initRodSize()) != 100) {
                renderer.render("initRodSize", this.initRodSize());
            }
        }
        if (this._pgi != null && this._pgi instanceof Component) {
            renderer.render("$u$paginal", ((Component)this._pgi).getUuid());
        }
    }

    boolean isRod() {
        return this._rod;
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._renderer);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._renderer);
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onDataLoading")) {
            Events.postEvent((Event)DataLoadingEvent.getDataLoadingEvent(request, this.preloadSize()));
        } else if (this.inPagingMold() && cmd.equals("onPageSize")) {
            int oldsize;
            Map data = request.getData();
            int size = AuRequests.getInt((Map)data, (String)"size", (int)(oldsize = this.getPageSize()));
            if (size != oldsize) {
                int begin = this.getActivePage() * oldsize;
                int end = begin + oldsize;
                end = Math.min(this.getPaginal().getTotalSize(), end);
                int sel = size > oldsize ? end - 1 : begin;
                int newpg = sel / size;
                this.setPageSize(size);
                this.setActivePage(newpg);
                Events.postEvent((Event)new PageSizeEvent(cmd, (Component)this, this.pgi(), size));
            }
        } else if (cmd.equals("onScrollPos")) {
            Map data = request.getData();
            this._currentTop = AuRequests.getInt((Map)data, (String)"top", (int)0);
            this._currentLeft = AuRequests.getInt((Map)data, (String)"left", (int)0);
        } else if (cmd.equals("onTopPad")) {
            this._topPad = AuRequests.getInt((Map)request.getData(), (String)"topPad", (int)0);
        } else if (cmd.equals("onInnerWidth")) {
            String width = AuRequests.getInnerWidth((AuRequest)request);
            this._innerWidth = width == null ? "100%" : width;
        } else if (cmd.equals("onRender")) {
            RenderEvent event = RenderEvent.getRenderEvent(request);
            Set items = event.getItems();
            int cnt = items.size();
            if (cnt == 0) {
                return;
            }
            if ((cnt = 20 - cnt) > 0 && this._preloadsz > 0) {
                org.zkoss.zul.Row row;
                if (cnt > this._preloadsz) {
                    cnt = this._preloadsz;
                }
                LinkedList<org.zkoss.zul.Row> toload = new LinkedList<org.zkoss.zul.Row>();
                Iterator it = this.getRows().getChildren().iterator();
                while (it.hasNext() && !items.contains(row = (org.zkoss.zul.Row)it.next())) {
                    if (row.isLoaded()) continue;
                    toload.add(0, row);
                }
                if (!toload.isEmpty()) {
                    int bfcnt = cnt / 3;
                    Iterator e = toload.iterator();
                    while (bfcnt > 0 && e.hasNext()) {
                        items.add(e.next());
                        --bfcnt;
                        --cnt;
                    }
                }
                while (cnt > 0 && it.hasNext()) {
                    row = (org.zkoss.zul.Row)it.next();
                    if (row.isLoaded() || !items.add(row)) continue;
                    --cnt;
                }
            }
            this.renderItems(items);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Grid.addClientEvent((Class)Grid.class, (String)"onRender", (int)8195);
        Grid.addClientEvent((Class)Grid.class, (String)"onInnerWidth", (int)8193);
        Grid.addClientEvent((Class)Grid.class, (String)"onScrollPos", (int)8193);
        Grid.addClientEvent((Class)Grid.class, (String)"onTopPad", (int)8192);
        Grid.addClientEvent((Class)Grid.class, (String)"onDataLoading", (int)8195);
        Grid.addClientEvent((Class)Grid.class, (String)"onPageSize", (int)8195);
    }

    private class Iter
    implements Iterator {
        private final ListIterator _it;

        private Iter() {
            this._it = Grid.this.getChildren().listIterator();
        }

        public boolean hasNext() {
            while (this._it.hasNext()) {
                Object o = this._it.next();
                if (!(o instanceof Columns) && !(o instanceof Auxhead)) continue;
                this._it.previous();
                return true;
            }
            return false;
        }

        public Object next() {
            Object o;
            while (!((o = this._it.next()) instanceof Columns) && !(o instanceof Auxhead)) {
            }
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Padding {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Grid.this);
        }

        public int getHeight() {
            return Grid.this._topPad;
        }

        public void setHeight(int height) {
            Grid.this._topPad = height;
        }
    }

    class Renderer {
        private final RowRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        Renderer() {
            this._renderer = (RowRenderer)Grid.this.getDataLoader().getRealRenderer();
        }

        void render(org.zkoss.zul.Row row) throws Throwable {
            if (row.isLoaded()) {
                return;
            }
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            Component cell = row.getFirstChild();
            if (!(this._renderer instanceof RowRendererExt) || (((RowRendererExt)((Object)this._renderer)).getControls() & 1) != 0) {
                cell.detach();
            }
            try {
                this._renderer.render(row, Grid.this._model.getElementAt(row.getIndex()));
            }
            catch (Throwable ex) {
                try {
                    Label label = Grid.newRenderLabel(Exceptions.getMessage((Throwable)ex));
                    label.applyProperties();
                    label.setParent((Component)row);
                }
                catch (Throwable t) {
                    log.error(t);
                }
                row.setLoaded(true);
                throw ex;
            }
            finally {
                if (row.getChildren().isEmpty()) {
                    cell.setParent((Component)row);
                }
            }
            row.setLoaded(true);
            this._rendered = true;
        }

        void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }

    private class ModelInitListener
    implements SerializableEventListener {
        private ModelInitListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (Grid.this._modelInitListener != null) {
                Grid.this.removeEventListener("onInitModel", Grid.this._modelInitListener);
                Grid.this._modelInitListener = null;
            }
            if (Grid.this._dataLoader != null) {
                boolean rod = Grid.this.evalRod();
                if (Grid.this._rod != rod || Grid.this.getRows() == null || Grid.this.getRows().getChildren().isEmpty()) {
                    if (Grid.this._model != null) {
                        if (Grid.this.getRows() != null) {
                            Grid.this.getRows().getChildren().clear();
                        }
                        Grid.this.resetDataLoader();
                        this.initModel();
                    } else {
                        Grid.this.resetDataLoader();
                    }
                }
            } else if (Grid.this._model != null) {
                this.initModel();
            } else {
                Executions.getCurrent().removeAttribute("zkoss.Grid.deferInitModel_" + Grid.this.getUuid());
            }
            DataLoader loader = Grid.this.getDataLoader();
            Paginal pgi = Grid.this.getPaginal();
            if (pgi != null) {
                pgi.setTotalSize(loader.getTotalSize());
            }
        }

        private void initModel() {
            Executions.getCurrent().removeAttribute("zkoss.Grid.deferInitModel_" + Grid.this.getUuid());
            Grid.this.setModel(Grid.this._model);
        }
    }
}

