/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.util.ArraysX;
import org.zkoss.zul.AbstractGroupsModel;
import org.zkoss.zul.GroupComparator;
import org.zkoss.zul.GroupsModelExt;

public class GroupsModelArray
extends AbstractGroupsModel
implements GroupsModelExt {
    protected Object[] _nativedata;
    protected Comparator _comparator;
    protected Object[][] _data;
    protected Object[] _heads;
    protected Object[] _foots;
    protected boolean[] _closes;

    public GroupsModelArray(Object[] data, Comparator cmpr) {
        this(data, cmpr, 0);
    }

    public GroupsModelArray(Object[] data, Comparator cmpr, int col) {
        this(data, cmpr, col, true);
    }

    public GroupsModelArray(Object[] data, Comparator cmpr, int col, boolean clone) {
        if (data == null || cmpr == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this._nativedata = clone ? (Object[])ArraysX.duplicate((Object)data) : data;
        this._comparator = cmpr;
        this.group(this._comparator, true, col);
    }

    public GroupsModelArray(List data, Comparator cmpr, int col) {
        this(data.toArray(), cmpr, col, false);
    }

    public GroupsModelArray(List data, Comparator cmpr) {
        this(data, cmpr, 0);
    }

    public Object getChild(int groupIndex, int index) {
        return this._data[groupIndex][index];
    }

    public int getChildCount(int groupIndex) {
        return this._data[groupIndex].length;
    }

    public Object getGroup(int groupIndex) {
        return this._heads == null ? this._data[groupIndex] : this._heads[groupIndex];
    }

    public int getGroupCount() {
        return this._data.length;
    }

    public Object getGroupfoot(int groupIndex) {
        return this._foots == null ? null : this._foots[groupIndex];
    }

    public boolean hasGroupfoot(int groupIndex) {
        return this._foots == null ? false : this._foots[groupIndex] != null;
    }

    public void sort(Comparator cmpr, boolean ascending, int col) {
        this.sortAllGroupData(cmpr, ascending, col);
        this.fireEvent(3, -1, -1, -1);
    }

    public void group(final Comparator cmpr, boolean ascending, int col) {
        Comparator cmprx = cmpr instanceof GroupComparator ? new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((GroupComparator)cmpr).compareGroup(o1, o2);
            }
        } : cmpr;
        this.sortDataInGroupOrder(cmprx, ascending, col);
        this.organizeGroup(cmprx, col);
        if (cmprx != cmpr) {
            this.sortAllGroupData(cmpr, ascending, col);
        }
        this.fireEvent(7, -1, -1, -1);
    }

    public boolean isClose(int groupIndex) {
        return this._closes == null ? false : this._closes[groupIndex];
    }

    public void setClose(int groupIndex, boolean close) {
        if (this._closes == null) {
            this._closes = new boolean[this.getGroupCount()];
        }
        if (this._closes[groupIndex] != close) {
            this._closes[groupIndex] = close;
            this.fireEvent(4, groupIndex, -1, -1);
        }
    }

    private void sortAllGroupData(Comparator cmpr, boolean ascending, int col) {
        for (int i = 0; i < this._data.length; ++i) {
            this.sortGroupData(this._heads[i], this._data[i], cmpr, ascending, col);
        }
    }

    protected void sortGroupData(Object group, Object[] groupdata, Comparator cmpr, boolean ascending, int col) {
        Arrays.sort(groupdata, cmpr);
    }

    protected void organizeGroup(Comparator cmpr, int col) {
        LinkedList group = new LinkedList();
        List gdata = null;
        Object last = null;
        Object curr = null;
        for (int i = 0; i < this._nativedata.length; ++i) {
            curr = this._nativedata[i];
            boolean hitn = false;
            boolean hita = false;
            if (last == null || cmpr.compare(last, curr) != 0) {
                hitn = true;
                gdata = new LinkedList<Object>();
                group.add(gdata);
            }
            gdata.add(curr);
            last = this._nativedata[i];
        }
        List[] gd = group.toArray(new List[group.size()]);
        this._data = new Object[gd.length][];
        this._foots = new Object[this._data.length];
        this._heads = new Object[this._data.length];
        this._closes = new boolean[this._data.length];
        for (int i = 0; i < gd.length; ++i) {
            gdata = gd[i];
            this._data[i] = gdata.toArray(new Object[gdata.size()]);
            this._heads[i] = this.createGroupHead(this._data[i], i, col);
            this._foots[i] = this.createGroupFoot(this._data[i], i, col);
            this._closes[i] = this.createGroupClose(this._data[i], i, col);
        }
    }

    protected Object createGroupHead(Object[] groupdata, int index, int col) {
        Object o = groupdata[0];
        return o != null && o.getClass().isArray() && col < Array.getLength(o) ? Array.get(o, col) : o;
    }

    protected Object createGroupFoot(Object[] groupdata, int index, int col) {
        return null;
    }

    protected void sortDataInGroupOrder(Comparator cmpr, boolean ascending, int colIndex) {
        Arrays.sort(this._nativedata, cmpr);
    }

    protected boolean createGroupClose(Object[] groupdata, int index, int col) {
        return false;
    }
}

