/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Label
extends XulElement
implements org.zkoss.zul.api.Label {
    private String _value = "";
    private AuxInfo _auxinf;

    public Label() {
    }

    public Label(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            this.smartUpdate("value", this.getValue());
        }
    }

    public int getMaxlength() {
        return this._auxinf != null ? this._auxinf.maxlength : 0;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if ((this._auxinf != null ? this._auxinf.maxlength : 0) != maxlength) {
            this.initAuxInfo().maxlength = maxlength;
            this.smartUpdate("maxlength", this.getMaxlength());
        }
    }

    public boolean isMultiline() {
        return this._auxinf != null && this._auxinf.multiline;
    }

    public void setMultiline(boolean multiline) {
        if ((this._auxinf != null && this._auxinf.multiline) != multiline) {
            this.initAuxInfo().multiline = multiline;
            this.smartUpdate("multiline", this.isMultiline());
        }
    }

    public boolean isPre() {
        return this._auxinf != null && this._auxinf.pre;
    }

    public void setPre(boolean pre) {
        if ((this._auxinf != null && this._auxinf.pre) != pre) {
            this.initAuxInfo().pre = pre;
            this.smartUpdate("pre", this.isPre());
        }
    }

    public boolean isHyphen() {
        return false;
    }

    public void setHyphen(boolean hyphen) {
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        int v = this.getMaxlength();
        if (v > 0) {
            renderer.render("maxlength", v);
        }
        this.render(renderer, "multiline", this.isMultiline());
        this.render(renderer, "pre", this.isPre());
        String val = this.getValue();
        this.render(renderer, "value", val);
        Utils.renderCrawlableText(val);
    }

    public String getZclass() {
        return this._zclass == null ? "z-label" : this._zclass;
    }

    public Object clone() {
        Label clone = (Label)super.clone();
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    protected boolean isChildable() {
        return false;
    }

    private AuxInfo initAuxInfo() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private int maxlength;
        private boolean multiline;
        private boolean pre;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

