/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public abstract class LayoutRegion
extends XulElement
implements org.zkoss.zul.api.LayoutRegion {
    private String _border = "normal";
    private int[] _margins = new int[]{0, 0, 0, 0};
    private boolean _flex;
    private boolean _autoscroll;
    private String _title = null;
    private int _maxsize = 2000;
    private int _minsize = 0;
    private int[] _cmargins = this.getDefaultCmargins();
    private boolean _splittable;
    private boolean _collapsible;
    private boolean _open = true;

    public String getBorder() {
        return this._border;
    }

    public void setBorder(String border) {
        if (border == null || "0".equals(border)) {
            border = "none";
        }
        if (!this._border.equals(border)) {
            this._border = border;
            this.smartUpdate("border", this._border);
        }
    }

    public boolean isFlex() {
        return this._flex;
    }

    public void setFlex(boolean flex) {
        if (this._flex != flex) {
            this._flex = flex;
            this.smartUpdate("flex", this._flex);
        }
    }

    public String getMargins() {
        return Utils.intsToString(this._margins);
    }

    public void setMargins(String margins) {
        int[] imargins = Utils.stringToInts(margins, 0);
        if (!Objects.equals((Object)imargins, (Object)this._margins)) {
            this._margins = imargins;
            this.smartUpdate("margins", this.getMargins());
        }
    }

    public boolean isAutoscroll() {
        return this._autoscroll;
    }

    public void setAutoscroll(boolean autoscroll) {
        if (this._autoscroll != autoscroll) {
            this._autoscroll = autoscroll;
            this.smartUpdate("autoscroll", this._autoscroll);
        }
    }

    public abstract String getPosition();

    public abstract void setSize(String var1);

    public abstract String getSize();

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            this.smartUpdate("title", this._title);
        }
    }

    public boolean isSplittable() {
        return this._splittable;
    }

    public void setSplittable(boolean splittable) {
        if (this._splittable != splittable) {
            this._splittable = splittable;
            this.smartUpdate("splittable", this._splittable);
        }
    }

    public void setMaxsize(int maxsize) {
        if (this._maxsize != maxsize) {
            this._maxsize = maxsize;
            this.smartUpdate("maxsize", this._maxsize);
        }
    }

    public int getMaxsize() {
        return this._maxsize;
    }

    public void setMinsize(int minsize) {
        if (this._minsize != minsize) {
            this._minsize = minsize;
            this.smartUpdate("minsize", minsize);
        }
    }

    public int getMinsize() {
        return this._minsize;
    }

    public String getCmargins() {
        return Utils.intsToString(this._cmargins);
    }

    public void setCmargins(String cmargins) {
        int[] imargins = Utils.stringToInts(cmargins, 0);
        if (!Objects.equals((Object)imargins, (Object)this._cmargins)) {
            this._cmargins = imargins;
            this.smartUpdate("cmargins", this.getCmargins());
        }
    }

    protected abstract int[] getDefaultCmargins();

    public boolean isCollapsible() {
        return this._collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        if (collapsible != this._collapsible) {
            this._collapsible = collapsible;
            this.smartUpdate("collapsible", this._collapsible);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", open);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-" + this.getPosition() : this._zclass;
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (this.getChildren().size() > 0) {
            throw new UiException("Only one child is allowed: " + this);
        }
        super.beforeChildAdded(child, refChild);
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Borderlayout)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"normal".equals(this._border)) {
            this.render(renderer, "border", this._border);
        }
        this.render(renderer, "flex", this._flex);
        this.render(renderer, "autoscroll", this._autoscroll);
        if (this._margins[0] != 0 || this._margins[1] != 0 || this._margins[2] != 0 || this._margins[3] != 0) {
            this.render(renderer, "margins", this.getMargins());
        }
        this.render(renderer, "title", this._title);
        if (this._maxsize != 2000) {
            renderer.render("maxsize", this._maxsize);
        }
        if (this._minsize != 0) {
            renderer.render("minsize", this._minsize);
        }
        this.render(renderer, "splittable", this._splittable);
        this.render(renderer, "collapsible", this._collapsible);
        int[] cms = this.getDefaultCmargins();
        int j = cms.length;
        while (--j >= 0) {
            if (cms[j] == this._cmargins[j]) continue;
            this.render(renderer, "cmargins", this.getCmargins());
            break;
        }
        if (!this._open) {
            renderer.render("open", this._open);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        LayoutRegion.addClientEvent((Class)LayoutRegion.class, (String)"onOpen", (int)1);
        LayoutRegion.addClientEvent((Class)LayoutRegion.class, (String)"onSize", (int)8193);
    }
}

