/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ListModelExt;

public class ListModelList
extends AbstractListModel
implements ListModelExt,
List,
Serializable {
    protected List _list;

    public ListModelList(List list, boolean live) {
        this._list = live ? list : new ArrayList(list);
    }

    public ListModelList() {
        this._list = new ArrayList();
    }

    public ListModelList(Collection c) {
        this._list = new ArrayList(c);
    }

    public ListModelList(Object[] array) {
        this._list = new ArrayList(array.length);
        for (int j = 0; j < array.length; ++j) {
            this._list.add(array[j]);
        }
    }

    public ListModelList(int initialCapacity) {
        this._list = new ArrayList(initialCapacity);
    }

    public void removeRange(int fromIndex, int toIndex) {
        int index;
        if (fromIndex > toIndex) {
            throw new UiException("fromIndex must less than toIndex: fromIndex: " + fromIndex + ", toIndex: " + toIndex);
        }
        if (fromIndex == toIndex) {
            return;
        }
        int sz = this._list.size();
        if (sz == fromIndex) {
            return;
        }
        ListIterator it = this._list.listIterator(fromIndex);
        for (index = fromIndex; it.hasNext() && index < toIndex; ++index) {
            Object obj = it.next();
            this.removeSelection(obj);
            it.remove();
        }
        this.fireEvent(2, fromIndex, index - 1);
    }

    public List getInnerList() {
        return this._list;
    }

    public int getSize() {
        return this._list.size();
    }

    public Object getElementAt(int j) {
        return this._list.get(j);
    }

    public void add(int index, Object element) {
        this._list.add(index, element);
        this.fireEvent(1, index, index);
    }

    public boolean add(Object o) {
        int i1 = this._list.size();
        boolean ret = this._list.add(o);
        this.fireEvent(1, i1, i1);
        return ret;
    }

    public boolean addAll(Collection c) {
        int sz = c.size();
        if (sz <= 0) {
            return false;
        }
        int i1 = this._list.size();
        int i2 = i1 + sz - 1;
        boolean ret = this._list.addAll(c);
        this.fireEvent(1, i1, i2);
        return ret;
    }

    public boolean addAll(int index, Collection c) {
        int sz = c.size();
        if (sz <= 0) {
            return false;
        }
        int i2 = index + sz - 1;
        boolean ret = this._list.addAll(index, c);
        this.fireEvent(1, index, i2);
        return ret;
    }

    public void clear() {
        int i2 = this._list.size() - 1;
        if (i2 < 0) {
            return;
        }
        this.clearSelection();
        this._list.clear();
        this.fireEvent(2, 0, i2);
    }

    public boolean contains(Object elem) {
        boolean ret = this._list.contains(elem);
        return ret;
    }

    public boolean containsAll(Collection c) {
        return this._list.containsAll(c);
    }

    public boolean equals(Object o) {
        return ((Object)this._list).equals(o instanceof ListModelList ? ((ListModelList)o)._list : o);
    }

    public Object get(int index) {
        return this._list.get(index);
    }

    public int hashCode() {
        return ((Object)this._list).hashCode();
    }

    public String toString() {
        return this._list.toString();
    }

    public int indexOf(Object elem) {
        return this._list.indexOf(elem);
    }

    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    public Iterator iterator() {
        return new Iterator(){
            private Iterator _it;
            private Object _current;
            {
                this._it = ListModelList.this._list.iterator();
                this._current = null;
            }

            public boolean hasNext() {
                return this._it.hasNext();
            }

            public Object next() {
                this._current = this._it.next();
                return this._current;
            }

            public void remove() {
                ListModelList.this.removeSelection(this._current);
                int index = ListModelList.this.indexOf(this._current);
                this._it.remove();
                ListModelList.this.fireEvent(2, index, index);
            }
        };
    }

    public int lastIndexOf(Object elem) {
        return this._list.lastIndexOf(elem);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            private ListIterator _it;
            private Object _current;
            {
                this._it = ListModelList.this._list.listIterator(index);
                this._current = null;
            }

            public boolean hasNext() {
                return this._it.hasNext();
            }

            public Object next() {
                this._current = this._it.next();
                return this._current;
            }

            public void remove() {
                int index2 = ListModelList.this._list.indexOf(this._current);
                if (index2 >= 0) {
                    ListModelList.this.removeSelection(this._current);
                    this._it.remove();
                    ListModelList.this.fireEvent(2, index2, index2);
                }
            }

            public void add(Object arg0) {
                int index2 = this._it.nextIndex();
                this._it.add(arg0);
                ListModelList.this.fireEvent(1, index2, index2);
            }

            public boolean hasPrevious() {
                return this._it.hasPrevious();
            }

            public int nextIndex() {
                return this._it.nextIndex();
            }

            public Object previous() {
                this._current = this._it.previous();
                return this._current;
            }

            public int previousIndex() {
                return this._it.previousIndex();
            }

            public void set(Object arg0) {
                int index2 = ListModelList.this._list.indexOf(this._current);
                if (index2 >= 0) {
                    this._it.set(arg0);
                    ListModelList.this.fireEvent(0, index2, index2);
                }
            }
        };
    }

    public Object remove(int index) {
        this.removeSelection(this._list.get(index));
        Object ret = this._list.remove(index);
        this.fireEvent(2, index, index);
        return ret;
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (this._list == c || this == c) {
            this.clearSelection();
            this.clear();
            return true;
        }
        return this.removePartial(c, true);
    }

    public boolean retainAll(Collection c) {
        if (this._list == c || this == c) {
            return false;
        }
        return this.removePartial(c, false);
    }

    private boolean removePartial(Collection c, boolean exclude) {
        boolean removed = false;
        int index = 0;
        int begin = -1;
        Iterator it = this._list.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (c.contains(item) == exclude) {
                if (begin < 0) {
                    begin = index;
                }
                removed = true;
                this.removeSelection(item);
                it.remove();
            } else if (begin >= 0) {
                this.fireEvent(2, begin, index - 1);
                index = begin;
                begin = -1;
            }
            ++index;
        }
        if (begin >= 0) {
            this.fireEvent(2, begin, index - 1);
        }
        return removed;
    }

    public Object set(int index, Object element) {
        Object ret = this._list.set(index, element);
        this.fireEvent(0, index, index);
        return ret;
    }

    public int size() {
        return this._list.size();
    }

    public List subList(int fromIndex, int toIndex) {
        List list = this._list.subList(fromIndex, toIndex);
        return new ListModelList(list, true);
    }

    public Object[] toArray() {
        return this._list.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this._list.toArray(a);
    }

    public void sort(Comparator cmpr, boolean ascending) {
        Collections.sort(this._list, cmpr);
        this.fireEvent(3, -1, -1);
    }
}

