/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.zkoss.lang.Objects;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ListModelExt;

public class ListModelMap
extends AbstractListModel
implements ListModelExt,
Map,
Serializable {
    protected Map _map;

    public ListModelMap(Map map, boolean live) {
        this._map = live ? map : new LinkedHashMap(map);
    }

    public ListModelMap() {
        this._map = new LinkedHashMap();
    }

    public ListModelMap(Map map) {
        this._map = new LinkedHashMap(map);
    }

    public ListModelMap(int initialCapacity) {
        this._map = new LinkedHashMap(initialCapacity);
    }

    public ListModelMap(int initialCapacity, float loadFactor) {
        this._map = new LinkedHashMap(initialCapacity, loadFactor);
    }

    public Map getInnerMap() {
        return this._map;
    }

    public int getSize() {
        return this._map.size();
    }

    public Object getElementAt(int j) {
        Map.Entry o;
        if (j < 0 || j >= this._map.size()) {
            throw new IndexOutOfBoundsException("" + j);
        }
        Iterator it = this._map.entrySet().iterator();
        do {
            o = it.next();
        } while (--j >= 0);
        return o;
    }

    public void clear() {
        int i2 = this._map.size() - 1;
        if (i2 < 0) {
            return;
        }
        this.clearSelection();
        this._map.clear();
        this.fireEvent(2, 0, i2);
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this._map.containsValue(value);
    }

    public Set entrySet() {
        return new MyEntrySet(this._map.entrySet());
    }

    public boolean equals(Object o) {
        return ((Object)this._map).equals(o instanceof ListModelMap ? ((ListModelMap)o)._map : o);
    }

    public String toString() {
        return this._map.toString();
    }

    public Object get(Object key) {
        return this._map.get(key);
    }

    public int hashCode() {
        return ((Object)this._map).hashCode();
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Set keySet() {
        return new MySet(this._map.keySet(), true);
    }

    public Object put(Object key, Object o) {
        Object ret;
        if (this._map.containsKey(key)) {
            if (Objects.equals((Object)o, this._map.get(key))) {
                return o;
            }
            int index = this.indexOfKey(key);
            ret = this._map.put(key, o);
            this.fireEvent(0, index, index);
        } else {
            ret = this._map.put(key, o);
            if (this._map instanceof LinkedHashMap) {
                int i1 = this._map.size() - 1;
                this.fireEvent(1, i1, i1);
            } else if (this._map instanceof SortedMap) {
                int i1 = this.indexOfKey(key);
                this.fireEvent(1, i1, i1);
            } else {
                this.fireEvent(0, -1, -1);
            }
        }
        return ret;
    }

    public int indexOfKey(Object o) {
        int j = 0;
        Iterator it = this._map.keySet().iterator();
        while (it.hasNext()) {
            if (Objects.equals((Object)o, it.next())) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public int indexOf(Object o) {
        int j = 0;
        Iterator it = this._map.entrySet().iterator();
        while (it.hasNext()) {
            if (Objects.equals((Object)o, it.next())) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public void putAll(Map c) {
        if (this._map instanceof LinkedHashMap) {
            Object val;
            Object key;
            Map.Entry entry;
            int sz = c.size();
            if (sz <= 0) {
                return;
            }
            if (c == this._map) {
                return;
            }
            ArrayList added = new ArrayList(c.size());
            Iterator it = c.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                key = entry.getKey();
                val = entry.getValue();
                if (this._map.containsKey(key)) {
                    this.put(key, val);
                    continue;
                }
                added.add(entry);
            }
            it = added.iterator();
            while (it.hasNext()) {
                entry = it.next();
                key = entry.getKey();
                val = entry.getValue();
                this._map.put(key, val);
            }
            int len = added.size();
            if (len > 0) {
                this.fireEvent(1, sz, sz + len - 1);
            }
        } else {
            this._map.putAll(c);
            this.fireEvent(0, -1, -1);
        }
    }

    public Object remove(Object key) {
        if (this._map.containsKey(key)) {
            Object ret = null;
            this.removeSelectionByKey(key);
            if (this._map instanceof LinkedHashMap || this._map instanceof SortedMap) {
                int index = this.indexOfKey(key);
                ret = this._map.remove(key);
                this.fireEvent(2, index, index);
            } else {
                ret = this._map.remove(key);
                this.fireEvent(0, -1, -1);
            }
            return ret;
        }
        return null;
    }

    private void removeSelectionByKey(Object key) {
        Iterator it = this.getSelection().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (!Objects.equals((Object)key, entry.getKey())) continue;
            this.removeSelection(entry);
            break;
        }
    }

    private void removeSelectionByValue(Object value) {
        Iterator it = this.getSelection().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (!Objects.equals((Object)value, entry.getValue())) continue;
            this.removeSelection(entry);
            return;
        }
    }

    public int size() {
        return this._map.size();
    }

    public Collection values() {
        return new MyCollection(this._map.values());
    }

    public void sort(Comparator cmpr, boolean ascending) {
        ArrayList copy = new ArrayList(this._map.entrySet());
        Collections.sort(copy, cmpr);
        this._map.clear();
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            this._map.put(entry.getKey(), entry.getValue());
        }
        this.fireEvent(3, -1, -1);
    }

    private boolean removePartial(Collection master, Collection c, boolean isRemove, boolean byKey, boolean byValue) {
        int sz = c.size();
        int removed = 0;
        int retained = 0;
        int index = 0;
        int begin = -1;
        Iterator it = master.iterator();
        while (!(!it.hasNext() || isRemove && removed >= sz || !isRemove && retained >= sz)) {
            Object item = it.next();
            if (c.contains(item) == isRemove) {
                if (begin < 0) {
                    begin = index;
                }
                ++removed;
                if (byKey) {
                    this.removeSelectionByKey(item);
                } else if (byValue) {
                    this.removeSelectionByValue(item);
                } else {
                    this.removeSelection(item);
                }
                it.remove();
            } else {
                ++retained;
                if (begin >= 0) {
                    this.fireEvent(2, begin, index - 1);
                    index = begin;
                    begin = -1;
                }
            }
            ++index;
        }
        if (begin >= 0) {
            this.fireEvent(2, begin, index - 1);
        }
        return removed > 0;
    }

    private class MyCollection
    implements Collection {
        private Collection _inner;

        public MyCollection(Collection inner) {
            this._inner = inner;
        }

        public void clear() {
            int i2 = this._inner.size() - 1;
            if (i2 < 0) {
                return;
            }
            ListModelMap.this.clearSelection();
            this._inner.clear();
            ListModelMap.this.fireEvent(2, 0, i2);
        }

        private int indexOfAndRemove(Object o) {
            int j = 0;
            Iterator it = this._inner.iterator();
            while (it.hasNext()) {
                Object val = it.next();
                if (Objects.equals(val, (Object)o)) {
                    ListModelMap.this.removeSelection(o);
                    it.remove();
                    return j;
                }
                ++j;
            }
            return -1;
        }

        public boolean remove(Object o) {
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                int index = this.indexOfAndRemove(o);
                if (index < 0) {
                    return false;
                }
                ListModelMap.this.fireEvent(2, index, index);
                return true;
            }
            ListModelMap.this.removeSelection(o);
            boolean ret = this._inner.remove(o);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        public boolean removeAll(Collection c) {
            if (this._inner == c || this == c) {
                ListModelMap.this.clearSelection();
                this.clear();
                return true;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._inner, c, true, false, true);
            }
            ListModelMap.this.removeAllSelection(c);
            boolean ret = this._inner.removeAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        public boolean retainAll(Collection c) {
            if (this._inner == c || this == c) {
                return false;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._inner, c, false, false, true);
            }
            ListModelMap.this.retainAllSelection(c);
            boolean ret = this._inner.retainAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        public Iterator iterator() {
            return new MyIterator(this._inner.iterator());
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("add()");
        }

        public boolean addAll(Collection col) {
            throw new UnsupportedOperationException("addAll()");
        }

        public boolean contains(Object o) {
            return this._inner == null ? false : this._inner.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this._inner == null ? false : this._inner.containsAll(c);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MyCollection) {
                return Objects.equals((Object)((MyCollection)o)._inner, (Object)this._inner);
            }
            return Objects.equals((Object)this._inner, (Object)o);
        }

        public int hashCode() {
            return this._inner == null ? 0 : ((Object)this._inner).hashCode();
        }

        public boolean isEmpty() {
            return this._inner == null ? true : this._inner.isEmpty();
        }

        public int size() {
            return this._inner == null ? 0 : this._inner.size();
        }

        public Object[] toArray() {
            return this._inner == null ? new Object[]{} : this._inner.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this._inner == null ? a : this._inner.toArray(a);
        }
    }

    private class MyEntrySet
    extends MySet {
        private MyEntrySet(Set inner) {
            super(inner, false);
        }

        protected int indexOf(Object o) {
            return ListModelMap.this.indexOf(o);
        }
    }

    private class MySet
    implements Set {
        private final Set _set;
        private final boolean _keyset;

        public MySet(Set inner, boolean keyset) {
            this._set = inner;
            this._keyset = keyset;
        }

        public void clear() {
            int i2 = this._set.size() - 1;
            if (i2 < 0) {
                return;
            }
            ListModelMap.this.clearSelection();
            this._set.clear();
            ListModelMap.this.fireEvent(2, 0, i2);
        }

        public boolean remove(Object o) {
            boolean ret = false;
            if (this._set.contains(o)) {
                ListModelMap.this.removeSelection(o);
                if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                    int index = this.indexOf(o);
                    ret = this._set.remove(o);
                    ListModelMap.this.fireEvent(2, index, index);
                } else {
                    ret = this._set.remove(o);
                    ListModelMap.this.fireEvent(0, -1, -1);
                }
            }
            return ret;
        }

        protected int indexOf(Object o) {
            return ListModelMap.this.indexOfKey(o);
        }

        public boolean removeAll(Collection c) {
            if (this._set == c || this == c) {
                this.clear();
                return true;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._set, c, true, this._keyset, false);
            }
            ListModelMap.this.removeAllSelection(c);
            boolean ret = this._set.removeAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        public boolean retainAll(Collection c) {
            if (this._set == c || this == c) {
                return false;
            }
            if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                return ListModelMap.this.removePartial(this._set, c, false, this._keyset, false);
            }
            ListModelMap.this.retainAllSelection(c);
            boolean ret = this._set.retainAll(c);
            if (ret) {
                ListModelMap.this.fireEvent(0, -1, -1);
            }
            return ret;
        }

        public Iterator iterator() {
            return new MyIterator(this._set.iterator());
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("add()");
        }

        public boolean addAll(Collection col) {
            throw new UnsupportedOperationException("addAll()");
        }

        public boolean contains(Object o) {
            return this._set == null ? false : this._set.contains(o);
        }

        public boolean containsAll(Collection c) {
            return this._set == null ? false : this._set.containsAll(c);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MySet) {
                return Objects.equals((Object)((MySet)o)._set, (Object)this._set);
            }
            return Objects.equals((Object)this._set, (Object)o);
        }

        public int hashCode() {
            return this._set == null ? 0 : ((Object)this._set).hashCode();
        }

        public boolean isEmpty() {
            return this._set == null ? true : this._set.isEmpty();
        }

        public int size() {
            return this._set == null ? 0 : this._set.size();
        }

        public Object[] toArray() {
            return this._set == null ? new Object[]{} : this._set.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this._set == null ? a : this._set.toArray(a);
        }
    }

    private class MyIterator
    implements Iterator {
        private Iterator _it;
        private Object _current;
        private int _index = -1;

        public MyIterator(Iterator inner) {
            this._it = inner;
            this._index = -1;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            ++this._index;
            this._current = this._it.next();
            return this._current;
        }

        public void remove() {
            if (this._index >= 0) {
                ListModelMap.this.removeSelection(this._current);
                this._it.remove();
                if (ListModelMap.this._map instanceof LinkedHashMap || ListModelMap.this._map instanceof SortedMap) {
                    ListModelMap.this.fireEvent(2, this._index, this._index);
                } else {
                    ListModelMap.this.fireEvent(0, -1, -1);
                }
            }
        }
    }
}

