/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.ListModelMap;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.event.ListDataListener;

public class ListModels {
    public static final Comparator STRING_COMPARATOR = new Comparator(){

        public int compare(Object key, Object value) {
            String idx = Objects.toString((Object)key);
            return idx != null && value != null && idx.length() > 0 && Objects.toString((Object)value).startsWith(idx) ? 0 : 1;
        }
    };
    public static final Comparator MAP_COMPARATOR = new Comparator(){

        public int compare(Object key, Object value) {
            String idx = Objects.toString((Object)key);
            return idx != null && value != null && idx.length() > 0 && Objects.toString(((Map.Entry)value).getValue()).startsWith(idx) ? 0 : 1;
        }
    };

    private ListModels() {
    }

    public static ListModel toListSubModel(ListModel model, Comparator comparator, int nRows) {
        return new SubModel(model, comparator, nRows);
    }

    public static ListModel toListSubModel(ListModel model) {
        return new SubModel(model, model instanceof ListModelMap ? MAP_COMPARATOR : STRING_COMPARATOR, 15);
    }

    private static class SubModel
    implements ListModel,
    ListSubModel,
    Serializable {
        private final ListModel _model;
        private final Comparator _comparator;
        private final int _nRows;

        private SubModel(ListModel model, Comparator comparator, int nRows) {
            this._model = model;
            this._comparator = comparator;
            this._nRows = nRows;
        }

        public ListModel getSubModel(Object value, int nRows) {
            LinkedList<Object> data = new LinkedList<Object>();
            nRows = nRows < 0 ? this._nRows : nRows;
            int j = this._model.getSize();
            for (int i = 0; i < j; ++i) {
                Object o = this._model.getElementAt(i);
                if (this._comparator.compare(value, o) != 0) continue;
                data.add(o);
                if (--nRows <= 0) break;
            }
            return new ListModelList(data);
        }

        public Object getElementAt(int index) {
            return this._model.getElementAt(index);
        }

        public int getSize() {
            return this._model.getSize();
        }

        public void addListDataListener(ListDataListener l) {
            this._model.addListDataListener(l);
        }

        public void removeListDataListener(ListDataListener l) {
            this._model.removeListDataListener(l);
        }
    }
}

