/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.Listgroupfoot;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.api.Listfoot;
import org.zkoss.zul.api.Listhead;
import org.zkoss.zul.api.Listitem;
import org.zkoss.zul.api.Paging;
import org.zkoss.zul.event.DataLoadingEvent;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PageSizeEvent;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.DataLoader;
import org.zkoss.zul.impl.GroupsListModel;
import org.zkoss.zul.impl.ListboxDataLoader;
import org.zkoss.zul.impl.MeshElement;
import org.zkoss.zul.impl.Padding;
import org.zkoss.zul.impl.Utils;

public class Listbox
extends MeshElement
implements org.zkoss.zul.api.Listbox {
    private static final long serialVersionUID = 2009111111L;
    public static final String LOADING_MODEL = "org.zkoss.zul.loadingModel";
    public static final String SYNCING_MODEL = "org.zkoss.zul.syncingModel";
    private static final Log log = Log.lookup((Class)Listbox.class);
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.onInitLaterPosted";
    private static final String ATTR_ON_PAGING_INIT_RENDERER_POSTED = "org.zkoss.zul.onPagingInitPosted";
    private static final int INIT_LIMIT = 100;
    private transient DataLoader _dataLoader;
    private transient List _items;
    private transient List _groupsInfo;
    private transient List _groups;
    private transient Set _selItems;
    private transient Set _roSelItems;
    private int _maxlength;
    private int _rows;
    private int _jsel = -1;
    private transient org.zkoss.zul.Listhead _listhead;
    private transient org.zkoss.zul.Listfoot _listfoot;
    private transient Frozen _frozen;
    private transient ListModel _model;
    private transient ListitemRenderer _renderer;
    private transient ListDataListener _dataListener;
    private transient Collection _heads;
    private int _hdcnt;
    private String _innerWidth = "100%";
    private String _name;
    private transient Paginal _pgi;
    private transient org.zkoss.zul.Paging _paging;
    private EventListener _pgListener;
    private EventListener _pgImpListener;
    private EventListener _modelInitListener;
    private String _scOddRow = null;
    private int _tabindex;
    private int _preloadsz = 7;
    private int _visibleItemCount;
    private int _currentTop = 0;
    private int _currentLeft = 0;
    private int _topPad;
    private String _nonselTags;
    private boolean _multiple;
    private boolean _disabled;
    private boolean _checkmark;
    private boolean _renderAll;
    private transient boolean _rod;
    private String _emptyMessage;
    private static Boolean _ckDeselectOther;

    public Listbox() {
        this.init();
    }

    private void init() {
        this._items = new AbstractSequentialList(){

            public ListIterator listIterator(int index) {
                return new ItemIter(index);
            }

            public Object get(int j) {
                Object o = Listbox.this.getChildren().get(j + Listbox.this._hdcnt);
                if (!(o instanceof org.zkoss.zul.Listitem)) {
                    throw new IndexOutOfBoundsException("Wrong index: " + j);
                }
                return o;
            }

            public int size() {
                int sz = Listbox.this.getChildren().size() - Listbox.this._hdcnt;
                if (Listbox.this._listfoot != null) {
                    --sz;
                }
                if (Listbox.this._paging != null) {
                    --sz;
                }
                if (Listbox.this._frozen != null) {
                    --sz;
                }
                return sz;
            }

            protected void removeRange(int fromIndex, int toIndex) {
                ListIterator it = this.listIterator(toIndex);
                int n = toIndex - fromIndex;
                while (--n >= 0 && it.hasPrevious()) {
                    it.previous();
                    it.remove();
                }
            }
        };
        this._selItems = new LinkedHashSet(5);
        this._roSelItems = Collections.unmodifiableSet(this._selItems);
        this._heads = new AbstractCollection(){

            public int size() {
                return Listbox.this._hdcnt;
            }

            public Iterator iterator() {
                return new Iter();
            }
        };
        this._groupsInfo = new LinkedList();
        this._groups = new AbstractList(){

            public int size() {
                return Listbox.this.getGroupCount();
            }

            public Iterator iterator() {
                return new IterGroups();
            }

            public Object get(int index) {
                return Listbox.this.getItemAtIndex(((int[])Listbox.this._groupsInfo.get(index))[0]);
            }
        };
    }

    private int getRealIndex(int index) {
        int offset = this._model != null ? this.getDataLoader().getOffset() : 0;
        return index - (offset < 0 ? 0 : offset);
    }

    public List getChildren() {
        return new Children();
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Listbox.this.onListDataChange(event);
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    public void setFixedLayout(boolean fixedLayout) {
        this.setSizedByContent(!fixedLayout);
    }

    public boolean isFixedLayout() {
        return !this.isSizedByContent();
    }

    public org.zkoss.zul.Listhead getListhead() {
        return this._listhead;
    }

    public Listhead getListheadApi() {
        return this.getListhead();
    }

    public org.zkoss.zul.Listfoot getListfoot() {
        return this._listfoot;
    }

    public Frozen getFrozen() {
        return this._frozen;
    }

    public Listfoot getListfootApi() {
        return this.getListfoot();
    }

    public Collection getHeads() {
        return this._heads;
    }

    boolean inSelectMold() {
        return "select".equals(this.getMold());
    }

    public boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            this.smartUpdate("checkmark", checkmark);
        }
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    public boolean isVflex() {
        String vflex = this.getVflex();
        if ("true".equals(vflex) || "min".equals(vflex)) {
            return true;
        }
        if (Strings.isBlank((String)vflex) || "false".equals(vflex)) {
            return false;
        }
        return Integer.parseInt(vflex) > 0;
    }

    public void setVflex(boolean vflex) {
        if (this.isVflex() != vflex) {
            this.setVflex(String.valueOf(vflex));
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            this.smartUpdate("tabindex", tabindex);
        }
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows < 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            this.smartUpdate("rows", this._rows);
        }
    }

    public String getSeltype() {
        return this._multiple ? "multiple" : "single";
    }

    public void setSeltype(String seltype) throws WrongValueException {
        if ("single".equals(seltype)) {
            this.setMultiple(false);
        } else if ("multiple".equals(seltype)) {
            this.setMultiple(true);
        } else {
            throw new WrongValueException("Unknown seltype: " + seltype);
        }
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            if (!this._multiple && this._selItems.size() > 1) {
                org.zkoss.zul.Listitem item = this.getSelectedItem();
                Iterator it = this._selItems.iterator();
                while (it.hasNext()) {
                    org.zkoss.zul.Listitem li = (org.zkoss.zul.Listitem)it.next();
                    if (li == item) continue;
                    li.setSelectedDirectly(false);
                    it.remove();
                }
            }
            this.smartUpdate("multiple", this._multiple);
        }
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.smartUpdate("maxlength", maxlength);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", name);
        }
    }

    public void setNonselectableTags(String tags) {
        if (!Objects.equals((Object)this._nonselTags, (Object)tags)) {
            this._nonselTags = tags;
            this.smartUpdate("nonselectableTags", tags);
        }
    }

    public String getNonselectableTags() {
        return this._nonselTags;
    }

    public List getItems() {
        return this._items;
    }

    public int getItemCount() {
        return this._items.size();
    }

    public org.zkoss.zul.Listitem getItemAtIndex(int index) {
        int realindex = this.getRealIndex(index);
        return realindex < 0 || realindex >= this._items.size() ? null : (org.zkoss.zul.Listitem)this._items.get(realindex);
    }

    public Listitem getItemAtIndexApi(int index) {
        return this.getItemAtIndex(index);
    }

    public int getIndexOfItem(org.zkoss.zul.Listitem item) {
        return item == null ? -1 : item.getIndex();
    }

    public int getIndexOfItemApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        return this.getIndexOfItem(item);
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    boolean isLoadingModel() {
        return this.getAttribute(LOADING_MODEL) != null;
    }

    public void setSelectedIndex(int jsel) {
        org.zkoss.zul.Listitem item;
        int tsz;
        int isz = this._items.size();
        int n = tsz = this._model != null ? this._model.getSize() : isz;
        if (jsel >= tsz) {
            throw new UiException("Out of bound: " + jsel + " while size=" + tsz);
        }
        if (jsel < -1) {
            jsel = -1;
        }
        if (jsel < 0) {
            this.clearSelection();
        } else if (jsel != this._jsel || this._multiple && this._selItems.size() > 1 || !this._selItems.contains(this.getItemAtIndex(this._jsel))) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                org.zkoss.zul.Listitem item2 = (org.zkoss.zul.Listitem)it.next();
                item2.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._jsel = jsel;
            item = this.getItemAtIndex(this._jsel);
            if (item == null) {
                if (this.inPagingMold()) {
                    int offset = this._jsel - this._jsel % this.getPageSize();
                    int limit = this.getPageSize();
                    this.getDataLoader().syncModel(offset, limit);
                } else {
                    this.smartUpdate("selInView_", this._jsel);
                }
            } else {
                item.setSelectedDirectly(true);
                this._selItems.add(item);
            }
            if (this._model instanceof Selectable) {
                if (!this.isLoadingModel()) {
                    ((Selectable)((Object)this._model)).clearSelection();
                }
                ((Selectable)((Object)this._model)).addSelection(this._model.getElementAt(this._jsel));
            }
            if (this.inSelectMold()) {
                this.smartUpdate("selectedIndex", this._jsel);
            } else if (item != null) {
                this.smartUpdate("selectedItem", item.getUuid());
            }
        }
        if (this._jsel >= 0 && this.inPagingMold()) {
            item = this.getItemAtIndex(this._jsel);
            int size = this.getDataLoader().getOffset();
            VisibleChildrenIterator it = new VisibleChildrenIterator(true);
            while (it.hasNext() && !item.equals(it.next())) {
                ++size;
            }
            int pg = size / this.getPageSize();
            if (pg != this.getActivePage()) {
                this.setActivePage(pg);
            }
        }
    }

    public void selectItem(org.zkoss.zul.Listitem item) {
        if (item == null) {
            this.setSelectedIndex(-1);
        } else {
            if (item.getParent() != this) {
                throw new UiException("Not a child: " + item);
            }
            if (this._multiple || !item.isSelected()) {
                this.setSelectedIndex(item.getIndex());
            }
        }
    }

    public void selectItemApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.selectItem(item);
    }

    public void addItemToSelection(org.zkoss.zul.Listitem item) {
        if (item.getParent() != this) {
            throw new UiException("Not a child: " + item);
        }
        if (!item.isSelected()) {
            if (!this._multiple) {
                this.selectItem(item);
            } else {
                if (item.getIndex() < this._jsel || this._jsel < 0) {
                    this._jsel = item.getIndex();
                }
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                if (this._model instanceof Selectable) {
                    ((Selectable)((Object)this._model)).addSelection(this._model.getElementAt(item.getIndex()));
                }
                if (this.inSelectMold()) {
                    item.smartUpdate("selected", true);
                } else {
                    this.smartUpdateSelection();
                }
            }
        }
    }

    public void addItemToSelectionApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.addItemToSelection(item);
    }

    public void removeItemFromSelection(org.zkoss.zul.Listitem item) {
        if (item.getParent() != this) {
            throw new UiException("Not a child: " + item);
        }
        if (item.isSelected()) {
            if (!this._multiple) {
                this.clearSelection();
            } else {
                if (this._model instanceof Selectable && !this.isLoadingModel()) {
                    ((Selectable)((Object)this._model)).removeSelection(this._model.getElementAt(item.getIndex()));
                }
                int oldSel = this._jsel;
                item.setSelectedDirectly(false);
                this._selItems.remove(item);
                this.fixSelectedIndex(0);
                if (this.inSelectMold()) {
                    item.smartUpdate("selected", false);
                } else {
                    this.smartUpdateSelection();
                }
            }
        }
    }

    public void removeItemFromSelectionApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.removeItemFromSelection(item);
    }

    private void smartUpdateSelection() {
        StringBuffer sb = new StringBuffer(80);
        Iterator it = this._selItems.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(((org.zkoss.zul.Listitem)it.next()).getUuid());
        }
        this.smartUpdate("chgSel", sb.toString());
    }

    public void toggleItemSelection(org.zkoss.zul.Listitem item) {
        if (item.isSelected()) {
            this.removeItemFromSelection(item);
        } else {
            this.addItemToSelection(item);
        }
    }

    public void toggleItemSelectionApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.toggleItemSelection(item);
    }

    public void clearSelection() {
        if (!this._selItems.isEmpty()) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)it.next();
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._jsel = -1;
            if (this.inSelectMold()) {
                this.smartUpdate("selectedIndex", -1);
            } else {
                this.smartUpdate("selectedItem", null);
            }
        }
        if (this._model instanceof Selectable && !this.isLoadingModel()) {
            ((Selectable)((Object)this._model)).clearSelection();
        }
    }

    public void selectAll() {
        if (!this._multiple) {
            throw new UiException("Appliable only to the multiple seltype: " + this);
        }
        if (this._items.size() != this._selItems.size()) {
            Iterator it = this._items.iterator();
            while (it.hasNext()) {
                org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)it.next();
                this._selItems.add(item);
                item.setSelectedDirectly(true);
            }
            this._jsel = this._items.isEmpty() ? -1 : 0;
            this.smartUpdate("selectAll", true);
        }
        if (this._model instanceof Selectable && this._model.getSize() != ((Selectable)((Object)this._model)).getSelection().size()) {
            int j = this._model.getSize();
            while (--j >= 0) {
                ((Selectable)((Object)this._model)).addSelection(this._model.getElementAt(j));
            }
        }
    }

    public org.zkoss.zul.Listitem getSelectedItem() {
        return this._jsel >= 0 ? (this._jsel > 0 && this._selItems.size() == 1 ? (org.zkoss.zul.Listitem)this._selItems.iterator().next() : this.getItemAtIndex(this._jsel)) : null;
    }

    public Listitem getSelectedItemApi() {
        return this.getSelectedItem();
    }

    public void setSelectedItem(org.zkoss.zul.Listitem item) {
        this.selectItem(item);
    }

    public void setSelectedItemApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.selectItem(item);
    }

    public void setSelectedItems(Set listItems) {
        if (!this.isMultiple()) {
            throw new WrongValueException("Listbox must allow multiple selections.");
        }
        Iterator it = listItems.iterator();
        while (it.hasNext()) {
            this.addItemToSelection((org.zkoss.zul.Listitem)it.next());
        }
    }

    public Set getSelectedItems() {
        return this._roSelItems;
    }

    public int getSelectedCount() {
        return this._selItems.size();
    }

    public org.zkoss.zul.Listitem appendItem(String label, String value) {
        org.zkoss.zul.Listitem item = new org.zkoss.zul.Listitem(label, value);
        item.applyProperties();
        item.setParent((Component)this);
        return item;
    }

    public Listitem appendItemApi(String label, String value) {
        return this.appendItem(label, value);
    }

    public org.zkoss.zul.Listitem removeItemAt(int index) {
        org.zkoss.zul.Listitem item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    public Listitem removeItemAtApi(int index) {
        return this.removeItemAt(index);
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this._pgi.setTotalSize(this.getDataLoader().getTotalSize());
                    this.addPagingListener(this._pgi);
                    if (this._pgi instanceof Component) {
                        this.smartUpdate("$u$paginal", ((Component)this._pgi).getUuid());
                    }
                }
            }
        }
    }

    private void newInternalPaging() {
        org.zkoss.zul.Paging paging = new org.zkoss.zul.Paging();
        paging.setAutohide(true);
        paging.setDetailed(true);
        paging.applyProperties();
        paging.setTotalSize(this.getDataLoader().getTotalSize());
        paging.setParent((Component)this);
        if (this._pgi != null) {
            this.addPagingListener(this._pgi);
        }
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new SerializableEventListener(){

                public void onEvent(Event event) {
                    PagingEvent evt = (PagingEvent)event;
                    Events.postEvent((Event)new PagingEvent(evt.getName(), (Component)Listbox.this, evt.getPageable(), evt.getActivePage()));
                }
            };
        }
        pgi.addEventListener("onPaging", this._pgListener);
        if (this._pgImpListener == null) {
            this._pgImpListener = new SerializableEventListener(){

                public void onEvent(Event event) {
                    if (Listbox.this._model != null && Listbox.this.inPagingMold()) {
                        Paginal pgi = Listbox.this.getPaginal();
                        int pgsz = pgi.getPageSize();
                        int ofs = pgi.getActivePage() * pgsz;
                        if (Listbox.this._rod) {
                            Listbox.this.getDataLoader().syncModel(ofs, pgsz);
                        }
                        Listbox.this.postOnPagingInitRender();
                    }
                    Listbox.this.invalidate();
                }
            };
        }
        pgi.addEventListener("onPagingImpl", this._pgImpListener);
    }

    private void removePagingListener(Paginal pgi) {
        pgi.removeEventListener("onPaging", this._pgListener);
        pgi.removeEventListener("onPagingImpl", this._pgImpListener);
    }

    public org.zkoss.zul.Paging getPagingChild() {
        return this._paging;
    }

    public Paging getPagingChildApi() {
        return this.getPagingChild();
    }

    protected Paginal pgi() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi;
    }

    public void setActivePage(org.zkoss.zul.Listitem item) {
        int pg;
        if (item != null && item.getParent() == this && (pg = item.getIndex() / this.getPageSize()) != this.getActivePage()) {
            this.setActivePage(pg);
        }
    }

    public void setActivePage(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.setActivePage(item);
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    public int getVisibleItemCount() {
        return this._visibleItemCount;
    }

    void addVisibleItemCount(int count) {
        if (count != 0) {
            this._visibleItemCount += count;
            if (this.inPagingMold()) {
                Paginal pgi = this.getPaginal();
                pgi.setTotalSize(this.getDataLoader().getTotalSize());
                this.invalidate();
            } else if (((Cropper)this.getDataLoader()).isCropper()) {
                this.getDataLoader().updateModelInfo();
            } else {
                this.smartUpdate("visibleItemCount", this._visibleItemCount);
            }
        }
    }

    public String getOddRowSclass() {
        return this._scOddRow == null ? this.getZclass() + "-odd" : this._scOddRow;
    }

    public void setOddRowSclass(String scls) {
        if (scls != null && scls.length() == 0) {
            scls = null;
        }
        if (!Objects.equals((Object)this._scOddRow, (Object)scls)) {
            this._scOddRow = scls;
            this.smartUpdate("oddRowSclass", scls);
        }
    }

    public int getGroupCount() {
        return this._groupsInfo.size();
    }

    public List getGroups() {
        return this._groups;
    }

    public boolean hasGroup() {
        return !this._groupsInfo.isEmpty();
    }

    void fixGroupIndex(int j, int to, boolean infront) {
        int realj = this.getRealIndex(j);
        if (realj < 0) {
            realj = 0;
        }
        if (realj < this._items.size()) {
            int beginning = j;
            ListIterator it = this._items.listIterator(realj);
            while (it.hasNext() && (to < 0 || j <= to)) {
                int[] g;
                Object o = it.next();
                ((org.zkoss.zul.Listitem)o).setIndexDirectly(j);
                if ((!infront || beginning != j) && o instanceof Listgroup && (g = this.getLastGroupsInfoAt(j + (infront ? -1 : 1))) != null) {
                    g[0] = j;
                    if (g[2] != -1) {
                        g[2] = g[2] + (infront ? 1 : -1);
                    }
                }
                ++j;
            }
        }
    }

    Listgroup getListgroupAt(int index) {
        if (this._groupsInfo.isEmpty()) {
            return null;
        }
        int[] g = this.getGroupsInfoAt(index);
        if (g != null) {
            return (Listgroup)this.getItemAtIndex(g[0]);
        }
        return null;
    }

    int getGroupIndex(int index) {
        int j = 0;
        int gindex = -1;
        int[] g = null;
        Iterator it = this._groupsInfo.iterator();
        while (it.hasNext()) {
            g = (int[])it.next();
            if (index == g[0]) {
                gindex = j;
            } else if (index < g[0]) break;
            ++j;
        }
        return gindex != -1 ? gindex : (g != null && index < g[0] + g[1] ? j - 1 : (g != null && index == g[0] + g[1] && g[2] == -1 ? j - 1 : gindex));
    }

    int[] getGroupsInfoAt(int index) {
        return this.getGroupsInfoAt(index, false);
    }

    int[] getLastGroupsInfoAt(int index) {
        int[] rg = null;
        Iterator it = this._groupsInfo.iterator();
        while (it.hasNext()) {
            int[] g = (int[])it.next();
            if (index == g[0]) {
                rg = g;
                continue;
            }
            if (index >= g[0]) continue;
            break;
        }
        return rg;
    }

    int[] getGroupsInfoAt(int index, boolean isListgroup) {
        Iterator it = this._groupsInfo.iterator();
        while (it.hasNext()) {
            int[] g = (int[])it.next();
            if (!(isListgroup ? index == g[0] : index > g[0] && index <= g[0] + g[1])) continue;
            return g;
        }
        return null;
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Listitem) {
            if (newChild instanceof Listgroup && this.inSelectMold()) {
                throw new UnsupportedOperationException("Unsupported Listgroup in Select mold!");
            }
            if (newChild instanceof Listgroupfoot) {
                if (!this.hasGroup()) {
                    throw new UiException("Listgroupfoot cannot exist alone, you have to add a Listgroup first");
                }
                if (refChild == null && this.getLastChild() instanceof Listgroupfoot) {
                    throw new UiException("Only one Listgroupfoot is allowed per Listgroup");
                }
            }
        } else if (newChild instanceof org.zkoss.zul.Listhead) {
            if (this._listhead != null && this._listhead != newChild) {
                throw new UiException("Only one listhead is allowed: " + this);
            }
        } else if (newChild instanceof Frozen) {
            if (this._frozen != null && this._frozen != newChild) {
                throw new UiException("Only one frozen child is allowed: " + this);
            }
            if (this.inSelectMold()) {
                log.warning("Mold select ignores frozen");
            }
        } else if (newChild instanceof org.zkoss.zul.Listfoot) {
            if (this._listfoot != null && this._listfoot != newChild) {
                throw new UiException("Only one listfoot is allowed: " + this);
            }
            if (this.inSelectMold()) {
                log.warning("Mold select ignores listfoot");
            }
        } else if (newChild instanceof org.zkoss.zul.Paging) {
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + this);
            }
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
        } else if (!(newChild instanceof Auxhead)) {
            throw new UiException("Unsupported child for Listbox: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    private boolean hasGroupsModel() {
        return this._model instanceof GroupsListModel;
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Listitem) {
            int jfrom;
            boolean isReorder;
            boolean bl = isReorder = newChild.getParent() == this;
            if (isReorder) {
                this.checkInvalidateForMoved((org.zkoss.zul.Listitem)newChild, true);
            }
            if (this._rod && this.hasGroupsModel()) {
                if (this._groupsInfo.isEmpty()) {
                    this._groupsInfo = ((GroupsListModel)this.getModel()).getGroupsInfo();
                }
                if (super.insertBefore(newChild, refChild = this.fixRefChildBeforeFoot((Component)refChild))) {
                    if (!isReorder) {
                        this.afterInsert(newChild);
                    }
                    return true;
                }
                return false;
            }
            if (newChild instanceof Listgroupfoot) {
                if (refChild == null) {
                    int idx;
                    int[] ginfo;
                    if (isReorder && (ginfo = this.getGroupsInfoAt(idx = ((Listgroupfoot)newChild).getIndex())) != null) {
                        ginfo[1] = ginfo[1] - 1;
                        ginfo[2] = -1;
                    }
                    int[] g = (int[])this._groupsInfo.get(this.getGroupCount() - 1);
                    g[2] = ((org.zkoss.zul.Listitem)this.getItems().get(this.getItems().size() - 1)).getIndex();
                } else if (refChild instanceof org.zkoss.zul.Listitem) {
                    int nindex;
                    int[] ginfo;
                    int idx = ((org.zkoss.zul.Listitem)refChild).getIndex();
                    int[] g = this.getGroupsInfoAt(idx);
                    if (g == null) {
                        throw new UiException("Listgroupfoot cannot exist alone, you have to add a Listgroup first");
                    }
                    if (g[2] != -1) {
                        throw new UiException("Only one Listgroupfoot is allowed per Listgroup");
                    }
                    if (idx != g[0] + g[1]) {
                        throw new UiException("Listgroupfoot must be placed after the last Row of the Listgroup");
                    }
                    g[2] = idx - 1;
                    if (isReorder && (ginfo = this.getGroupsInfoAt(nindex = ((Listgroupfoot)newChild).getIndex())) != null) {
                        ginfo[1] = ginfo[1] - 1;
                        ginfo[2] = -1;
                    }
                } else {
                    Component preRefChild = refChild.getPreviousSibling();
                    if (preRefChild instanceof org.zkoss.zul.Listitem) {
                        int nindex;
                        int[] ginfo;
                        int idx = ((org.zkoss.zul.Listitem)preRefChild).getIndex();
                        int[] g = this.getGroupsInfoAt(idx, preRefChild instanceof Listgroup);
                        if (g == null) {
                            throw new UiException("Listgroupfoot cannot exist alone, you have to add a Listgroup first");
                        }
                        if (g[2] != -1) {
                            throw new UiException("Only one Listgroupfoot is allowed per Listgroup");
                        }
                        if (idx + 1 != g[0] + g[1]) {
                            throw new UiException("Listgroupfoot must be placed after the last Row of the Listgroup");
                        }
                        g[2] = idx;
                        if (isReorder && (ginfo = this.getGroupsInfoAt(nindex = ((Listgroupfoot)newChild).getIndex())) != null) {
                            ginfo[1] = ginfo[1] - 1;
                            ginfo[2] = -1;
                        }
                    }
                }
            }
            if (refChild != null && refChild.getParent() != this) {
                refChild = null;
            }
            if (refChild != null && (refChild == this._listhead || refChild instanceof Auxhead)) {
                refChild = this.getChildren().size() > this._hdcnt ? (Component)this.getChildren().get(this._hdcnt) : null;
            }
            refChild = this.fixRefChildBeforeFoot((Component)refChild);
            org.zkoss.zul.Listitem newItem = (org.zkoss.zul.Listitem)newChild;
            int n = jfrom = newItem.getParent() == this ? newItem.getIndex() : -1;
            if (super.insertBefore(newChild, refChild)) {
                int index;
                int[] g;
                int fixFrom;
                int jto = refChild instanceof org.zkoss.zul.Listitem ? ((org.zkoss.zul.Listitem)refChild).getIndex() : -1;
                int n2 = fixFrom = jfrom < 0 || jto >= 0 && jfrom > jto ? jto : jfrom;
                if (fixFrom < 0) {
                    newItem.setIndexDirectly(this._items.size() - 1 + this.getDataLoader().getOffset());
                } else {
                    this.fixGroupIndex(fixFrom, jfrom >= 0 && jto >= 0 ? (jfrom > jto ? jfrom : jto) : -1, !isReorder);
                }
                int newIndex = newItem.getIndex();
                if (newItem.isSelected()) {
                    if (this._jsel < 0) {
                        this._jsel = newIndex;
                        this._selItems.add(newItem);
                        if (this._model instanceof Selectable) {
                            ((Selectable)((Object)this._model)).addSelection(this._model.getElementAt(this._jsel));
                        }
                    } else if (this._multiple) {
                        if (this._jsel > newIndex) {
                            this._jsel = newIndex;
                        }
                        this._selItems.add(newItem);
                        if (this._model instanceof Selectable) {
                            ((Selectable)((Object)this._model)).addSelection(this._model.getElementAt(this._jsel));
                        }
                    } else {
                        newItem.setSelectedDirectly(false);
                    }
                } else {
                    int oldjsel = this._jsel;
                    if (jfrom < 0) {
                        if (!this.isLoadingModel() && this._jsel >= newIndex) {
                            ++this._jsel;
                        }
                    } else if (this._jsel >= 0) {
                        if (jfrom > this._jsel) {
                            if (jto >= 0 && jto <= this._jsel) {
                                ++this._jsel;
                            }
                        } else if (jto < 0 || jto > this._jsel) {
                            --this._jsel;
                        }
                    }
                }
                if (newChild instanceof Listgroup) {
                    Listgroup lg = (Listgroup)newChild;
                    if (this._groupsInfo.isEmpty()) {
                        this._groupsInfo.add(new int[]{lg.getIndex(), this.getItemCount() - lg.getIndex(), -1});
                    } else {
                        int idx = 0;
                        int[] prev = null;
                        int[] next = null;
                        Iterator it = this._groupsInfo.iterator();
                        while (it.hasNext()) {
                            int[] g2 = (int[])it.next();
                            if (g2[0] <= lg.getIndex()) {
                                prev = g2;
                                ++idx;
                                continue;
                            }
                            next = g2;
                            break;
                        }
                        if (prev != null) {
                            int index2 = lg.getIndex();
                            int leng = index2 - prev[0];
                            int size = prev[1] - leng + 1;
                            prev[1] = leng;
                            this._groupsInfo.add(idx, new int[]{index2, size, size > 1 && prev[2] > index2 ? prev[2] : -1});
                            if (size > 1 && prev[2] > index2) {
                                prev[2] = -1;
                            }
                        } else if (next != null) {
                            this._groupsInfo.add(idx, new int[]{lg.getIndex(), next[0] - lg.getIndex(), -1});
                        }
                    }
                } else if (!this._groupsInfo.isEmpty() && (g = this.getGroupsInfoAt(index = newItem.getIndex())) != null) {
                    g[1] = g[1] + 1;
                    if (g[2] != -1 && (g[2] >= index || newItem instanceof Listgroupfoot)) {
                        g[2] = g[0] + g[1] - 1;
                    }
                }
                if (!isReorder) {
                    this.afterInsert(newChild);
                }
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Listhead) {
            boolean added = this._listhead == null;
            if (super.insertBefore(newChild, refChild = this.fixRefChildForHeader((Component)refChild))) {
                this._listhead = (org.zkoss.zul.Listhead)newChild;
                if (added) {
                    ++this._hdcnt;
                }
                return true;
            }
        } else if (newChild instanceof Auxhead) {
            boolean added = newChild.getParent() != this;
            if (super.insertBefore(newChild, refChild = this.fixRefChildForHeader((Component)refChild))) {
                if (added) {
                    ++this._hdcnt;
                }
                return true;
            }
        } else if (newChild instanceof Frozen) {
            refChild = this._paging;
            if (super.insertBefore(newChild, refChild)) {
                this._frozen = (Frozen)newChild;
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Listfoot) {
            refChild = this._frozen != null ? this._frozen : this._paging;
            if (super.insertBefore(newChild, refChild)) {
                this._listfoot = (org.zkoss.zul.Listfoot)newChild;
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Paging) {
            refChild = null;
            if (super.insertBefore(newChild, refChild)) {
                this._paging = (org.zkoss.zul.Paging)newChild;
                this._pgi = this._paging;
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    private Component fixRefChildForHeader(Component refChild) {
        if (refChild != null && refChild.getParent() != this) {
            refChild = null;
        }
        if (refChild == null || refChild != this._listhead && !(refChild instanceof Auxhead)) {
            refChild = this.getChildren().size() > this._hdcnt ? (Component)this.getChildren().get(this._hdcnt) : null;
        }
        refChild = this.fixRefChildBeforeFoot(refChild);
        return refChild;
    }

    private Component fixRefChildBeforeFoot(Component refChild) {
        if (refChild == null) {
            refChild = this._listfoot != null ? this._listfoot : (this._frozen != null ? this._frozen : this._paging);
        } else if (refChild == this._paging) {
            if (this._listfoot != null) {
                refChild = this._listfoot;
            } else if (this._frozen != null) {
                refChild = this._frozen;
            }
        }
        return refChild;
    }

    public boolean removeChild(Component child) {
        if (this._paging == child && this._pgi == child && this.inPagingMold()) {
            throw new IllegalStateException("The paging component cannot be removed manually. It is removed automatically when changing the mold");
        }
        if (child instanceof org.zkoss.zul.Listitem && child.getParent() == this) {
            this.beforeRemove(child);
        }
        if (!super.removeChild(child)) {
            return false;
        }
        if (this._listhead == child) {
            this._listhead = null;
            --this._hdcnt;
        } else if (this._listfoot == child) {
            this._listfoot = null;
        } else if (this._frozen == child) {
            this._frozen = null;
        } else if (child instanceof org.zkoss.zul.Listitem) {
            org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)child;
            int index = item.getIndex();
            item.setIndexDirectly(-1);
            if (item.isSelected()) {
                this._selItems.remove(item);
                if (this._jsel == index) {
                    this.fixSelectedIndex(index);
                }
            } else if (!this.isLoadingModel() && this._jsel >= index) {
                --this._jsel;
            }
            if (child instanceof Listgroup) {
                int[] prev = null;
                int[] remove = null;
                Iterator it = this._groupsInfo.iterator();
                while (it.hasNext()) {
                    int[] g = (int[])it.next();
                    if (g[0] == index) {
                        remove = g;
                        break;
                    }
                    prev = g;
                }
                if (prev != null && remove != null) {
                    prev[1] = prev[1] + (remove[1] - true);
                }
                this.fixGroupIndex(index, -1, false);
                if (remove != null) {
                    int realIndex;
                    this._groupsInfo.remove(remove);
                    int idx = remove[2];
                    if (idx != -1 && (realIndex = this.getRealIndex(idx) - 1) >= 0 && realIndex < this.getItemCount()) {
                        this.removeChild((Component)this.getChildren().get(realIndex));
                    }
                }
            } else if (!this._groupsInfo.isEmpty()) {
                int[] g1;
                int[] g = this.getGroupsInfoAt(index);
                if (g != null) {
                    g[1] = g[1] - 1;
                    if (g[2] != -1) {
                        g[2] = g[2] - 1;
                    }
                    this.fixGroupIndex(index, -1, false);
                } else {
                    this.fixGroupIndex(index, -1, false);
                }
                if (child instanceof Listgroupfoot && (g1 = this.getGroupsInfoAt(index)) != null) {
                    g1[2] = -1;
                }
            } else {
                this.fixItemIndices(index, -1);
            }
            if (this.hasGroupsModel() && this.getItemCount() <= 0) {
                this._groupsInfo = new LinkedList();
            }
        } else if (this._paging == child) {
            this._paging = null;
            if (this._pgi == child) {
                this._pgi = null;
            }
        } else if (child instanceof Auxhead) {
            --this._hdcnt;
        }
        if (((Cropper)this.getDataLoader()).isCropper()) {
            this.getDataLoader().updateModelInfo();
        }
        return true;
    }

    private boolean isSyncingModel() {
        return this.getAttribute(SYNCING_MODEL) != null;
    }

    protected void afterInsert(Component comp) {
        this.updateVisibleCount((org.zkoss.zul.Listitem)comp, false);
        this.checkInvalidateForMoved((org.zkoss.zul.Listitem)comp, false);
    }

    protected void beforeRemove(Component comp) {
        this.updateVisibleCount((org.zkoss.zul.Listitem)comp, true);
        this.checkInvalidateForMoved((org.zkoss.zul.Listitem)comp, true);
    }

    private void updateVisibleCount(org.zkoss.zul.Listitem item, boolean isRemove) {
        if (item instanceof Listgroup || item.isVisible()) {
            Listgroup g = this.getListgroupAt(item.getIndex());
            if (item instanceof Listgroupfoot || item instanceof Listgroup || g == null || g.isOpen()) {
                this.addVisibleItemCount(isRemove ? -1 : 1);
            }
            if (item instanceof Listgroup) {
                Listgroup group = (Listgroup)item;
                if (item.getPreviousSibling() instanceof org.zkoss.zul.Listitem) {
                    org.zkoss.zul.Listitem preRow = (org.zkoss.zul.Listitem)item.getPreviousSibling();
                    if (preRow == null) {
                        if (!group.isOpen()) {
                            this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                        }
                    } else {
                        Listgroup preGroup;
                        Listgroup listgroup = preGroup = preRow instanceof Listgroup ? (Listgroup)preRow : this.getListgroupAt(preRow.getIndex());
                        if (preGroup != null) {
                            if (!preGroup.isOpen() && group.isOpen()) {
                                this.addVisibleItemCount(isRemove ? -group.getVisibleItemCount() : group.getVisibleItemCount());
                            } else if (preGroup.isOpen() && !group.isOpen()) {
                                this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                            }
                        } else if (!group.isOpen()) {
                            this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                        }
                    }
                } else if (!group.isOpen()) {
                    this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                }
            }
        }
        if (this.inPagingMold()) {
            this.getPaginal().setTotalSize(this.getDataLoader().getTotalSize());
        }
    }

    private void checkInvalidateForMoved(org.zkoss.zul.Listitem child, boolean bRemove) {
        if (this.inPagingMold() && !this.isInvalidated()) {
            int j = child.getIndex();
            int pgsz = this.getPageSize();
            int n = (this.getActivePage() + 1) * pgsz;
            if (j >= n) {
                return;
            }
            int cnt = this.getItems().size();
            int n2 = n - pgsz;
            if (!(j < n2 || cnt > n || bRemove && cnt <= n2 + 1)) {
                return;
            }
            this.invalidate();
        }
    }

    private void fixSelectedIndex(int j) {
        if (!this._selItems.isEmpty()) {
            int realj = this.getRealIndex(j);
            if (realj < 0) {
                realj = 0;
            }
            if (realj < this._items.size()) {
                ListIterator it = this._items.listIterator(realj);
                while (it.hasNext()) {
                    org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)it.next();
                    if (item.isSelected()) {
                        this._jsel = j;
                        return;
                    }
                    ++j;
                }
            }
        }
        this._jsel = -1;
    }

    private void fixItemIndices(int j, int to) {
        int realj = this.getRealIndex(j);
        if (realj < 0) {
            realj = 0;
        }
        if (realj < this._items.size()) {
            ListIterator it = this._items.listIterator(realj);
            while (it.hasNext() && (to < 0 || j <= to)) {
                ((org.zkoss.zul.Listitem)it.next()).setIndexDirectly(j);
                ++j;
            }
        }
    }

    public ListModel getModel() {
        return this._model;
    }

    public ListModel getListModel() {
        return this._model instanceof GroupsListModel ? null : this._model;
    }

    public GroupsModel getGroupsModel() {
        return this._model instanceof GroupsListModel ? ((GroupsListModel)this._model).getGroupsModel() : null;
    }

    public void setModel(ListModel model) {
        if (model != null) {
            Execution exec;
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                    if (this._model instanceof GroupsListModel) {
                        this.getItems().clear();
                    }
                    this.resetDataLoader();
                } else {
                    this.getItems().clear();
                    if (!this.inSelectMold()) {
                        this.smartUpdate("model", true);
                    }
                }
                this._model = model;
                this.initDataListener();
            }
            boolean defer = (exec = Executions.getCurrent()) == null ? false : exec.getAttribute("zkoss.Listbox.deferInitModel_" + this.getUuid()) != null;
            boolean rod = this.evalRod();
            if (!defer || !rod) {
                this.getDataLoader().syncModel(-1, -1);
            } else if (this.inPagingMold()) {
                Paginal pgi = this.getPaginal();
                pgi.setTotalSize(this.getDataLoader().getTotalSize());
            }
            if (!Listbox.doSort(this)) {
                this.postOnInitRender();
            }
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            this.getItems().clear();
            if (!this.inSelectMold()) {
                this.smartUpdate("model", false);
            }
            this.getDataLoader().updateModelInfo();
        }
    }

    private static boolean doSort(Listbox listbox) {
        org.zkoss.zul.Listhead hds = listbox.getListhead();
        if (!listbox.isAutosort() || hds == null) {
            return false;
        }
        Iterator it = hds.getChildren().iterator();
        while (it.hasNext()) {
            Listheader hd = (Listheader)it.next();
            String dir = hd.getSortDirection();
            if ("natural".equals(dir)) continue;
            hd.doSort("ascending".equals(dir));
            return true;
        }
        return false;
    }

    public void setModel(GroupsModel model) {
        this.setModel(model != null ? new GroupsListModel(model) : null);
    }

    public ListitemRenderer getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ListitemRenderer renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            if (this._model != null) {
                if (renderer instanceof ListitemRendererExt || this._renderer instanceof ListitemRendererExt) {
                    this.getItems().clear();
                    this.getDataLoader().syncModel(-1, -1);
                } else if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
                    this.getDataLoader().syncModel(-1, -1);
                } else {
                    Execution exec = Executions.getCurrent();
                    boolean defer = exec == null ? false : exec.getAttribute("zkoss.Listbox.deferInitModel_" + this.getUuid()) != null;
                    boolean rod = this.evalRod();
                    if (!defer || !rod) {
                        this.getDataLoader().syncModel(-1, -1);
                    }
                }
            }
        }
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((ListitemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public int getPreloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        return size != null ? Integer.parseInt(size) : this._preloadsz;
    }

    public void setPreloadSize(int sz) {
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        this._preloadsz = sz;
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        this.doInitRenderer();
    }

    public void onPagingInitRender() {
        this.removeAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED);
        this.doInitRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitRenderer() {
        Renderer renderer = new Renderer();
        try {
            int ofs;
            int pgsz;
            if (this.inPagingMold()) {
                pgsz = this._pgi.getPageSize();
                ofs = this._pgi.getActivePage() * pgsz;
            } else {
                pgsz = this.inSelectMold() ? this.getItemCount() : this.getDataLoader().getLimit();
                ofs = this.inSelectMold() ? 0 : this.getDataLoader().getOffset();
            }
            int cnt = this.getItemCount() + this.getDataLoader().getOffset();
            if (ofs >= cnt && (ofs = cnt - pgsz) < 0) {
                ofs = 0;
            }
            int j = 0;
            int realOfs = ofs - this.getDataLoader().getOffset();
            if (realOfs < 0) {
                realOfs = 0;
            }
            boolean open = true;
            ListIterator it = this.getItems().listIterator(realOfs);
            while (j < pgsz && it.hasNext()) {
                org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)it.next();
                if (item.isVisible() && (open || item instanceof Listgroupfoot || item instanceof Listgroup)) {
                    renderer.render(item);
                    ++j;
                }
                if (!(item instanceof Listgroup)) continue;
                open = ((Listgroup)item).isOpen();
            }
            this.getDataLoader().updateModelInfo();
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    private void postOnPagingInitRender() {
        if (this.getAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED) == null && this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_PAGING_INIT_RENDERER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onPagingInitRender", (Component)this, null);
        }
    }

    private void onListDataChange(ListDataEvent event) {
        int type = event.getType();
        if (!(type != 1 && type != 0 || this.isIgnoreSortWhenChanged())) {
            Listbox.doSort(this);
        } else {
            this.getDataLoader().doListDataChange(event);
            this.postOnInitRender();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.zkoss.zul.Listitem renderItem(org.zkoss.zul.Listitem li) {
        if (this._model != null && li != null && !li.isLoaded()) {
            Renderer renderer = new Renderer();
            try {
                renderer.render(li);
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
        return li;
    }

    public Listitem renderItemApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        return this.renderItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAll() {
        if (this._model == null) {
            return;
        }
        this._renderAll = true;
        this.getDataLoader().setLoadAll(this._renderAll);
        Renderer renderer = new Renderer();
        try {
            Iterator it = this.getItems().iterator();
            while (it.hasNext()) {
                renderer.render((org.zkoss.zul.Listitem)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set items) {
        if (this._model == null) {
            return;
        }
        if (items.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                renderer.render((org.zkoss.zul.Listitem)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
                if (this.getModel() != null) {
                    this.getDataLoader().syncModel(0, this.initRodSize());
                    this.postOnInitRender();
                }
                this.invalidate();
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
                this._topPad = 0;
                this._currentTop = 0;
                this._currentLeft = 0;
                Events.postEvent((int)10001, (Event)new PagingEvent("onPagingImpl", (Component)this._pgi, this._pgi.getActivePage()));
                this.invalidate();
            }
        }
    }

    public String getEmptyMessage() {
        return this._emptyMessage;
    }

    public void setEmptyMessage(String emptyMessage) {
        if (!Objects.equals((Object)emptyMessage, (Object)this._emptyMessage)) {
            this._emptyMessage = emptyMessage;
            this.smartUpdate("emptyMessage", this._emptyMessage);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-listbox" : this._zclass;
    }

    private boolean evalRod() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.listbox.rod", false, true);
    }

    DataLoader getDataLoader() {
        if (this._dataLoader == null) {
            this._rod = this.evalRod();
            String loadercls = Library.getProperty((String)"org.zkoss.zul.listbox.DataLoader.class");
            try {
                this._dataLoader = this._rod && loadercls != null ? (DataLoader)Classes.forNameByThread((String)loadercls).newInstance() : new ListboxDataLoader();
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            this._dataLoader.init((Component)this, 0, this.initRodSize());
        }
        return this._dataLoader;
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (oldpage == null) {
            Execution exec = Executions.getCurrent();
            exec.setAttribute("zkoss.Listbox.deferInitModel_" + this.getUuid(), (Object)Boolean.TRUE);
            exec.setAttribute("zkoss.Listbox.attached_" + this.getUuid(), (Object)Boolean.TRUE);
            this._modelInitListener = new ModelInitListener();
            this.addEventListener("onInitModel", this._modelInitListener);
            Events.postEvent((int)20000, (Event)new Event("onInitModel", (Component)this));
        }
    }

    private void resetDataLoader() {
        if (this._dataLoader != null) {
            this._dataLoader.reset();
            this._dataLoader = null;
            this.smartUpdate("_lastoffset", 0);
        }
        this.smartUpdate("resetDataLoader", true);
        this._currentTop = 0;
        this._currentLeft = 0;
        this._topPad = 0;
    }

    public Object clone() {
        Listbox clone = (Listbox)super.clone();
        clone.init();
        clone._pgImpListener = null;
        clone._pgListener = null;
        clone.afterUnmarshal();
        if (clone._model != null) {
            clone._dataListener = null;
            clone.initDataListener();
            clone.getDataLoader().setLoadAll(this._renderAll);
        }
        return clone;
    }

    private void afterUnmarshal() {
        int offset = this.getDataLoader().getOffset();
        int limit = this.getDataLoader().getLimit();
        this.resetDataLoader();
        this.getDataLoader().init((Component)this, offset, limit);
        int index = offset;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof org.zkoss.zul.Listitem) {
                org.zkoss.zul.Listitem li = (org.zkoss.zul.Listitem)child;
                li.setIndexDirectly(index++);
                if (!li.isSelected()) continue;
                this._selItems.add(li);
                if (!(this._model instanceof Selectable)) continue;
                ((Selectable)((Object)this._model)).addSelection(this._model.getElementAt(index - 1));
                continue;
            }
            if (child instanceof org.zkoss.zul.Listhead) {
                this._listhead = (org.zkoss.zul.Listhead)child;
                continue;
            }
            if (child instanceof org.zkoss.zul.Listfoot) {
                this._listfoot = (org.zkoss.zul.Listfoot)child;
                continue;
            }
            if (child instanceof Frozen) {
                this._frozen = (Frozen)child;
                continue;
            }
            if (!(child instanceof org.zkoss.zul.Paging)) continue;
            this._paging = (org.zkoss.zul.Paging)child;
            this._pgi = this._paging;
            this.addPagingListener(this._pgi);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        Serializables.smartWrite((ObjectOutputStream)s, (Object)this._model);
        this.willSerialize(this._renderer);
        Serializables.smartWrite((ObjectOutputStream)s, (Object)this._renderer);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (ListModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (ListitemRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        this.init();
        this.afterUnmarshal();
        if (this._model != null) {
            this.initDataListener();
            this.getDataLoader().setLoadAll(this._renderAll);
        }
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._renderer);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._renderer);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._rows > 0) {
            renderer.render("rows", this.getRows());
        }
        this.render(renderer, "name", this._name);
        this.render(renderer, "emptyMessage", this._emptyMessage);
        if (this.inSelectMold()) {
            this.render(renderer, "multiple", this.isMultiple());
            this.render(renderer, "disabled", this.isDisabled());
            if (this._tabindex != 0) {
                renderer.render("tabindex", this._tabindex);
            }
            if (this._maxlength > 0) {
                renderer.render("maxlength", this._maxlength);
            }
        } else {
            this.render(renderer, "oddRowSclass", this._scOddRow);
            this.render(renderer, "checkmark", this.isCheckmark());
            this.render(renderer, "multiple", this.isMultiple());
            if (this._model != null) {
                this.render(renderer, "model", true);
            }
            if (!"100%".equals(this._innerWidth)) {
                this.render(renderer, "innerWidth", this._innerWidth);
            }
            if (this._currentTop != 0) {
                renderer.render("_currentTop", this._currentTop);
            }
            if (this._currentLeft != 0) {
                renderer.render("_currentLeft", this._currentLeft);
            }
            renderer.render("_topPad", this._topPad);
            renderer.render("_totalSize", this.getDataLoader().getTotalSize());
            renderer.render("_offset", this.getDataLoader().getOffset());
            if (this._rod) {
                int sz;
                if (((Cropper)this.getDataLoader()).isCropper()) {
                    renderer.render("_listbox$rod", true);
                }
                if ((sz = this.initRodSize()) != 100) {
                    renderer.render("initRodSize", this.initRodSize());
                }
                if (!this.inPagingMold() && this._jsel >= 0) {
                    renderer.render("_selInView", this._jsel);
                }
            }
            if (this._nonselTags != null) {
                renderer.render("nonselectableTags", this._nonselTags);
            }
            if (Listbox.isCheckmarkDeselectOther()) {
                renderer.render("_cdo", true);
            }
            if (!this.isRightSelect()) {
                renderer.render("rightSelect", false);
            }
            if (this.isListgroupSelectable()) {
                renderer.render("groupSelect", true);
            }
        }
        if (this._pgi != null && this._pgi instanceof Component) {
            renderer.render("$u$paginal", ((Component)this._pgi).getUuid());
        }
    }

    private boolean isRightSelect() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.listbox.rightSelect", true, true);
    }

    boolean isAutosort() {
        String attr = "org.zkoss.zul.listbox.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val instanceof Boolean ? (Boolean)val : (val != null ? "true".equals(val) || "ignore.change".equals(val) : false);
    }

    private int preloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        int sz = size != null ? Integer.parseInt(size) : this._preloadsz;
        if ((sz = Utils.getIntAttribute((Component)this, "org.zkoss.zul.listbox.preloadSize", sz, true)) < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        return sz;
    }

    private int initRodSize() {
        int sz = Utils.getIntAttribute((Component)this, "org.zkoss.zul.listbox.initRodSize", 100, true);
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        return sz;
    }

    private boolean isIgnoreSortWhenChanged() {
        String attr = "org.zkoss.zul.listbox.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val == null ? true : "ignore.change".equals(val);
    }

    private static boolean isCheckmarkDeselectOther() {
        if (_ckDeselectOther == null) {
            _ckDeselectOther = "true".equals(Library.getProperty((String)"org.zkoss.zul.listbox.checkmarkDeselectOthers"));
        }
        return _ckDeselectOther;
    }

    private boolean isListgroupSelectable() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.listbox.groupSelect", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onDataLoading")) {
            if (this._rod) {
                Executions.getCurrent().setAttribute("zkoss.zul.listbox.onDataLoading." + this.getUuid(), (Object)Boolean.TRUE);
            }
            Events.postEvent((Event)DataLoadingEvent.getDataLoadingEvent(request, this.preloadSize()));
        } else if (this.inPagingMold() && cmd.equals("onPageSize")) {
            int oldsize;
            Map data = request.getData();
            int size = AuRequests.getInt((Map)data, (String)"size", (int)(oldsize = this.getPageSize()));
            if (size != oldsize) {
                int begin = this.getActivePage() * oldsize;
                int end = begin + oldsize;
                end = Math.min(this.getPaginal().getTotalSize(), end);
                int sel = this.getSelectedIndex();
                if (sel < 0 || sel < begin || sel >= end) {
                    sel = size > oldsize ? end - 1 : begin;
                }
                int newpg = sel / size;
                this.setPageSize(size);
                this.setActivePage(newpg);
                Events.postEvent((Event)new PageSizeEvent(cmd, (Component)this, this.pgi(), size));
            }
        } else if (cmd.equals("onScrollPos")) {
            Map data = request.getData();
            this._currentTop = AuRequests.getInt((Map)data, (String)"top", (int)0);
            this._currentLeft = AuRequests.getInt((Map)data, (String)"left", (int)0);
        } else if (cmd.equals("onTopPad")) {
            this._topPad = AuRequests.getInt((Map)request.getData(), (String)"topPad", (int)0);
        } else if (cmd.equals("onSelect")) {
            if (this._rod && Executions.getCurrent().getAttribute("zkoss.zul.listbox.onDataLoading." + this.getUuid()) != null) {
                return;
            }
            SelectEvent evt = SelectEvent.getSelectEvent((AuRequest)request);
            Set selItems = evt.getSelectedItems();
            this.disableClientUpdate(true);
            try {
                if (AuRequests.getBoolean((Map)request.getData(), (String)"clearFirst")) {
                    this.clearSelection();
                }
                boolean paging = this.inPagingMold();
                if (!this._multiple || !paging && (selItems == null || selItems.size() <= 1)) {
                    org.zkoss.zul.Listitem item = selItems != null && selItems.size() > 0 ? (org.zkoss.zul.Listitem)selItems.iterator().next() : null;
                    this.selectItem(item);
                } else {
                    int to;
                    int from;
                    if (paging) {
                        Paginal pgi = this.getPaginal();
                        int pgsz = pgi.getPageSize();
                        from = pgi.getActivePage() * pgsz;
                        to = from + pgsz;
                    } else {
                        to = 0;
                        from = 0;
                    }
                    int j = 0;
                    Iterator it = this._items.iterator();
                    while (it.hasNext()) {
                        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)it.next();
                        if (selItems.contains(item)) {
                            this.addItemToSelection(item);
                        } else if (!paging) {
                            this.removeItemFromSelection(item);
                        } else {
                            int index = item.getIndex();
                            if (index >= from && index < to) {
                                this.removeItemFromSelection(item);
                            }
                        }
                        ++j;
                    }
                }
            }
            finally {
                this.disableClientUpdate(false);
            }
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onInnerWidth")) {
            String width = AuRequests.getInnerWidth((AuRequest)request);
            this._innerWidth = width == null ? "100%" : width;
        } else if (cmd.equals("onRender")) {
            Set items = AuRequests.convertToItems((Desktop)request.getDesktop(), (List)((List)request.getData().get("items")));
            int cnt = items.size();
            if (cnt == 0) {
                return;
            }
            if ((cnt = 20 - cnt) > 0 && this._preloadsz > 0) {
                org.zkoss.zul.Listitem li;
                if (cnt > this._preloadsz) {
                    cnt = this._preloadsz;
                }
                LinkedList<org.zkoss.zul.Listitem> toload = new LinkedList<org.zkoss.zul.Listitem>();
                Iterator it = this._items.iterator();
                while (it.hasNext() && !items.contains(li = (org.zkoss.zul.Listitem)it.next())) {
                    if (li.isLoaded()) continue;
                    toload.add(0, li);
                }
                if (!toload.isEmpty()) {
                    int bfcnt = cnt / 3;
                    Iterator e = toload.iterator();
                    while (bfcnt > 0 && e.hasNext()) {
                        items.add(e.next());
                        --bfcnt;
                        --cnt;
                    }
                }
                while (cnt > 0 && it.hasNext()) {
                    li = (org.zkoss.zul.Listitem)it.next();
                    if (li.isLoaded() || !items.add(li)) continue;
                    --cnt;
                }
            }
            this.renderItems(items);
        } else {
            super.service(request, everError);
        }
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        Listbox.addClientEvent((Class)Listbox.class, (String)"onRender", (int)8195);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onInnerWidth", (int)8193);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onSelect", (int)8193);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onFocus", (int)8192);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onBlur", (int)8192);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onScrollPos", (int)8193);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onTopPad", (int)8192);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onDataLoading", (int)8195);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onPageSize", (int)8195);
    }

    private class IterGroups
    implements Iterator {
        private final Iterator _it;
        private int _j;

        private IterGroups() {
            this._it = Listbox.this._groupsInfo.iterator();
        }

        public boolean hasNext() {
            return this._j < Listbox.this.getGroupCount();
        }

        public Object next() {
            org.zkoss.zul.Listitem o = Listbox.this.getItemAtIndex(((int[])this._it.next())[0]);
            ++this._j;
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Iter
    implements Iterator {
        private final Iterator _it;
        private int _j;

        private Iter() {
            this._it = Listbox.this.getChildren().iterator();
        }

        public boolean hasNext() {
            return this._j < Listbox.this._hdcnt;
        }

        public Object next() {
            Object o = this._it.next();
            ++this._j;
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Cropper,
    Padding {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Listbox.this);
        }

        public int getHeight() {
            return Listbox.this._topPad;
        }

        public void setHeight(int height) {
            Listbox.this._topPad = height;
        }

        public boolean isCropper() {
            return ((Cropper)Listbox.this.getDataLoader()).isCropper();
        }

        public Component getCropOwner() {
            return Listbox.this;
        }

        public Set getAvailableAtClient() {
            return ((Cropper)Listbox.this.getDataLoader()).getAvailableAtClient();
        }
    }

    private class ModelInitListener
    implements SerializableEventListener {
        private ModelInitListener() {
        }

        public void onEvent(Event event) throws Exception {
            if (Listbox.this._modelInitListener != null) {
                Listbox.this.removeEventListener("onInitModel", Listbox.this._modelInitListener);
                Listbox.this._modelInitListener = null;
            }
            if (Listbox.this._dataLoader != null) {
                boolean rod = Listbox.this.evalRod();
                if (Listbox.this._rod != rod || Listbox.this.getItems().isEmpty()) {
                    if (Listbox.this._model != null) {
                        Listbox.this.getItems().clear();
                        Listbox.this.resetDataLoader();
                        this.initModel();
                    } else {
                        Listbox.this.resetDataLoader();
                    }
                }
            } else if (Listbox.this._model != null) {
                this.initModel();
            } else {
                Executions.getCurrent().removeAttribute("zkoss.Listbox.deferInitModel_" + Listbox.this.getUuid());
            }
            DataLoader loader = Listbox.this.getDataLoader();
            Paginal pgi = Listbox.this.getPaginal();
            if (pgi != null) {
                pgi.setTotalSize(loader.getTotalSize());
            }
        }

        private void initModel() {
            Executions.getCurrent().removeAttribute("zkoss.Listbox.deferInitModel_" + Listbox.this.getUuid());
            Listbox.this.setModel(Listbox.this._model);
        }
    }

    private class ItemIter
    implements ListIterator,
    Serializable {
        private ListIterator _it;
        private int _j;
        private boolean _bNxt;

        private ItemIter(int index) {
            this._j = index;
        }

        public void add(Object o) {
            this.prepare();
            this._it.add(o);
            ++this._j;
        }

        public boolean hasNext() {
            return this._j < Listbox.this._items.size();
        }

        public boolean hasPrevious() {
            return this._j > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prepare();
            Object o = this._it.next();
            ++this._j;
            this._bNxt = true;
            return o;
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.prepare();
            Object o = this._it.previous();
            --this._j;
            this._bNxt = false;
            return o;
        }

        public int nextIndex() {
            return this._j;
        }

        public int previousIndex() {
            return this._j - 1;
        }

        public void remove() {
            if (this._it == null) {
                throw new IllegalStateException();
            }
            this._it.remove();
            if (this._bNxt) {
                --this._j;
            }
        }

        public void set(Object o) {
            if (this._it == null) {
                throw new IllegalStateException();
            }
            this._it.set(o);
        }

        private void prepare() {
            if (this._it == null) {
                this._it = Listbox.this.getChildren().listIterator(this._j + Listbox.this._hdcnt);
            }
        }
    }

    class Renderer {
        private final ListitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        Renderer() {
            this._renderer = (ListitemRenderer)Listbox.this.getDataLoader().getRealRenderer();
        }

        void render(org.zkoss.zul.Listitem item) throws Throwable {
            if (item.isLoaded()) {
                return;
            }
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            Listcell cell = (Listcell)item.getFirstChild();
            if (!(this._renderer instanceof ListitemRendererExt) || (((ListitemRendererExt)((Object)this._renderer)).getControls() & 1) != 0) {
                cell.detach();
            }
            Object value = Listbox.this._model.getElementAt(item.getIndex());
            if (Listbox.this._model instanceof Selectable && ((Selectable)((Object)Listbox.this._model)).getSelection().contains(value)) {
                Listbox.this.addItemToSelection(item);
            }
            try {
                this._renderer.render(item, value);
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error(t);
                }
                item.setLoaded(true);
                throw ex;
            }
            finally {
                if (item.getChildren().isEmpty()) {
                    cell.setParent((Component)item);
                }
            }
            item.setLoaded(true);
            this._rendered = true;
        }

        void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }

    private class VisibleChildrenIterator
    implements Iterator {
        private final ListIterator _it;
        private int _count;
        private boolean _isBeginning;

        private VisibleChildrenIterator() {
            this._it = Listbox.this.getItems().listIterator();
            this._count = 0;
            this._isBeginning = false;
        }

        private VisibleChildrenIterator(boolean isBeginning) {
            this._it = Listbox.this.getItems().listIterator();
            this._count = 0;
            this._isBeginning = false;
            this._isBeginning = isBeginning;
        }

        public boolean hasNext() {
            if (!Listbox.this.inPagingMold()) {
                return this._it.hasNext();
            }
            if (!this._isBeginning && this._count >= Listbox.this.getPaginal().getPageSize()) {
                return false;
            }
            if (this._count == 0 && !this._isBeginning) {
                Paginal pgi = Listbox.this.getPaginal();
                int begin = pgi.getActivePage() * pgi.getPageSize();
                for (int i = 0; i < begin && this._it.hasNext(); ++i) {
                    this.getVisibleRow((org.zkoss.zul.Listitem)this._it.next());
                }
            }
            return this._it.hasNext();
        }

        private org.zkoss.zul.Listitem getVisibleRow(org.zkoss.zul.Listitem item) {
            Listgroup g;
            if (item instanceof Listgroup && !(g = (Listgroup)item).isOpen()) {
                int len = g.getItemCount();
                for (int j = 0; j < len && this._it.hasNext(); ++j) {
                    this._it.next();
                }
            }
            while (!item.isVisible() && this._it.hasNext()) {
                item = (org.zkoss.zul.Listitem)this._it.next();
            }
            return item;
        }

        public Object next() {
            if (!Listbox.this.inPagingMold()) {
                return this._it.next();
            }
            ++this._count;
            org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)this._it.next();
            return this._it.hasNext() ? this.getVisibleRow(item) : item;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class Children
    extends AbstractComponent.Children {
        protected Children() {
            super((AbstractComponent)Listbox.this);
        }

        protected void removeRange(int fromIndex, int toIndex) {
            ListIterator it = this.listIterator(toIndex);
            int n = toIndex - fromIndex;
            while (--n >= 0 && it.hasPrevious()) {
                it.previous();
                it.remove();
            }
        }
    }
}

