/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.NumberInputElement;
import org.zkoss.zul.mesg.MZul;

public class Longbox
extends NumberInputElement
implements org.zkoss.zul.api.Longbox {
    public Longbox() {
        this.setCols(11);
    }

    public Longbox(long value) throws WrongValueException {
        this();
        this.setValue(new Long(value));
    }

    public Longbox(int value) throws WrongValueException {
        this();
        this.setValue(new Long(value));
    }

    public Long getValue() throws WrongValueException {
        return (Long)this.getTargetValue();
    }

    public long longValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? (Long)val : 0L;
    }

    public long intValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? (long)((Long)val).intValue() : 0L;
    }

    public void setValue(Long value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public String getZclass() {
        return this._zclass == null ? "z-longbox" : this._zclass;
    }

    protected Object marshall(Object value) {
        return value != null ? ((Long)value).toString() : value;
    }

    protected Object unmarshall(Object value) {
        return value != null ? new Long((String)value) : value;
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Object[] vals = this.toNumberOnly(value);
        String val = (String)vals[0];
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            long v;
            int divscale;
            int n = divscale = vals[1] != null ? (Integer)vals[1] : 0;
            for (v = Long.parseLong(val); v != 0L && --divscale >= 0; v /= 10L) {
            }
            return new Long(v);
        }
        catch (NumberFormatException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value));
        }
    }

    protected String coerceToString(Object value) {
        return value != null && this.getFormat() == null ? value.toString() : this.formatNumber(value, null);
    }
}

