/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.zkoss.zul.AbstractChartModel;
import org.zkoss.zul.HiLoModel;

public class SimpleHiLoModel
extends AbstractChartModel
implements HiLoModel {
    private static final long serialVersionUID = 20091008182747L;
    private Comparable _series;
    private List _hlTuples = new ArrayList(31);

    public Comparable getSeries() {
        return this._series;
    }

    public void setSeries(Comparable series) {
        this._series = series;
    }

    public int getDataCount() {
        return this._hlTuples.size();
    }

    public Date getDate(int index) {
        return ((HiLoTuple)this._hlTuples.get(index)).getDate();
    }

    public Number getOpen(int index) {
        return ((HiLoTuple)this._hlTuples.get(index)).getOpen();
    }

    public Number getHigh(int index) {
        return ((HiLoTuple)this._hlTuples.get(index)).getHigh();
    }

    public Number getLow(int index) {
        return ((HiLoTuple)this._hlTuples.get(index)).getLow();
    }

    public Number getClose(int index) {
        return ((HiLoTuple)this._hlTuples.get(index)).getClose();
    }

    public Number getVolume(int index) {
        return ((HiLoTuple)this._hlTuples.get(index)).getVolume();
    }

    public void addValue(Date date, Number open, Number high, Number low, Number close, Number volume) {
        this.addValue(date, open, high, low, close, volume, -1);
    }

    public void addValue(Date date, Number open, Number high, Number low, Number close, Number volume, int index) {
        this.addValue0(date, open, high, low, close, volume, index);
        this.fireEvent(0, null, null);
    }

    public void setValue(Date date, Number open, Number high, Number low, Number close, Number volume, int index) {
        this.removeValue0(index);
        this.addValue0(date, open, high, low, close, volume, index);
        this.fireEvent(0, null, null);
    }

    private void addValue0(Date date, Number open, Number high, Number low, Number close, Number volume, int index) {
        if (index >= 0) {
            this._hlTuples.add(index, new HiLoTuple(date, open, high, low, close, volume));
        } else {
            this._hlTuples.add(new HiLoTuple(date, open, high, low, close, volume));
        }
    }

    public void removeValue(int index) {
        this.removeValue0(index);
        this.fireEvent(2, null, null);
    }

    private void removeValue0(int index) {
        this._hlTuples.remove(index);
    }

    public void clear() {
        this._hlTuples.clear();
        this.fireEvent(2, null, null);
    }

    private static class HiLoTuple
    implements Serializable {
        private static final long serialVersionUID = 20091008182814L;
        private Date _date;
        private Number _open;
        private Number _high;
        private Number _low;
        private Number _close;
        private Number _volume;

        private HiLoTuple(Date date, Number open, Number high, Number low, Number close, Number volume) {
            this._date = date;
            this._open = open;
            this._high = high;
            this._low = low;
            this._close = close;
            this._volume = volume;
        }

        private Date getDate() {
            return this._date;
        }

        private Number getOpen() {
            return this._open;
        }

        private Number getHigh() {
            return this._high;
        }

        private Number getLow() {
            return this._low;
        }

        private Number getClose() {
            return this._close;
        }

        private Number getVolume() {
            return this._volume;
        }
    }
}

