/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.zul.AbstractChartModel;
import org.zkoss.zul.XYModel;

public class SimpleXYModel
extends AbstractChartModel
implements XYModel {
    private static final long serialVersionUID = 20091008182904L;
    protected Map _seriesMap = new HashMap(13);
    protected List _seriesList = new ArrayList(13);
    private boolean _autoSort = true;

    public Comparable getSeries(int index) {
        return (Comparable)this._seriesList.get(index);
    }

    public Collection getSeries() {
        return this._seriesList;
    }

    public int getDataCount(Comparable series) {
        List xyPairs = (List)this._seriesMap.get(series);
        return xyPairs != null ? xyPairs.size() : 0;
    }

    public Number getX(Comparable series, int index) {
        List xyPairs = (List)this._seriesMap.get(series);
        if (xyPairs != null) {
            return ((XYPair)xyPairs.get(index)).getX();
        }
        return null;
    }

    public Number getY(Comparable series, int index) {
        List xyPairs = (List)this._seriesMap.get(series);
        if (xyPairs != null) {
            return ((XYPair)xyPairs.get(index)).getY();
        }
        return null;
    }

    public void setValue(Comparable series, Number x, Number y, int index) {
        this.removeValue0(series, index);
        this.addValue0(series, x, y, index);
        this.fireEvent(0, series, null);
    }

    public void addValue(Comparable series, Number x, Number y) {
        this.addValue(series, x, y, -1);
    }

    public void addValue(Comparable series, Number x, Number y, int index) {
        this.addValue0(series, x, y, index);
        this.fireEvent(0, series, null);
    }

    private void addValue0(Comparable series, Number x, Number y, int index) {
        ArrayList<XYPair> xyPairs = (ArrayList<XYPair>)this._seriesMap.get(series);
        if (xyPairs == null) {
            xyPairs = new ArrayList<XYPair>(13);
            this._seriesMap.put(series, xyPairs);
            this._seriesList.add(series);
        }
        if (index >= 0) {
            xyPairs.add(index, new XYPair(x, y));
        } else {
            xyPairs.add(new XYPair(x, y));
        }
    }

    public void setAutoSort(boolean auto) {
        this._autoSort = auto;
    }

    public boolean isAutoSort() {
        return this._autoSort;
    }

    public void removeSeries(Comparable series) {
        this._seriesMap.remove(series);
        this._seriesList.remove(series);
        this.fireEvent(2, series, null);
    }

    public void removeValue(Comparable series, int index) {
        this.removeValue0(series, index);
        this.fireEvent(2, series, null);
    }

    private void removeValue0(Comparable series, int index) {
        List xyPairs = (List)this._seriesMap.get(series);
        if (xyPairs == null) {
            return;
        }
        xyPairs.remove(index);
    }

    public void clear() {
        this._seriesMap.clear();
        this._seriesList.clear();
        this.fireEvent(2, null, null);
    }

    protected static class XYPair
    implements Serializable {
        private static final long serialVersionUID = 20091008182941L;
        private Number _x;
        private Number _y;

        protected XYPair(Number x, Number y) {
            this._x = x;
            this._y = y;
        }

        public Number getX() {
            return this._x;
        }

        public Number getY() {
            return this._y;
        }
    }
}

