/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;

public class Style
extends AbstractComponent
implements org.zkoss.zul.api.Style {
    private String _src;
    private String _content;
    private String _media;

    public Style() {
        super.setVisible(false);
    }

    public Style(String src) {
        this();
        this.setSrc(src);
    }

    public Style(String src, String media) {
        this(src);
        this.setMedia(media);
    }

    public void setDynamic(boolean dynamic) {
    }

    public boolean isDynamic() {
        return true;
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._content != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._content = null;
            this.smartUpdate("src", new EncodedURL());
        }
    }

    public String getMedia() {
        return this._media;
    }

    public void setMedia(String media) {
        if (media != null && media.length() == 0) {
            media = null;
        }
        if (!Objects.equals((Object)this._media, (Object)media)) {
            this._media = media;
            this.smartUpdate("media", this._media);
        }
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content != null && content.length() == 0) {
            content = null;
        }
        if (this._src != null || !Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this._src = null;
            this.smartUpdate("content", this._content);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "media", this._media);
        String cnt = this.getContent();
        if (cnt != null) {
            this.render(renderer, "content", cnt);
        } else {
            this.render(renderer, "src", this.getEncodedURL());
        }
    }

    public boolean setVisible(boolean visible) {
        throw new UnsupportedOperationException("style is always invisible");
    }

    protected boolean isChildable() {
        return false;
    }

    private String getEncodedURL() {
        Desktop dt;
        if (this._src != null && (dt = this.getDesktop()) != null) {
            return dt.getExecution().encodeURL(this._src);
        }
        return "";
    }

    private class EncodedURL
    implements DeferredValue {
        private EncodedURL() {
        }

        public Object getValue() {
            return Style.this.getEncodedURL();
        }
    }
}

