/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.sys.ContentRenderer;

public class Timer
extends HtmlBasedComponent
implements org.zkoss.zul.api.Timer {
    private int _delay;
    private boolean _repeats;
    private boolean _running = true;

    public Timer() {
    }

    public Timer(int delay) {
        this();
        this._delay = Math.max(0, delay);
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int delay) {
        if ((delay = Math.max(0, delay)) != this._delay) {
            this._delay = delay;
            this.smartUpdate("delay", this._delay);
        }
    }

    public boolean isRepeats() {
        return this._repeats;
    }

    public void setRepeats(boolean repeats) {
        if (this._repeats != repeats) {
            this._repeats = repeats;
            this.smartUpdate("repeats", this._repeats);
        }
    }

    public boolean isRunning() {
        return this._running;
    }

    public void setRunning(boolean running) {
        if (running) {
            this.start();
        } else {
            this.stop();
        }
    }

    public void stop() {
        if (this._running) {
            this._running = false;
            this.smartUpdate("running", Boolean.FALSE, true);
        }
    }

    public void start() {
        if (!this._running) {
            this._running = true;
            this.smartUpdate("running", Boolean.TRUE, true);
        }
    }

    protected boolean isChildable() {
        return false;
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onTimer") && !this._repeats) {
            this._running = false;
        }
        super.service(request, everError);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "repeats", this._repeats);
        if (this._delay != 0) {
            renderer.render("delay", this._delay);
        }
        if (!this._running) {
            renderer.render("running", false);
        }
    }

    static {
        Timer.addClientEvent((Class)Timer.class, (String)"onTimer", (int)8192);
    }
}

