/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.OldTreeModels;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treecol;
import org.zkoss.zul.TreeitemRenderer;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.api.Paging;
import org.zkoss.zul.api.Treecols;
import org.zkoss.zul.api.Treefoot;
import org.zkoss.zul.api.Treeitem;
import org.zkoss.zul.event.PageSizeEvent;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.Openable;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.MeshElement;
import org.zkoss.zul.impl.Utils;

public class Tree
extends MeshElement
implements org.zkoss.zul.api.Tree {
    private static final Log log = Log.lookup((Class)Tree.class);
    private transient org.zkoss.zul.Treecols _treecols;
    private transient org.zkoss.zul.Treefoot _treefoot;
    private transient Treechildren _treechildren;
    private transient Set _selItems;
    private transient org.zkoss.zul.Treeitem _sel;
    private transient Collection _heads;
    private int _rows = 0;
    private String _name;
    private boolean _multiple;
    private boolean _checkmark;
    private boolean _vflex;
    private String _innerWidth = "100%";
    private transient TreeModel _model;
    private transient TreeitemRenderer _renderer;
    private transient TreeDataListener _dataListener;
    private transient Paginal _pgi;
    private String _nonselTags;
    private transient org.zkoss.zul.Paging _paging;
    private EventListener _pgListener;
    private EventListener _pgImpListener;
    private int _currentTop = 0;
    private int _currentLeft = 0;
    private static final TreeitemRenderer _defRend;
    private static Boolean _ckDeselectOther;

    public Tree() {
        this.init();
    }

    private void init() {
        this._selItems = new LinkedHashSet(5);
        this._heads = new AbstractCollection(){

            public int size() {
                int sz = Tree.this.getChildren().size();
                if (Tree.this._treechildren != null) {
                    --sz;
                }
                if (Tree.this._treefoot != null) {
                    --sz;
                }
                if (Tree.this._paging != null) {
                    --sz;
                }
                return sz;
            }

            public Iterator iterator() {
                return new Iter();
            }
        };
    }

    void addVisibleItemCount(int count) {
        if (this.inPagingMold()) {
            Paginal pgi = this.getPaginal();
            pgi.setTotalSize(pgi.getTotalSize() + count);
            this.invalidate();
        }
    }

    Map getVisibleItems() {
        HashMap map = new HashMap();
        Paginal pgi = this.getPaginal();
        int pgsz = pgi.getPageSize();
        int ofs = pgi.getActivePage() * pgsz;
        int[] data = new int[]{pgsz, ofs, 0, 0, 0};
        this.getVisibleItemsDFS(this.getChildren(), map, data);
        return map;
    }

    private boolean getVisibleItemsDFS(List list, Map map, int[] data) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Component cmp = (Component)it.next();
            if (cmp instanceof org.zkoss.zul.Treeitem) {
                if (data[4] >= data[0]) {
                    return false;
                }
                org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)cmp;
                if (!item.isRealVisible()) continue;
                int count = item.isOpen() && item.getTreechildren() != null ? item.getTreechildren().getVisibleItemCount() : 0;
                boolean shoulbBeVisited = data[1] < data[2] + 1 + count;
                data[2] = data[2] + (shoulbBeVisited ? 1 : count + 1);
                data[3] = data[3] + (count + 1);
                if (!shoulbBeVisited) continue;
                if (data[1] < data[2]) {
                    data[4] = data[4] + 1;
                    map.put(item, Boolean.TRUE);
                }
                if (!item.isOpen()) continue;
                if (!this.getVisibleItemsDFS(item.getChildren(), map, data)) {
                    return false;
                }
                map.put(item, Boolean.TRUE);
                continue;
            }
            if (!(cmp instanceof Treechildren) || this.getVisibleItemsDFS(cmp.getChildren(), map, data)) continue;
            return false;
        }
        return true;
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
                this.invalidate();
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
                this.setFixedLayout(true);
                this._currentTop = 0;
                this._currentLeft = 0;
                this.invalidate();
            }
        }
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this._pgi.setTotalSize(this.getItemCount());
                    this.addPagingListener(this._pgi);
                    if (this._pgi instanceof Component) {
                        this.smartUpdate("$u$paginal", ((Component)this._pgi).getUuid());
                    }
                }
            }
        }
    }

    private void newInternalPaging() {
        org.zkoss.zul.Paging paging = new org.zkoss.zul.Paging();
        paging.setAutohide(true);
        paging.setDetailed(true);
        paging.applyProperties();
        paging.setTotalSize(this.getVisibleItemCount());
        paging.setParent((Component)this);
        if (this._pgi != null) {
            this.addPagingListener(this._pgi);
        }
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new SerializableEventListener(){

                public void onEvent(Event event) {
                    PagingEvent evt = (PagingEvent)event;
                    Events.postEvent((Event)new PagingEvent(evt.getName(), (Component)Tree.this, evt.getPageable(), evt.getActivePage()));
                }
            };
        }
        pgi.addEventListener("onPaging", this._pgListener);
        if (this._pgImpListener == null) {
            this._pgImpListener = new SerializableEventListener(){

                public void onEvent(Event event) {
                    if (Tree.this.inPagingMold()) {
                        Tree.this.invalidate();
                    }
                }
            };
        }
        pgi.addEventListener("onPagingImpl", this._pgImpListener);
    }

    private void removePagingListener(Paginal pgi) {
        pgi.removeEventListener("onPaging", this._pgListener);
        pgi.removeEventListener("onPagingImpl", this._pgImpListener);
    }

    public org.zkoss.zul.Paging getPagingChild() {
        return this._paging;
    }

    public Paging getPagingChildApi() {
        return this.getPagingChild();
    }

    public int getPageSize() {
        return this.inPagingMold() ? this.pgi().getPageSize() : 0;
    }

    public void setPageSize(int pgsz) throws WrongValueException {
        if (pgsz < 0 || !this.inPagingMold()) {
            return;
        }
        this.pgi().setPageSize(pgsz);
    }

    protected Paginal pgi() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi;
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    private int getVisibleItemCount() {
        return this._treechildren != null ? this._treechildren.getVisibleItemCount() : 0;
    }

    public void setFixedLayout(boolean fixedLayout) {
        this.setSizedByContent(!fixedLayout);
    }

    public boolean isFixedLayout() {
        return !this.isSizedByContent();
    }

    public org.zkoss.zul.Treecols getTreecols() {
        return this._treecols;
    }

    public Treecols getTreecolsApi() {
        return this.getTreecols();
    }

    public org.zkoss.zul.Treefoot getTreefoot() {
        return this._treefoot;
    }

    public Treefoot getTreefootApi() {
        return this.getTreefoot();
    }

    public Treechildren getTreechildren() {
        return this._treechildren;
    }

    public org.zkoss.zul.api.Treechildren getTreechildrenApi() {
        return this.getTreechildren();
    }

    public Collection getHeads() {
        return this._heads;
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows < 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            this.smartUpdate("rows", this._rows);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", name);
        }
    }

    public void setNonselectableTags(String tags) {
        if (!Objects.equals((Object)this._nonselTags, (Object)tags)) {
            this._nonselTags = tags;
            this.smartUpdate("nonselectableTags", tags);
        }
    }

    public String getNonselectableTags() {
        return this._nonselTags;
    }

    public boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            this.smartUpdate("checkmark", checkmark);
        }
    }

    public boolean isVflex() {
        return this._vflex;
    }

    public void setVflex(boolean vflex) {
        if (this._vflex != vflex) {
            this._vflex = vflex;
            this.smartUpdate("vflex", this._vflex);
        }
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    public String getSeltype() {
        return this._multiple ? "multiple" : "single";
    }

    public void setSeltype(String seltype) throws WrongValueException {
        if ("single".equals(seltype)) {
            this.setMultiple(false);
        } else if ("multiple".equals(seltype)) {
            this.setMultiple(true);
        } else {
            throw new WrongValueException("Unknown seltype: " + seltype);
        }
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            if (!this._multiple && this._selItems.size() > 1) {
                org.zkoss.zul.Treeitem item = this.getSelectedItem();
                Iterator it = this._selItems.iterator();
                while (it.hasNext()) {
                    org.zkoss.zul.Treeitem ti = (org.zkoss.zul.Treeitem)it.next();
                    if (ti == item) continue;
                    ti.setSelectedDirectly(false);
                    it.remove();
                }
            }
            this.smartUpdate("multiple", this._multiple);
        }
    }

    public void setActivePage(org.zkoss.zul.Treeitem item) {
        Paginal pgi;
        int pg;
        int index;
        if (item.isRealVisible() && item.getTree() == this && this.isVisible() && (index = this.getVisibleIndexOfItem(item)) != -1 && (pg = index / (pgi = this.getPaginal()).getPageSize()) != this.getActivePage()) {
            this.setActivePage(pg);
        }
    }

    public void setActivePageApi(Treeitem itemApi) {
        org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)itemApi;
        this.setActivePage(item);
    }

    private int getVisibleIndexOfItem(org.zkoss.zul.Treeitem item) {
        int count = this.getVisibleIndexOfItem0(item, false);
        if (count <= 0) {
            return -1;
        }
        return --count;
    }

    private int getVisibleIndexOfItem0(org.zkoss.zul.Treeitem item, boolean inclusive) {
        int c;
        if (item == null) {
            return 0;
        }
        int count = 0;
        if (item.isRealVisible()) {
            ++count;
            if (inclusive && item.isOpen() && item.getTreechildren() != null) {
                count += item.getTreechildren().getVisibleItemCount();
            }
        }
        if ((c = this.getVisibleIndexOfItem0((org.zkoss.zul.Treeitem)item.getPreviousSibling(), true)) == -1) {
            return -1;
        }
        if (c != 0) {
            count += c;
        } else {
            Component cmp = item.getParent().getParent();
            if (cmp instanceof org.zkoss.zul.Treeitem) {
                org.zkoss.zul.Treeitem parent = (org.zkoss.zul.Treeitem)cmp;
                if (parent.isRealVisible()) {
                    parent.setOpen(true);
                    int cnt = this.getVisibleIndexOfItem0(parent, false);
                    if (cnt == -1) {
                        return -1;
                    }
                    count += cnt;
                } else {
                    return -1;
                }
            }
        }
        return count;
    }

    public void smartUpdate(String attr, Object value) {
        super.smartUpdate(attr, value);
    }

    public Collection getItems() {
        return this._treechildren != null ? this._treechildren.getItems() : Collections.EMPTY_LIST;
    }

    public int getItemCount() {
        return this._treechildren != null ? this._treechildren.getItemCount() : 0;
    }

    public void selectItem(org.zkoss.zul.Treeitem item) {
        if (item == null) {
            this.clearSelection();
        } else {
            if (item.getTree() != this) {
                throw new UiException("Not a child: " + item);
            }
            if (this._sel != item || this._multiple && this._selItems.size() > 1) {
                Iterator it = this._selItems.iterator();
                while (it.hasNext()) {
                    org.zkoss.zul.Treeitem ti = (org.zkoss.zul.Treeitem)it.next();
                    ti.setSelectedDirectly(false);
                }
                this._selItems.clear();
                this._sel = item;
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                if (this._model instanceof Selectable) {
                    Selectable sltb = (Selectable)((Object)this._model);
                    sltb.clearSelection();
                    sltb.addSelection(item.getTreeNode());
                }
                this.smartUpdate("selectedItem", item.getUuid());
            }
            if (this.inPagingMold()) {
                this.setActivePage(item);
            }
        }
    }

    public void selectItemApi(Treeitem itemApi) {
        org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)itemApi;
        this.selectItem(item);
    }

    public void addItemToSelection(org.zkoss.zul.Treeitem item) {
        if (item.getTree() != this) {
            throw new UiException("Not a child: " + item);
        }
        if (!item.isSelected()) {
            if (!this._multiple) {
                this.selectItem(item);
            } else {
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                if (this._model instanceof Selectable) {
                    ((Selectable)((Object)this._model)).addSelection(item.getTreeNode());
                }
                if (this._sel == null) {
                    this._sel = (org.zkoss.zul.Treeitem)this._selItems.iterator().next();
                }
                this.smartUpdateSelection();
            }
        }
    }

    public void addItemToSelectionApi(Treeitem itemApi) {
        org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)itemApi;
        this.addItemToSelection(item);
    }

    public void removeItemFromSelection(org.zkoss.zul.Treeitem item) {
        if (item.getTree() != this) {
            throw new UiException("Not a child: " + item);
        }
        if (item.isSelected()) {
            if (!this._multiple) {
                this.clearSelection();
            } else {
                item.setSelectedDirectly(false);
                this._selItems.remove(item);
                if (this._sel == item) {
                    org.zkoss.zul.Treeitem treeitem = this._sel = this._selItems.size() > 0 ? (org.zkoss.zul.Treeitem)this._selItems.iterator().next() : null;
                }
                if (this._model instanceof Selectable) {
                    ((Selectable)((Object)this._model)).removeSelection(item.getTreeNode());
                }
                this.smartUpdateSelection();
            }
        }
    }

    public void removeItemFromSelectionApi(Treeitem itemApi) {
        org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)itemApi;
        this.removeItemFromSelection(item);
    }

    private void smartUpdateSelection() {
        StringBuffer sb = new StringBuffer(80);
        Iterator it = this._selItems.iterator();
        while (it.hasNext()) {
            org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)it.next();
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(item.getUuid());
        }
        this.smartUpdate("chgSel", sb.toString());
    }

    public void toggleItemSelection(org.zkoss.zul.Treeitem item) {
        if (item.isSelected()) {
            this.removeItemFromSelection(item);
        } else {
            this.addItemToSelection(item);
        }
    }

    public void toggleItemSelectionApi(Treeitem itemApi) {
        org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)itemApi;
        this.toggleItemSelection(item);
    }

    public void clearSelection() {
        if (!this._selItems.isEmpty()) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)it.next();
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._sel = null;
            this.smartUpdate("selectedItem", "");
        }
        if (this._model instanceof Selectable) {
            ((Selectable)((Object)this._model)).clearSelection();
        }
    }

    public void selectAll() {
        if (!this._multiple) {
            throw new UiException("Appliable only to the multiple seltype: " + this);
        }
        boolean changed = false;
        boolean first = true;
        Iterator it = this.getItems().iterator();
        while (it.hasNext()) {
            org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)it.next();
            if (!item.isSelected()) {
                this._selItems.add(item);
                item.setSelectedDirectly(true);
                changed = true;
                if (this._model instanceof Selectable) {
                    ((Selectable)((Object)this._model)).addSelection(item.getTreeNode());
                }
            }
            if (!first) continue;
            this._sel = item;
            first = false;
        }
        this.smartUpdate("selectAll", true);
    }

    public org.zkoss.zul.Treeitem getSelectedItem() {
        return this._sel;
    }

    public Treeitem getSelectedItemApi() {
        return this.getSelectedItem();
    }

    public void setSelectedItem(org.zkoss.zul.Treeitem item) {
        this.selectItem(item);
    }

    public void setSelectedItemApi(Treeitem itemApi) {
        org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)itemApi;
        this.setSelectedItem(item);
    }

    public Set getSelectedItems() {
        return Collections.unmodifiableSet(this._selItems);
    }

    public int getSelectedCount() {
        return this._selItems.size();
    }

    public void clear() {
        if (this._treechildren == null) {
            return;
        }
        List l = this._treechildren.getChildren();
        if (l.isEmpty()) {
            return;
        }
        Iterator it = new ArrayList(l).iterator();
        while (it.hasNext()) {
            ((Component)it.next()).detach();
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-tree" : this._zclass;
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Treecols) {
            if (this._treecols != null && this._treecols != newChild) {
                throw new UiException("Only one treecols is allowed: " + this);
            }
        } else if (newChild instanceof org.zkoss.zul.Treefoot) {
            if (this._treefoot != null && this._treefoot != newChild) {
                throw new UiException("Only one treefoot is allowed: " + this);
            }
        } else if (newChild instanceof Treechildren) {
            if (this._treechildren != null && this._treechildren != newChild) {
                throw new UiException("Only one treechildren is allowed: " + this);
            }
        } else if (newChild instanceof org.zkoss.zul.Paging) {
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + this);
            }
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
        } else if (!(newChild instanceof Auxhead)) {
            throw new UiException("Unsupported newChild: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Treecols) {
            if (super.insertBefore(newChild, refChild)) {
                this._treecols = (org.zkoss.zul.Treecols)newChild;
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Treefoot) {
            refChild = this._paging;
            if (super.insertBefore(newChild, refChild)) {
                this._treefoot = (org.zkoss.zul.Treefoot)newChild;
                return true;
            }
        } else if (newChild instanceof Treechildren) {
            if (super.insertBefore(newChild, refChild)) {
                this._treechildren = (Treechildren)newChild;
                this.fixSelectedSet();
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Paging) {
            refChild = null;
            if (super.insertBefore(newChild, refChild)) {
                this._paging = (org.zkoss.zul.Paging)newChild;
                this._pgi = this._paging;
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    void onTreeitemAdded(org.zkoss.zul.Treeitem item) {
        this.fixNewChild(item);
        this.onTreechildrenAdded(item.getTreechildren());
    }

    void onTreeitemRemoved(org.zkoss.zul.Treeitem item) {
        boolean fixSel = false;
        if (item.isSelected()) {
            this._selItems.remove(item);
            boolean bl = fixSel = this._sel == item;
            if (fixSel && !this._multiple) {
                this._sel = null;
            }
        }
        this.onTreechildrenRemoved(item.getTreechildren());
        if (fixSel) {
            this.fixSelected();
        }
    }

    void onTreechildrenAdded(Treechildren tchs) {
        if (tchs == null || tchs.getParent() == this) {
            return;
        }
        Iterator it = tchs.getItems().iterator();
        while (it.hasNext()) {
            this.fixNewChild((org.zkoss.zul.Treeitem)it.next());
        }
    }

    private void fixNewChild(org.zkoss.zul.Treeitem item) {
        if (item.isSelected()) {
            if (this._sel != null && !this._multiple) {
                item.setSelectedDirectly(false);
                item.invalidate();
            } else {
                if (this._sel == null) {
                    this._sel = item;
                }
                this._selItems.add(item);
                if (this._model instanceof Selectable) {
                    ((Selectable)((Object)this._model)).addSelection(item.getTreeNode());
                }
            }
        }
    }

    void onTreechildrenRemoved(Treechildren tchs) {
        if (tchs == null || tchs.getParent() == this) {
            return;
        }
        boolean fixSel = false;
        Iterator it = tchs.getItems().iterator();
        while (it.hasNext()) {
            org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)it.next();
            if (!item.isSelected()) continue;
            this._selItems.remove(item);
            if (this._sel != item) continue;
            if (!this._multiple) {
                this._sel = null;
                return;
            }
            fixSel = true;
        }
        if (fixSel) {
            this.fixSelected();
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        if (child instanceof Treechildren) {
            this.addVisibleItemCount(((Treechildren)child).getVisibleItemCount());
        }
    }

    public void onChildRemoved(Component child) {
        if (child instanceof org.zkoss.zul.Treecols) {
            this._treecols = null;
        } else if (child instanceof org.zkoss.zul.Treefoot) {
            this._treefoot = null;
        } else if (child instanceof Treechildren) {
            this._treechildren = null;
            this._selItems.clear();
            this._sel = null;
            this.addVisibleItemCount(-((Treechildren)child).getVisibleItemCount());
        } else if (this._paging == child) {
            this._paging = null;
            if (this._pgi == child) {
                this._pgi = null;
            }
        }
        super.onChildRemoved(child);
    }

    private void fixSelectedSet() {
        this._sel = null;
        this._selItems.clear();
        Iterator it = this.getItems().iterator();
        while (it.hasNext()) {
            org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)it.next();
            if (!item.isSelected()) continue;
            if (this._sel == null) {
                this._sel = item;
            } else if (!this._multiple) {
                item.setSelectedDirectly(false);
                continue;
            }
            this._selItems.add(item);
        }
    }

    private boolean fixSelected() {
        org.zkoss.zul.Treeitem sel = null;
        block0 : switch (this._selItems.size()) {
            case 1: {
                sel = (org.zkoss.zul.Treeitem)this._selItems.iterator().next();
            }
            case 0: {
                break;
            }
            default: {
                Iterator it = this.getItems().iterator();
                while (it.hasNext()) {
                    org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)it.next();
                    if (!item.isSelected()) continue;
                    sel = item;
                    break block0;
                }
                break block0;
            }
        }
        if (sel != this._sel) {
            this._sel = sel;
            return true;
        }
        return false;
    }

    public Object clone() {
        int cntSel = this._selItems.size();
        Tree clone = (Tree)super.clone();
        clone.init();
        clone._pgImpListener = null;
        clone._pgListener = null;
        int cnt = 0;
        if (this._treecols != null) {
            ++cnt;
        }
        if (this._treefoot != null) {
            ++cnt;
        }
        if (this._treechildren != null) {
            ++cnt;
        }
        if (this._paging != null) {
            ++cnt;
        }
        if (cnt > 0 || cntSel > 0) {
            clone.afterUnmarshal(cnt, cntSel);
        }
        if (clone._model != null) {
            clone._dataListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private void afterUnmarshal(int cnt, int cntSel) {
        Iterator it;
        if (cnt != 0) {
            it = this.getChildren().iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (child instanceof org.zkoss.zul.Treecols) {
                    this._treecols = (org.zkoss.zul.Treecols)child;
                    if (--cnt != 0) continue;
                    break;
                }
                if (child instanceof org.zkoss.zul.Treefoot) {
                    this._treefoot = (org.zkoss.zul.Treefoot)child;
                    if (--cnt != 0) continue;
                    break;
                }
                if (child instanceof Treechildren) {
                    this._treechildren = (Treechildren)child;
                    if (--cnt != 0) continue;
                    break;
                }
                if (!(child instanceof org.zkoss.zul.Paging)) continue;
                this._paging = (org.zkoss.zul.Paging)child;
                this._pgi = this._paging;
                this.addPagingListener(this._pgi);
                if (--cnt != 0) continue;
                break;
            }
        }
        this._sel = null;
        this._selItems.clear();
        if (cntSel != 0) {
            it = this.getItems().iterator();
            while (it.hasNext()) {
                org.zkoss.zul.Treeitem ti = (org.zkoss.zul.Treeitem)it.next();
                if (!ti.isSelected()) continue;
                if (this._sel == null) {
                    this._sel = ti;
                }
                this._selItems.add(ti);
                if (this._model instanceof Selectable) {
                    ((Selectable)((Object)this._model)).addSelection(ti.getTreeNode());
                }
                if (--cntSel != 0) continue;
                break;
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        Serializables.smartWrite((ObjectOutputStream)s, (Object)this._model);
        this.willSerialize(this._renderer);
        Serializables.smartWrite((ObjectOutputStream)s, (Object)this._renderer);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (TreeModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (TreeitemRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        this.init();
        this.afterUnmarshal(-1, -1);
        if (this._model != null) {
            this.initDataListener();
        }
    }

    private void onTreeDataChange(TreeDataEvent event) {
        Object node = event.getParent();
        Component parent = this.getChildByNode(node);
        if (parent != null) {
            int indexFrom = event.getIndexFrom();
            int indexTo = event.getIndexTo();
            int type = event.getType();
            if (!(type != 1 && type != 0 || this.isIgnoreSortWhenChanged())) {
                Tree.doSort(this);
            }
            switch (type) {
                case 1: {
                    for (int i = indexFrom; i <= indexTo; ++i) {
                        this.onTreeDataInsert(parent, node, i);
                    }
                    break;
                }
                case 2: {
                    for (int i = indexTo; i >= indexFrom; --i) {
                        this.onTreeDataRemoved(parent, node, i);
                    }
                    break;
                }
                case 0: {
                    for (int i = indexFrom; i <= indexTo; ++i) {
                        this.onTreeDataContentChange(parent, node, i);
                    }
                    break;
                }
                case 3: {
                    this.renderTree();
                }
            }
        }
    }

    private static Treechildren treechildrenOf(Component parent) {
        Treechildren tc;
        Treechildren treechildren = tc = parent instanceof Tree ? ((Tree)parent).getTreechildren() : ((org.zkoss.zul.Treeitem)parent).getTreechildren();
        if (tc == null) {
            tc = new Treechildren();
            tc.setParent(parent);
        }
        return tc;
    }

    private void onTreeDataInsert(Component parent, Object node, int index) {
        Treechildren tc;
        org.zkoss.zul.Treeitem newTi = this.newUnloadedItem();
        List siblings = (tc = Tree.treechildrenOf(parent)).getChildren();
        tc.insertBefore((Component)newTi, (Component)(siblings.isEmpty() || index == siblings.size() ? null : (org.zkoss.zul.Treeitem)siblings.get(index)));
        this.renderChangedItem(newTi, this._model.getChild(node, index));
    }

    private void onTreeDataRemoved(Component parent, Object node, int index) {
        Treechildren tc = Tree.treechildrenOf(parent);
        List items = tc.getChildren();
        if (items.size() > 1) {
            ((org.zkoss.zul.Treeitem)items.get(index)).detach();
        } else {
            tc.detach();
        }
    }

    private void onTreeDataContentChange(Component parent, Object node, int index) {
        List items = Tree.treechildrenOf(parent).getChildren();
        if (!items.isEmpty()) {
            this.renderChangedItem((org.zkoss.zul.Treeitem)items.get(index), this._model.getChild(node, index));
        }
    }

    protected Component getChildByNode(Object node) {
        if (this._model == null) {
            throw new IllegalStateException("model required");
        }
        Object root = this._model.getRoot();
        if (Objects.equals((Object)root, (Object)node)) {
            return this;
        }
        try {
            return Tree.getChildByNode0(this._model, this._treechildren, root, node);
        }
        catch (AbstractMethodError ex) {
            return OldTreeModels.getChildByNode(this._model, this, root, node);
        }
    }

    private static org.zkoss.zul.Treeitem getChildByNode0(TreeModel model, Treechildren tc, Object parent, Object node) {
        if (tc == null) {
            return null;
        }
        int j = model.getIndexOfChild(parent, node);
        if (j >= 0) {
            List cs = tc.getChildren();
            return j < cs.size() ? (org.zkoss.zul.Treeitem)cs.get(j) : null;
        }
        org.zkoss.zul.Treeitem ti = (org.zkoss.zul.Treeitem)tc.getFirstChild();
        int len = model.getChildCount(parent);
        for (j = 0; j < len && ti != null; ti = (org.zkoss.zul.Treeitem)ti.getNextSibling(), ++j) {
            org.zkoss.zul.Treeitem c = Tree.getChildByNode0(model, ti.getTreechildren(), model.getChild(parent, j), node);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new TreeDataListener(){

                public void onChange(TreeDataEvent event) {
                    Tree.this.onTreeDataChange(event);
                }
            };
        }
        this._model.addTreeDataListener(this._dataListener);
    }

    public void setModel(TreeModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeTreeDataListener(this._dataListener);
                } else {
                    if (this._treechildren != null) {
                        this._treechildren.detach();
                    }
                    this.smartUpdate("model", true);
                }
                this._model = model;
                this.initDataListener();
            }
            Tree.doSort(this);
            this.syncModel();
        } else if (this._model != null) {
            this._model.removeTreeDataListener(this._dataListener);
            this._model = null;
            if (this._treechildren != null) {
                this._treechildren.detach();
            }
            this.smartUpdate("model", false);
        }
    }

    public TreeModel getModel() {
        return this._model;
    }

    private static boolean doSort(Tree tree) {
        org.zkoss.zul.Treecols cols = tree.getTreecols();
        if (!tree.isAutosort() || cols == null) {
            return false;
        }
        Iterator it = cols.getChildren().iterator();
        while (it.hasNext()) {
            Treecol hd = (Treecol)it.next();
            String dir = hd.getSortDirection();
            if ("natural".equals(dir)) continue;
            hd.doSort("ascending".equals(dir));
            return true;
        }
        return false;
    }

    private void syncModel() {
        this.renderTree();
    }

    public void setItemRenderer(TreeitemRenderer renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            if (this._model != null) {
                this.syncModel();
            }
        }
    }

    public TreeitemRenderer getItemRenderer() {
        return this._renderer;
    }

    public void setTreeitemRenderer(TreeitemRenderer renderer) {
        this.setItemRenderer(renderer);
    }

    public TreeitemRenderer getTreeitemRenderer() {
        return this.getItemRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTree() {
        if (this._treechildren == null) {
            Treechildren children = new Treechildren();
            children.setParent((Component)this);
        } else {
            this._treechildren.getChildren().clear();
        }
        Object node = this._model.getRoot();
        Renderer renderer = new Renderer();
        try {
            this.renderChildren(renderer, this._treechildren, node);
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    private void renderChildren(Renderer renderer, Treechildren parent, Object node) throws Throwable {
        for (int i = 0; i < this._model.getChildCount(node); ++i) {
            org.zkoss.zul.Treeitem ti = this.newUnloadedItem();
            ti.setParent((Component)parent);
            Object childNode = this._model.getChild(node, i);
            renderer.render(ti, childNode);
            if (this._model.isLeaf(childNode) || ti.getTreechildren() != null) continue;
            Treechildren tc = new Treechildren();
            tc.setParent((Component)ti);
        }
    }

    private org.zkoss.zul.Treeitem newUnloadedItem() {
        org.zkoss.zul.Treeitem ti = new org.zkoss.zul.Treeitem();
        ti.setOpen(false);
        return ti;
    }

    private static TreeitemRenderer getDefaultItemRenderer() {
        return _defRend;
    }

    private TreeitemRenderer getRealRenderer() {
        return this._renderer != null ? this._renderer : Tree.getDefaultItemRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItem(org.zkoss.zul.Treeitem item) {
        if (this._model != null) {
            Renderer renderer = new Renderer();
            try {
                this.renderItem0(renderer, item);
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    public void renderItemApi(Treeitem itemApi) {
        org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)itemApi;
        this.renderItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItem(org.zkoss.zul.Treeitem item, Object node) {
        if (this._model != null) {
            Renderer renderer = new Renderer();
            try {
                this.renderItem0(renderer, item, node);
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    public void renderItemApi(Treeitem itemApi, Object node) {
        org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)itemApi;
        this.renderItem(item, node);
    }

    private void renderItem0(Renderer renderer, org.zkoss.zul.Treeitem item) throws Throwable {
        this.renderItem0(renderer, item, this.getAssociatedNode(item, this));
    }

    private void renderItem0(Renderer renderer, org.zkoss.zul.Treeitem item, Object node) throws Throwable {
        if (item.isLoaded()) {
            return;
        }
        Treechildren tc = item.getTreechildren();
        if (this._model.isLeaf(node)) {
            if (tc != null) {
                tc.detach();
            }
        } else {
            if (tc != null) {
                tc.getChildren().clear();
            } else {
                tc = new Treechildren();
                tc.setParent((Component)item);
            }
            this.renderChildren(renderer, tc, node);
        }
        item.setLoaded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderChangedItem(org.zkoss.zul.Treeitem item, Object node) {
        if (this._model != null) {
            Treechildren tc = item.getTreechildren();
            if (this._model.isLeaf(node)) {
                if (tc != null) {
                    tc.detach();
                }
            } else if (tc == null) {
                tc = new Treechildren();
                tc.setParent((Component)item);
            }
            Renderer renderer = new Renderer();
            try {
                renderer.render(item, node);
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set items) {
        if (this._model == null) {
            return;
        }
        if (items.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                this.renderItem0(renderer, (org.zkoss.zul.Treeitem)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    protected Object getAssociatedNode(org.zkoss.zul.Treeitem ti, Tree t) {
        return this.getNodeByPath(this.getTreeitemPath((Component)t, (Component)ti), this._model.getRoot());
    }

    private List getTreeitemPath(Component root, Component lastNode) {
        ArrayList<Integer> al = new ArrayList<Integer>();
        Component curNode = lastNode;
        while (!root.equals(curNode)) {
            if (curNode instanceof org.zkoss.zul.Treeitem) {
                al.add(new Integer(((org.zkoss.zul.Treeitem)curNode).getIndex()));
            }
            curNode = curNode.getParent();
        }
        return al;
    }

    private Object getNodeByPath(List path, Object root) {
        int pathSize;
        Object node = root;
        for (int i = pathSize = path.size() - 1; i >= 0; --i) {
            node = this._model.getChild(node, (Integer)path.get(i));
        }
        return node;
    }

    public org.zkoss.zul.Treeitem renderItemByNode(Object node) {
        return this.renderItemByPath(Tree.getPath(this._model, this._model.getRoot(), node));
    }

    public Treeitem renderItemByNodeApi(Object node) {
        return this.renderItemByNode(node);
    }

    static int[] getPath(TreeModel model, Object parent, Object lastNode) {
        LinkedList l = new LinkedList();
        Tree.dfSearch(model, l, parent, lastNode);
        Object[] objs = l.toArray();
        int[] path = new int[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            path[i] = (Integer)objs[i];
        }
        return path;
    }

    private static boolean dfSearch(TreeModel model, List path, Object node, Object target) {
        if (node.equals(target)) {
            return true;
        }
        if (model.isLeaf(node)) {
            return false;
        }
        int size = model.getChildCount(node);
        for (int i = 0; i < size; ++i) {
            if (!Tree.dfSearch(model, path, model.getChild(node, i), target)) continue;
            path.add(0, new Integer(i));
            return true;
        }
        return false;
    }

    public org.zkoss.zul.Treeitem renderItemByPath(int[] path) {
        if (path == null || path.length == 0) {
            return null;
        }
        org.zkoss.zul.Treeitem ti = null;
        List children = this.getTreechildren().getChildren();
        for (int i = 0; i < path.length; ++i) {
            if (path[i] < 0 || path[i] > children.size()) {
                return null;
            }
            org.zkoss.zul.Treeitem parentTi = ti;
            ti = (org.zkoss.zul.Treeitem)children.get(path[i]);
            if (i < path.length - 1) {
                ti.setOpen(true);
            }
            if (ti.getTreechildren() != null) {
                children = ti.getTreechildren().getChildren();
                continue;
            }
            if (i == path.length - 1) continue;
            return null;
        }
        return ti;
    }

    public Treeitem renderItemByPathApi(int[] path) {
        return this.renderItemByPath(path);
    }

    protected void redrawChildren(Writer out) throws IOException {
        super.redrawChildren(out);
        if (this.inPagingMold()) {
            this.removeAttribute("org.zkoss.zul.RenderedItemCount");
            this.removeAttribute("org.zkoss.zul.VisitedItemCount");
            this.removeAttribute("org.zkoss.zul.VisitedItemTotal");
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "name", this._name);
        if (this._rows > 0) {
            renderer.render("rows", this.getRows());
        }
        this.render(renderer, "multiple", this.isMultiple());
        this.render(renderer, "checkmark", this.isCheckmark());
        this.render(renderer, "vflex", this.isVflex());
        if (this._model != null) {
            this.render(renderer, "model", true);
        }
        if (this._nonselTags != null) {
            renderer.render("nonselectableTags", this._nonselTags);
        }
        if (Tree.isCheckmarkDeselectOther()) {
            renderer.render("_cdo", true);
        }
        if (!this.isRightSelect()) {
            renderer.render("rightSelect", false);
        }
        if (this._pgi != null && this._pgi instanceof Component) {
            renderer.render("$u$paginal", ((Component)this._pgi).getUuid());
        }
        if (this._currentTop != 0) {
            renderer.render("_currentTop", this._currentTop);
        }
        if (this._currentLeft != 0) {
            renderer.render("_currentLeft", this._currentLeft);
        }
    }

    private boolean isRightSelect() {
        return Utils.testAttribute((Component)this, "org.zkoss.zul.tree.rightSelect", true, true);
    }

    boolean isAutosort() {
        String attr = "org.zkoss.zul.tree.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val instanceof Boolean ? (Boolean)val : (val != null ? "true".equals(val) || "ignore.change".equals(val) : false);
    }

    private boolean isIgnoreSortWhenChanged() {
        String attr = "org.zkoss.zul.tree.autoSort";
        Object val = this.getAttribute(attr, true);
        if (val == null) {
            val = Library.getProperty((String)attr);
        }
        return val == null ? true : "ignore.change".equals(val);
    }

    private static boolean isCheckmarkDeselectOther() {
        if (_ckDeselectOther == null) {
            _ckDeselectOther = "true".equals(Library.getProperty((String)"org.zkoss.zul.tree.checkmarkDeselectOthers"));
        }
        return _ckDeselectOther;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onSelect")) {
            SelectEvent evt = SelectEvent.getSelectEvent((AuRequest)request);
            Set selItems = evt.getSelectedItems();
            this.disableClientUpdate(true);
            try {
                if (AuRequests.getBoolean((Map)request.getData(), (String)"clearFirst")) {
                    this.clearSelection();
                }
                boolean paging = this.inPagingMold();
                if (!this._multiple || !paging && (selItems == null || selItems.size() <= 1)) {
                    org.zkoss.zul.Treeitem item = selItems != null && selItems.size() > 0 ? (org.zkoss.zul.Treeitem)selItems.iterator().next() : null;
                    this.selectItem(item);
                } else {
                    int to;
                    int from;
                    if (paging) {
                        Paginal pgi = this.getPaginal();
                        int pgsz = pgi.getPageSize();
                        from = pgi.getActivePage() * pgsz;
                        to = from + pgsz;
                    } else {
                        to = 0;
                        from = 0;
                    }
                    int j = 0;
                    Iterator it = this.getItems().iterator();
                    while (it.hasNext()) {
                        org.zkoss.zul.Treeitem item = (org.zkoss.zul.Treeitem)it.next();
                        if (selItems.remove(item)) {
                            this.addItemToSelection(item);
                        } else if (!paging) {
                            this.removeItemFromSelection(item);
                        } else {
                            int index = this.getVisibleIndexOfItem(item);
                            if (index >= from && index < to) {
                                this.removeItemFromSelection(item);
                            }
                        }
                        ++j;
                    }
                }
            }
            finally {
                this.disableClientUpdate(false);
            }
            Events.postEvent((Event)evt);
        } else if (this.inPagingMold() && cmd.equals("onPageSize")) {
            int oldsize;
            Map data = request.getData();
            int size = AuRequests.getInt((Map)data, (String)"size", (int)(oldsize = this.getPageSize()));
            if (size != oldsize) {
                int begin = this.getActivePage() * oldsize;
                int end = begin + oldsize;
                end = Math.min(this.getPaginal().getTotalSize(), end);
                org.zkoss.zul.Treeitem item = this.getSelectedItem();
                int sel = this.getVisibleIndexOfItem(item);
                if (sel < 0 || sel < begin || sel >= end) {
                    sel = size > oldsize ? end - 1 : begin;
                }
                int newpg = sel / size;
                this.setPageSize(size);
                this.setActivePage(newpg);
                Events.postEvent((Event)new PageSizeEvent(cmd, (Component)this, this.pgi(), size));
            }
        } else if (cmd.equals("onInnerWidth")) {
            String width = AuRequests.getInnerWidth((AuRequest)request);
            this._innerWidth = width == null ? "100%" : width;
        } else if (cmd.equals("onScrollPos")) {
            Map data = request.getData();
            this._currentTop = AuRequests.getInt((Map)data, (String)"top", (int)0);
            this._currentLeft = AuRequests.getInt((Map)data, (String)"left", (int)0);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Tree.addClientEvent((Class)Tree.class, (String)"onInnerWidth", (int)8193);
        Tree.addClientEvent((Class)Tree.class, (String)"onSelect", (int)8193);
        Tree.addClientEvent((Class)Tree.class, (String)"onFocus", (int)8192);
        Tree.addClientEvent((Class)Tree.class, (String)"onBlur", (int)8192);
        Tree.addClientEvent((Class)Tree.class, (String)"onPageSize", (int)8195);
        Tree.addClientEvent((Class)Tree.class, (String)"onScrollPos", (int)8193);
        _defRend = new TreeitemRenderer(){

            public void render(org.zkoss.zul.Treeitem ti, Object node) {
                Treecell tc = new Treecell(Objects.toString((Object)node));
                Treerow tr = null;
                ti.setValue(node);
                if (ti.getTreerow() == null) {
                    tr = new Treerow();
                    tr.setParent((Component)ti);
                } else {
                    tr = ti.getTreerow();
                    tr.getChildren().clear();
                }
                tc.setParent((Component)tr);
            }
        };
    }

    private class Iter
    implements Iterator {
        private final ListIterator _it;

        private Iter() {
            this._it = Tree.this.getChildren().listIterator();
        }

        public boolean hasNext() {
            while (this._it.hasNext()) {
                Object o = this._it.next();
                if (!(o instanceof org.zkoss.zul.Treecols) && !(o instanceof Auxhead)) continue;
                this._it.previous();
                return true;
            }
            return false;
        }

        public Object next() {
            Object o;
            while (!((o = this._it.next()) instanceof org.zkoss.zul.Treecols) && !(o instanceof Auxhead)) {
            }
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Renderer
    implements Serializable {
        private final TreeitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Tree.this.getRealRenderer();
        }

        private void render(org.zkoss.zul.Treeitem item, Object node) throws Throwable {
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            if (node instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)node;
                item.setTreeNode(treeNode);
                if (Tree.this._model instanceof Selectable) {
                    Object value = Tree.this._model.getChild(treeNode.getParent(), item.getIndex());
                    if (((Selectable)((Object)Tree.this._model)).getSelection().contains(value)) {
                        Tree.this.addItemToSelection(item);
                    }
                }
            }
            if (Tree.this._model instanceof Openable) {
                item.setOpen(((Openable)((Object)Tree.this._model)).isOpen(node));
            }
            try {
                this._renderer.render(item, node);
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error(t);
                }
                throw ex;
            }
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }
}

