/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.api.Treerow;
import org.zkoss.zul.impl.XulElement;

public class Treechildren
extends XulElement
implements org.zkoss.zul.api.Treechildren {
    private static final String VISIBLE_ITEM = "org.zkoss.zul.Treechildren.visibleItem";
    private int _visibleItemCount;

    public Tree getTree() {
        Treechildren p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Tree)) continue;
            return (Tree)((Object)p);
        }
        return null;
    }

    public org.zkoss.zul.api.Tree getTreeApi() {
        return this.getTree();
    }

    public org.zkoss.zul.Treerow getLinkedTreerow() {
        Component parent = this.getParent();
        return parent instanceof Treeitem ? ((Treeitem)parent).getTreerow() : null;
    }

    public Treerow getLinkedTreerowApi() {
        return this.getLinkedTreerow();
    }

    boolean isRealVisible() {
        if (!this.isVisible()) {
            return false;
        }
        Component comp = this.getParent();
        if (comp == null) {
            return true;
        }
        if (!(comp instanceof Treeitem)) {
            return comp.isVisible();
        }
        Treeitem item = (Treeitem)comp;
        return item.isOpen() && item.isRealVisible();
    }

    public Collection getItems() {
        return new AbstractCollection(){

            public int size() {
                return Treechildren.this.getItemCount();
            }

            public boolean isEmpty() {
                return Treechildren.this.getChildren().isEmpty();
            }

            public Iterator iterator() {
                return new Iterator(){
                    private final Iterator _it;
                    private Iterator _sub;
                    {
                        this._it = Treechildren.this.getChildren().iterator();
                    }

                    public boolean hasNext() {
                        return this._sub != null && this._sub.hasNext() || this._it.hasNext();
                    }

                    public Object next() {
                        if (this._sub != null && this._sub.hasNext()) {
                            return this._sub.next();
                        }
                        Treeitem item = (Treeitem)this._it.next();
                        Treechildren tc = item.getTreechildren();
                        this._sub = tc != null ? tc.getItems().iterator() : null;
                        return item;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("readonly");
                    }
                };
            }
        };
    }

    public int getItemCount() {
        int sz = 0;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Treeitem item = (Treeitem)it.next();
            Treechildren tchs = item.getTreechildren();
            if (tchs != null) {
                sz += tchs.getItemCount();
            }
            ++sz;
        }
        return sz;
    }

    public int getVisibleItemCount() {
        return this._visibleItemCount;
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        this.addVisibleItemCount(((Treeitem)child).getVisibleItemCount());
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        this.addVisibleItemCount(-((Treeitem)child).getVisibleItemCount());
    }

    void addVisibleItemCount(int count) {
        if (count == 0) {
            return;
        }
        Component parent = this.getParent();
        if (parent instanceof Treeitem) {
            if (((Treeitem)parent).isOpen()) {
                ((Treeitem)parent).addVisibleItemCount(count);
            }
        } else if (parent instanceof Tree) {
            ((Tree)parent).addVisibleItemCount(count);
        }
        this._visibleItemCount += count;
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        Tree tree = this.getTree();
        if (newChild.getParent() == this && tree != null && tree.inPagingMold() && !tree.isInvalidated()) {
            tree.invalidate();
        }
        return super.insertBefore(newChild, refChild);
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Tree) && !(parent instanceof Treeitem)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void setParent(Component parent) {
        Tree tree;
        Component oldp = this.getParent();
        if (oldp == parent) {
            return;
        }
        Tree oldtree = oldp != null ? this.getTree() : null;
        super.setParent(parent);
        if (oldtree != null) {
            oldtree.onTreechildrenRemoved(this);
        }
        if (parent != null && (tree = this.getTree()) != null) {
            tree.onTreechildrenAdded(this);
        }
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Treeitem)) {
            throw new UiException("Unsupported child for treechildren: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    public String getZclass() {
        return this._zclass == null ? "z-treechildren" : this._zclass;
    }

    protected void smartUpdate(String name, Object value) {
        Component comp = this.getParent();
        if (comp instanceof Treeitem) {
            org.zkoss.zul.Treerow tr = ((Treeitem)comp).getTreerow();
            if (tr != null) {
                tr.smartUpdate(name, value);
            }
        } else {
            ((Tree)comp).smartUpdate(name, value);
        }
    }

    protected void redrawChildren(Writer out) throws IOException {
        if (this.getAttribute("org.zkoss.zul.ShallRenderItem") == null) {
            VisibleChildrenIterator it = new VisibleChildrenIterator();
            while (it.hasNext()) {
                ((ComponentCtrl)it.next()).redraw(out);
            }
        }
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Cropper {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Treechildren.this);
        }

        public boolean isCropper() {
            Tree tree = Treechildren.this.getTree();
            return tree != null && tree.inPagingMold();
        }

        public Component getCropOwner() {
            return Treechildren.this.getTree();
        }

        public Set getAvailableAtClient() {
            String attrnm;
            if (!this.isCropper()) {
                return null;
            }
            Tree tree = Treechildren.this.getTree();
            Component parent = Treechildren.this.getParent();
            Execution exe = Executions.getCurrent();
            Map map = (Map)exe.getAttribute(attrnm = Treechildren.VISIBLE_ITEM + tree.getUuid());
            if (map == null) {
                if (parent instanceof Treeitem) {
                    Treeitem ti = (Treeitem)parent;
                    while (true) {
                        if (!ti.isOpen()) {
                            return Collections.EMPTY_SET;
                        }
                        Component gp = ti.getParent().getParent();
                        if (!(gp instanceof Treeitem)) break;
                        ti = (Treeitem)gp;
                    }
                }
                map = tree.getVisibleItems();
                Executions.getCurrent().setAttribute(attrnm, (Object)map);
            }
            return map.keySet();
        }
    }

    private class VisibleChildrenIterator
    implements Iterator {
        private final Iterator _it;
        private Tree _tree;

        private VisibleChildrenIterator() {
            this._it = Treechildren.this.getChildren().iterator();
            this._tree = Treechildren.this.getTree();
        }

        public boolean hasNext() {
            if (this._tree == null || !this._tree.inPagingMold()) {
                return this._it.hasNext();
            }
            Integer renderedCount = (Integer)this._tree.getAttribute("org.zkoss.zul.RenderedItemCount");
            if (renderedCount == null || renderedCount < this._tree.getPaginal().getPageSize()) {
                return this._it.hasNext();
            }
            return false;
        }

        public Object next() {
            return this._it.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

