/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.Serializable;
import org.zkoss.image.Image;
import org.zkoss.image.Images;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.LabelElement;
import org.zkoss.zul.impl.Utils;

public abstract class LabelImageElement
extends LabelElement
implements org.zkoss.zul.impl.api.LabelImageElement {
    private AuxInfo _auxinf;

    protected LabelImageElement() {
    }

    protected LabelImageElement(String label, String image) {
        this.setLabel(label);
        this.setImage(image);
    }

    protected LabelImageElement(String label) {
        this.setLabel(label);
    }

    public String getImage() {
        return this._auxinf != null && this._auxinf.image instanceof String ? (String)this._auxinf.image : null;
    }

    public void setImage(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.image : null), (Object)src)) {
            this.initAuxInfo().image = src;
            this.smartUpdate("image", new EncodedImageURL());
        }
    }

    public String getSrc() {
        return this.getImage();
    }

    public void setSrc(String src) {
        this.setImage(src);
    }

    public void setImageContent(Image image) {
        if ((this._auxinf != null ? this._auxinf.image : null) != image) {
            this.initAuxInfo().image = image;
            if (image != null) {
                AuxInfo.access$208(this._auxinf);
            }
            this.smartUpdate("image", new EncodedImageURL());
        }
    }

    public void setImageContent(RenderedImage image) {
        try {
            this.setImageContent(Images.encode((String)"a.png", (RenderedImage)image));
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }

    public Image getImageContent() {
        return this._auxinf != null && this._auxinf.image instanceof Image ? (Image)this._auxinf.image : null;
    }

    public String getHoverImage() {
        return this._auxinf != null && this._auxinf.hoverimg instanceof String ? (String)this._auxinf.hoverimg : null;
    }

    public void setHoverImage(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.hoverimg : null), (Object)src)) {
            this.initAuxInfo().hoverimg = src;
            this.smartUpdate("hoverImage", new EncodedHoverURL());
        }
    }

    public Image getHoverImageContent() {
        return this._auxinf != null && this._auxinf.hoverimg instanceof Image ? (Image)this._auxinf.hoverimg : null;
    }

    public void setHoverImageContent(Image image) {
        if ((this._auxinf != null ? this._auxinf.hoverimg : null) != image) {
            this.initAuxInfo().hoverimg = image;
            if (image != null) {
                AuxInfo.access$508(this._auxinf);
            }
            this.smartUpdate("hoverImage", new EncodedHoverURL());
        }
    }

    public void setHoverImageContent(RenderedImage image) {
        try {
            this.setHoverImageContent(Images.encode((String)"hover.png", (RenderedImage)image));
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }

    public boolean isImageAssigned() {
        return this._auxinf != null && this._auxinf.image != null;
    }

    private String getEncodedImageURL() {
        if (this._auxinf != null && this._auxinf.image instanceof Image) {
            Image image = (Image)this._auxinf.image;
            return Utils.getDynamicMediaURI((AbstractComponent)this, this._auxinf.imgver, "c/" + image.getName(), image.getFormat());
        }
        Desktop dt = this.getDesktop();
        return dt != null && this._auxinf != null && this._auxinf.image != null ? dt.getExecution().encodeURL((String)this._auxinf.image) : null;
    }

    private String getEncodedHoverURL() {
        if (this._auxinf != null && this._auxinf.hoverimg instanceof Image) {
            Image image = (Image)this._auxinf.hoverimg;
            return Utils.getDynamicMediaURI((AbstractComponent)this, this._auxinf.hoverimgver, "h/" + image.getName(), image.getFormat());
        }
        Desktop dt = this.getDesktop();
        return dt != null && this._auxinf != null && this._auxinf.hoverimg != null ? dt.getExecution().encodeURL((String)this._auxinf.hoverimg) : null;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "image", this.getEncodedImageURL());
        this.render(renderer, "hoverImage", this.getEncodedHoverURL());
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    public Object clone() {
        LabelImageElement clone = (LabelImageElement)super.clone();
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    private AuxInfo initAuxInfo() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private Object image;
        private Object hoverimg;
        private byte imgver;
        private byte hoverimgver;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        static /* synthetic */ byte access$208(AuxInfo x0) {
            byte by = x0.imgver;
            x0.imgver = (byte)(by + 1);
            return by;
        }

        static /* synthetic */ byte access$508(AuxInfo x0) {
            byte by = x0.hoverimgver;
            x0.hoverimgver = (byte)(by + 1);
            return by;
        }
    }

    private class EncodedHoverURL
    implements DeferredValue {
        private EncodedHoverURL() {
        }

        public Object getValue() {
            return LabelImageElement.this.getEncodedHoverURL();
        }
    }

    private class EncodedImageURL
    implements DeferredValue {
        private EncodedImageURL() {
        }

        public Object getValue() {
            return LabelImageElement.this.getEncodedImageURL();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)LabelImageElement.this);
        }

        public Media getMedia(String pathInfo) {
            int k;
            int j;
            if (pathInfo != null && (j = pathInfo.indexOf(47, 1)) >= 0 && (k = pathInfo.indexOf(47, ++j)) == j + 1 && pathInfo.charAt(j) == 'h') {
                return LabelImageElement.this.getHoverImageContent();
            }
            return LabelImageElement.this.getImageContent();
        }
    }
}

