/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listfoot;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.ListgroupRendererExt;
import org.zkoss.zul.Listgroupfoot;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.Paging;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.DataLoader;
import org.zkoss.zul.impl.GroupsListModel;
import org.zkoss.zul.impl.LoadStatus;
import org.zkoss.zul.impl.XulElement;

public class ListboxDataLoader
implements DataLoader,
Cropper {
    private transient Listbox _listbox;
    private static int INVALIDATE_THRESHOLD = 10;
    private static final ListitemRenderer _defRend = new ListitemRenderer(){

        public void render(Listitem item, Object data) {
            item.setLabel(Objects.toString((Object)data));
            item.setValue(data);
        }
    };

    public void init(Component owner, int offset, int limit) {
        this._listbox = (Listbox)owner;
    }

    public void reset() {
    }

    public final Component getOwner() {
        return this._listbox;
    }

    public int getOffset() {
        return 0;
    }

    public int getLimit() {
        return this._listbox.getRows() > 0 ? this._listbox.getRows() + 5 : 20;
    }

    public int getTotalSize() {
        ListModel model = this._listbox.getModel();
        return model != null ? model.getSize() : this._listbox.getVisibleItemCount();
    }

    public void doListDataChange(ListDataEvent event) {
        ListModel _model = this._listbox.getModel();
        int newsz = _model.getSize();
        int oldsz = this._listbox.getItemCount();
        int min = event.getIndex0();
        int max = event.getIndex1();
        switch (event.getType()) {
            case 1: {
                Listitem next;
                int cnt = newsz - oldsz;
                if (cnt <= 0) {
                    throw new UiException("Adding causes a smaller list?");
                }
                if (!(oldsz > 0 && cnt <= INVALIDATE_THRESHOLD || this.inPagingMold())) {
                    this._listbox.invalidate();
                }
                if (min < 0) {
                    min = max < 0 ? 0 : max - cnt + 1;
                }
                if (min > oldsz) {
                    min = oldsz;
                }
                ListitemRenderer renderer = null;
                Listitem listitem = next = min < oldsz ? this._listbox.getItemAtIndex(min) : null;
                while (--cnt >= 0) {
                    if (renderer == null) {
                        renderer = (ListitemRenderer)this.getRealRenderer();
                    }
                    this._listbox.insertBefore((Component)this.newUnloadedItem(renderer, min++), (Component)next);
                }
                break;
            }
            case 2: {
                int cnt = oldsz - newsz;
                if (cnt <= 0) {
                    throw new UiException("Removal causes a larger list?");
                }
                if (min >= 0) {
                    max = min + cnt - 1;
                } else if (max < 0) {
                    max = cnt - 1;
                }
                if (max > oldsz - 1) {
                    max = oldsz - 1;
                }
                if (!(newsz > 0 && cnt <= INVALIDATE_THRESHOLD || this.inPagingMold())) {
                    this._listbox.invalidate();
                }
                Listitem comp = this._listbox.getItemAtIndex(max);
                while (--cnt >= 0) {
                    Component p = comp.getPreviousSibling();
                    comp.detach();
                    comp = p;
                }
                break;
            }
            default: {
                this.syncModel(min, max);
            }
        }
    }

    protected final Listitem newUnloadedItem(ListitemRenderer renderer, int index) {
        ListModel model = this._listbox.getModel();
        Listitem item = null;
        if (model instanceof GroupsListModel) {
            GroupsListModel gmodel = (GroupsListModel)model;
            GroupsListModel.GroupDataInfo info = gmodel.getDataInfo(index);
            switch (info.type) {
                case 0: {
                    item = this.newListgroup(renderer);
                    ((Listgroup)item).setOpen(!info.close);
                    break;
                }
                case 1: {
                    item = this.newListgroupfoot(renderer);
                    break;
                }
                default: {
                    item = this.newListitem(renderer);
                    break;
                }
            }
        } else {
            item = this.newListitem(renderer);
        }
        ((LoadStatus)item.getExtraCtrl()).setLoaded(false);
        ((LoadStatus)item.getExtraCtrl()).setIndex(index);
        this.newUnloadedCell(renderer, item);
        return item;
    }

    private Listitem newListitem(ListitemRenderer renderer) {
        Listitem item = null;
        if (renderer instanceof ListitemRendererExt) {
            item = ((ListitemRendererExt)((Object)renderer)).newListitem(this._listbox);
        }
        if (item == null) {
            item = new Listitem();
            item.applyProperties();
        }
        return item;
    }

    private Listgroup newListgroup(ListitemRenderer renderer) {
        Listgroup group = null;
        if (renderer instanceof ListgroupRendererExt) {
            group = ((ListgroupRendererExt)((Object)renderer)).newListgroup(this._listbox);
        }
        if (group == null) {
            group = new Listgroup();
            group.applyProperties();
        }
        return group;
    }

    private Listgroupfoot newListgroupfoot(ListitemRenderer renderer) {
        Listgroupfoot groupfoot = null;
        if (renderer instanceof ListgroupRendererExt) {
            groupfoot = ((ListgroupRendererExt)((Object)renderer)).newListgroupfoot(this._listbox);
        }
        if (groupfoot == null) {
            groupfoot = new Listgroupfoot();
            groupfoot.applyProperties();
        }
        return groupfoot;
    }

    private Listcell newUnloadedCell(ListitemRenderer renderer, Listitem item) {
        Listcell cell = null;
        if (renderer instanceof ListitemRendererExt) {
            cell = ((ListitemRendererExt)((Object)renderer)).newListcell(item);
        }
        if (cell == null) {
            cell = new Listcell();
            cell.applyProperties();
        }
        cell.setParent((Component)item);
        return cell;
    }

    public Object getRealRenderer() {
        ListitemRenderer renderer = this._listbox.getItemRenderer();
        return renderer != null ? renderer : _defRend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncModel(int offset, int limit) {
        this._listbox.setAttribute("org.zkoss.zul.syncingModel", Boolean.TRUE);
        try {
            this.syncModel0(offset, limit);
        }
        finally {
            this._listbox.setAttribute("org.zkoss.zul.syncingModel", null);
        }
    }

    private void syncModel0(int offset, int limit) {
        int min = offset;
        int max = offset + limit - 1;
        ListModel _model = this._listbox.getModel();
        int newsz = _model.getSize();
        int oldsz = this._listbox.getItemCount();
        Paginal _pgi = this._listbox.getPaginal();
        boolean inPaging = this.inPagingMold();
        boolean shallInvalidated = !(min >= 0 && min != 0 || max >= 0 && max < newsz && max < oldsz);
        int newcnt = newsz - oldsz;
        int atg = _pgi != null ? this._listbox.getActivePage() : 0;
        ListitemRenderer renderer = null;
        Component next = null;
        if (oldsz > 0) {
            if (min < 0) {
                min = 0;
            } else if (min > oldsz - 1) {
                min = oldsz - 1;
            }
            if (max < 0) {
                max = oldsz - 1;
            } else if (max > oldsz - 1) {
                max = oldsz - 1;
            }
            if (min > max) {
                int t = min;
                min = max;
                max = t;
            }
            int cnt = max - min + 1;
            if (_model instanceof GroupsListModel) {
                if ((shallInvalidated || (newcnt += cnt) > INVALIDATE_THRESHOLD) && !inPaging) {
                    this._listbox.invalidate();
                }
                Listitem comp = this._listbox.getItemAtIndex(max);
                next = comp.getNextSibling();
                while (--cnt >= 0) {
                    Component p = comp.getPreviousSibling();
                    comp.detach();
                    comp = p;
                }
            } else {
                int addcnt = 0;
                Listitem item = this._listbox.getItemAtIndex(min);
                while (--cnt >= 0) {
                    next = item.getNextSibling();
                    if (cnt < -newcnt) {
                        item.detach();
                    } else if (item.isLoaded()) {
                        if (renderer == null) {
                            renderer = (ListitemRenderer)this.getRealRenderer();
                        }
                        item.detach();
                        this._listbox.insertBefore((Component)this.newUnloadedItem(renderer, min), next);
                        ++addcnt;
                    }
                    ++min;
                    item = next;
                }
                if ((shallInvalidated || addcnt > INVALIDATE_THRESHOLD || addcnt + newcnt > INVALIDATE_THRESHOLD) && !this.inPagingMold()) {
                    this._listbox.invalidate();
                }
            }
        } else {
            min = 0;
        }
        while (--newcnt >= 0) {
            if (renderer == null) {
                renderer = (ListitemRenderer)this.getRealRenderer();
            }
            this._listbox.insertBefore((Component)this.newUnloadedItem(renderer, min), next);
            ++min;
        }
        if (_pgi != null) {
            if (atg >= _pgi.getPageCount()) {
                atg = _pgi.getPageCount() - 1;
            }
            _pgi.setActivePage(atg);
        }
    }

    protected boolean inPagingMold() {
        return "paging".equals(this._listbox.getMold());
    }

    protected boolean inSelectMold() {
        return "select".equals(this._listbox.getMold());
    }

    public void updateModelInfo() {
    }

    public void setLoadAll(boolean b) {
    }

    public boolean isCropper() {
        return this._listbox != null && this.inPagingMold() && this._listbox.getPageSize() <= this.getTotalSize();
    }

    public Set getAvailableAtClient() {
        if (!this.isCropper()) {
            return null;
        }
        Paginal pgi = this._listbox.getPaginal();
        int pgsz = pgi.getPageSize();
        int ofs = pgi.getActivePage() * pgsz;
        return this.getAvailableAtClient(ofs, pgsz);
    }

    protected Set getAvailableAtClient(int offset, int limit) {
        Frozen frozen;
        Paging paging;
        if (!this.isCropper()) {
            return null;
        }
        LinkedHashSet<XulElement> avail = new LinkedHashSet<XulElement>(32);
        avail.addAll(this._listbox.getHeads());
        Listfoot listfoot = this._listbox.getListfoot();
        if (listfoot != null) {
            avail.add(listfoot);
        }
        if ((paging = this._listbox.getPagingChild()) != null) {
            avail.add(paging);
        }
        if ((frozen = this._listbox.getFrozen()) != null) {
            avail.add(frozen);
        }
        int pgsz = limit;
        int ofs = offset;
        if (this._listbox.getItemCount() > 0) {
            Object item = (Component)this._listbox.getItems().get(0);
            while (item != null && pgsz != 0) {
                Listgroup g;
                if (item.isVisible() && item instanceof Listitem && --ofs < 0) {
                    --pgsz;
                    avail.add((XulElement)item);
                }
                if (item instanceof Listgroup && !(g = (Listgroup)item).isOpen()) {
                    int len = g.getItemCount();
                    for (int j = 0; j < len; ++j) {
                        item = (Listitem)item.getNextSibling();
                    }
                }
                if (item == null) continue;
                item = item.getNextSibling();
            }
        }
        return avail;
    }

    public Component getCropOwner() {
        return this._listbox;
    }
}

