/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import org.zkoss.mesg.Messages;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Window;
import org.zkoss.zul.mesg.MZul;

public class MessageboxDlg
extends Window {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int YES = 16;
    public static final int NO = 32;
    public static final int ABORT = 256;
    public static final int RETRY = 512;
    public static final int IGNORE = 1024;
    private int _buttons;
    private int _result;
    private EventListener _listener;
    static /* synthetic */ Class class$org$zkoss$zul$Button;

    public void onOK() throws Exception {
        if ((this._buttons & 1) != 0) {
            this.endModal("onOK", 1);
        } else if ((this._buttons & 0x10) != 0) {
            this.endModal("onYes", 16);
        } else if ((this._buttons & 0x200) != 0) {
            this.endModal("onRetry", 512);
        }
    }

    public void onCancel() throws Exception {
        if (this._buttons == 1) {
            this.endModal("onOK", 1);
        } else if ((this._buttons & 2) != 0) {
            this.endModal("onCancel", 2);
        } else if ((this._buttons & 0x20) != 0) {
            this.endModal("onNo", 32);
        } else if ((this._buttons & 0x100) != 0) {
            this.endModal("onAbort", 256);
        }
    }

    public void setButtons(int buttons) {
        this._buttons = buttons;
    }

    public void setEventListener(EventListener listener) {
        this._listener = listener;
    }

    public void setFocus(int button) {
        Button btn;
        if (button > 0 && (btn = (Button)this.getFellowIfAny("btn" + button)) != null) {
            btn.focus();
        }
    }

    public void endModal(String evtnm, int button) throws Exception {
        this._result = button;
        if (this._listener != null) {
            Event evt = new Event(evtnm, (Component)this, (Object)new Integer(button));
            this._listener.onEvent(evt);
            if (!evt.isPropagatable()) {
                return;
            }
        }
        this.detach();
    }

    public int getResult() {
        return this._result;
    }

    public void onClose() {
        if (this._listener != null) {
            Event evt = new Event("onClose", (Component)this, (Object)new Integer(-1));
            try {
                this._listener.onEvent(evt);
                if (!evt.isPropagatable()) {
                    return;
                }
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
        super.onClose();
    }

    public static class Button
    extends org.zkoss.zul.Button {
        private int _button;
        private String _evtnm;

        public void setIdentity(int button) {
            int label;
            this._button = button;
            switch (button) {
                case 16: {
                    label = MZul.YES;
                    this._evtnm = "onYes";
                    break;
                }
                case 32: {
                    label = MZul.NO;
                    this._evtnm = "onNo";
                    break;
                }
                case 512: {
                    label = MZul.RETRY;
                    this._evtnm = "onRetry";
                    break;
                }
                case 256: {
                    label = MZul.ABORT;
                    this._evtnm = "onAbort";
                    break;
                }
                case 1024: {
                    label = MZul.IGNORE;
                    this._evtnm = "onIgnore";
                    break;
                }
                case 2: {
                    label = MZul.CANCEL;
                    this._evtnm = "onCancel";
                    break;
                }
                default: {
                    label = MZul.OK;
                    this._evtnm = "onOK";
                }
            }
            this.setLabel(Messages.get((int)label));
            this.setId("btn" + this._button);
        }

        public void onClick() throws Exception {
            ((MessageboxDlg)this.getSpaceOwner()).endModal(this._evtnm, this._button);
        }

        protected String getDefaultMold(Class klass) {
            return super.getDefaultMold(class$org$zkoss$zul$Button == null ? (class$org$zkoss$zul$Button = MessageboxDlg.class$("org.zkoss.zul.Button")) : class$org$zkoss$zul$Button);
        }
    }
}

