/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Audio
extends XulElement {
    protected List<String> _src = new ArrayList<String>();
    private org.zkoss.sound.Audio _audio;
    private byte _audver;
    private boolean _autoplay;
    private boolean _controls;
    private boolean _loop;
    private boolean _muted;
    private String _preload;

    public Audio() {
    }

    public Audio(String src) {
        this.setSrc(src);
    }

    public void play() {
        this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "play"));
    }

    public void stop() {
        this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "stop"));
    }

    public void pause() {
        this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "pause"));
    }

    public List<String> getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        ArrayList<String> list = new ArrayList<String>();
        if (src.contains(",")) {
            list = new ArrayList<String>(Arrays.asList(src.split("\\s*,\\s*")));
        } else {
            list.add(src.trim());
        }
        if (this._audio != null || !((Object)this._src).equals(list)) {
            this._audio = null;
            this.setSrc(list);
        }
    }

    public void setSrc(List<String> src) {
        if (!((Object)src).equals(this._src)) {
            this._src = src;
            this.smartUpdate("src", new EncodedSrc());
        }
    }

    public boolean isAutostart() {
        return this.isAutoplay();
    }

    public void setAutostart(boolean autostart) {
        this.setAutoplay(autostart);
    }

    public boolean isAutoplay() {
        return this._autoplay;
    }

    public void setAutoplay(boolean autoplay) {
        if (this._autoplay != autoplay) {
            this._autoplay = autoplay;
            this.smartUpdate("autoplay", this._autoplay);
        }
    }

    public String getPreload() {
        return this._preload;
    }

    public void setPreload(String preload) {
        if (!(preload = "none".equalsIgnoreCase(preload) ? "none" : ("metadata".equalsIgnoreCase(preload) ? "metadata" : "auto")).equals(this._preload)) {
            this._preload = preload;
            this.smartUpdate("preload", this._preload);
        }
    }

    public boolean isControls() {
        return this._controls;
    }

    public void setControls(boolean controls) {
        if (this._controls != controls) {
            this._controls = controls;
            this.smartUpdate("controls", this._controls);
        }
    }

    public boolean isLoop() {
        return this._loop;
    }

    public void setLoop(boolean loop) {
        if (this._loop != loop) {
            this._loop = loop;
            this.smartUpdate("loop", this._loop);
        }
    }

    public boolean isMuted() {
        return this._muted;
    }

    public void setMuted(boolean muted) {
        if (this._muted != muted) {
            this._muted = muted;
            this.smartUpdate("muted", this._muted);
        }
    }

    public void setContent(org.zkoss.sound.Audio audio) {
        if (this._src != null || audio != this._audio) {
            this._audio = audio;
            this._src = null;
            if (this._audio != null) {
                this._audver = (byte)(this._audver + 1);
            }
            this.smartUpdate("src", new EncodedSrc());
        }
    }

    public org.zkoss.sound.Audio getContent() {
        return this._audio;
    }

    private List<String> getEncodedSrc() {
        Desktop dt = this.getDesktop();
        ArrayList<String> list = new ArrayList<String>();
        if (this._audio != null) {
            list.add(this.getAudioSrc());
        } else if (dt != null) {
            for (String src : this._src) {
                list.add(dt.getExecution().encodeURL(src));
            }
        }
        return list;
    }

    private String getAudioSrc() {
        return Utils.getDynamicMediaURI((AbstractComponent)this, this._audver, this._audio.getName(), this._audio.getFormat());
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "src", this.getEncodedSrc());
        this.render(renderer, "autoplay", this._autoplay);
        this.render(renderer, "preload", this._preload);
        this.render(renderer, "controls", this._controls);
        this.render(renderer, "loop", this._loop);
        this.render(renderer, "muted", this._muted);
    }

    protected boolean isChildable() {
        return false;
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    private class EncodedSrc
    implements DeferredValue {
        private EncodedSrc() {
        }

        public Object getValue() {
            return Audio.this.getEncodedSrc();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Audio.this);
        }

        public Media getMedia(String pathInfo) {
            return Audio.this._audio;
        }
    }
}

