/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.zkoss.lang.Objects;
import org.zkoss.zul.AbstractTreeModel;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.ext.Sortable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeModel<E>
extends AbstractTreeModel<TreeNode<E>>
implements Sortable<TreeNode<E>>,
Serializable {
    private static final long serialVersionUID = 20110131094811L;
    private Comparator<TreeNode<E>> _sorting;
    private boolean _sortDir;
    private boolean _emptyleaf;

    public DefaultTreeModel(TreeNode<E> root) {
        this(root, false);
    }

    public DefaultTreeModel(TreeNode<E> root, boolean emptyChildAsLeaf) {
        super(root);
        TreeNode<E> parent = root.getParent();
        if (parent != null) {
            parent.remove(root);
        }
        root.setModel(this);
        this._emptyleaf = emptyChildAsLeaf;
    }

    @Override
    public boolean isLeaf(TreeNode<E> node) {
        boolean isLeaf = node.isLeaf();
        if (!isLeaf && this._emptyleaf) {
            return node.getChildCount() == 0;
        }
        return isLeaf;
    }

    @Override
    public TreeNode<E> getChild(TreeNode<E> parent, int index) {
        return parent.getChildAt(index);
    }

    @Override
    public int getChildCount(TreeNode<E> parent) {
        return parent.getChildCount();
    }

    @Override
    public int getIndexOfChild(TreeNode<E> parent, TreeNode<E> child) {
        return parent.getIndex(child);
    }

    @Override
    public int[] getPath(TreeNode<E> child) {
        TreeNode<E> parent;
        TreeNode root = (TreeNode)this.getRoot();
        ArrayList<Integer> p = new ArrayList<Integer>();
        while (root != child && (parent = child.getParent()) != null) {
            int j = parent.getChildCount();
            for (int i = 0; i < j; ++i) {
                if (parent.getChildAt(i) != child) continue;
                p.add(0, i);
                break;
            }
            child = parent;
        }
        Integer[] objs = p.toArray(new Integer[p.size()]);
        int[] path = new int[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            path[i] = objs[i];
        }
        return path;
    }

    @Override
    public boolean isSelected(Object child) {
        return child instanceof TreeNode && super.isSelected(child);
    }

    @Override
    public boolean removeFromSelection(Object child) {
        return child instanceof TreeNode && super.removeFromSelection(child);
    }

    @Override
    public boolean isObjectOpened(Object child) {
        return child instanceof TreeNode && super.isObjectOpened(child);
    }

    @Override
    public boolean removeOpenObject(Object child) {
        return child instanceof TreeNode && super.removeOpenObject(child);
    }

    @Override
    public void sort(Comparator<TreeNode<E>> cmpr, boolean ascending) {
        this._sorting = cmpr;
        this._sortDir = ascending;
        TreeNode root = (TreeNode)this.getRoot();
        if (root != null) {
            Object ctx = this.beforeSort();
            this.sort0(root, cmpr);
            this.afterSort(ctx);
            this.fireEvent(3, null, 0, 0);
        }
    }

    private void sort0(TreeNode<E> node, Comparator<TreeNode<E>> cmpr) {
        if (node.getChildren() == null) {
            return;
        }
        if (node instanceof DefaultTreeNode) {
            ((DefaultTreeNode.TreeNodeChildrenList)node.getChildren()).sort(cmpr);
        } else {
            Collections.sort(node.getChildren(), cmpr);
        }
        for (TreeNode<E> child : node.getChildren()) {
            this.sort0(child, cmpr);
        }
    }

    public void addSelection(Object obj) {
        if (obj instanceof TreeNode) {
            this.addToSelection((TreeNode)obj);
        }
    }

    public void removeSelection(Object obj) {
        this.removeFromSelection(obj);
    }

    public void setOpen(TreeNode<E> child, boolean open) {
        int[] path = this.getPath(child);
        if (path != null && path.length > 0) {
            if (open) {
                this.addOpenPath(path);
            } else {
                this.removeOpenPath(path);
            }
        }
    }

    public boolean isOpen(Object child) {
        return this.isObjectOpened(child);
    }

    @Override
    public String getSortDirection(Comparator<TreeNode<E>> cmpr) {
        if (Objects.equals(this._sorting, cmpr)) {
            return this._sortDir ? "ascending" : "descending";
        }
        return "natural";
    }

    @Override
    public Object clone() {
        DefaultTreeModel clone = (DefaultTreeModel)super.clone();
        TreeNode cloneRoot = (TreeNode)((TreeNode)this.getRoot()).clone();
        cloneRoot.setModel(this);
        clone.setRootDirectly(cloneRoot);
        return clone;
    }
}

