/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Menubar;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.impl.LabelImageElement;
import org.zkoss.zul.impl.Utils;

public class Menuitem
extends LabelImageElement
implements Disable {
    private AuxInfo _auxinf;

    public Menuitem() {
    }

    public Menuitem(String label) {
        super(label);
    }

    public Menuitem(String label, String src) {
        super(label, src);
    }

    public boolean isCheckmark() {
        return this._auxinf != null && this._auxinf.checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if ((this._auxinf != null && this._auxinf.checkmark) != checkmark) {
            this.initAuxInfo().checkmark = checkmark;
            this.smartUpdate("checkmark", this.isCheckmark());
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-menuitem" : this._zclass;
    }

    public void setDisabled(boolean disabled) {
        if ((this._auxinf != null && this._auxinf.disabled) != disabled) {
            this.initAuxInfo().disabled = disabled;
            this.smartUpdate("disabled", this.isDisabled());
        }
    }

    public boolean isDisabled() {
        return this._auxinf != null && this._auxinf.disabled;
    }

    public String getAutodisable() {
        return this._auxinf != null ? this._auxinf.autodisable : null;
    }

    public void setAutodisable(String autodisable) {
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.autodisable : null), (Object)autodisable)) {
            this.initAuxInfo().autodisable = autodisable;
            this.smartUpdate("autodisable", this.getAutodisable());
        }
    }

    public String getValue() {
        return this._auxinf != null ? this._auxinf.value : "";
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.value : ""), (Object)value)) {
            this.initAuxInfo().value = value;
            this.smartUpdate("value", this.getValue());
        }
    }

    public boolean isChecked() {
        return this._auxinf != null && this._auxinf.checked;
    }

    public void setChecked(boolean checked) {
        if ((this._auxinf != null && this._auxinf.checked) != checked) {
            this.initAuxInfo().checked = checked;
            if (this._auxinf.checked) {
                this._auxinf.checkmark = true;
            }
            this.smartUpdate("checked", this.isChecked());
        }
    }

    public boolean isAutocheck() {
        return this._auxinf != null && this._auxinf.autocheck;
    }

    public void setAutocheck(boolean autocheck) {
        if ((this._auxinf != null && this._auxinf.autocheck) != autocheck) {
            this.initAuxInfo().autocheck = autocheck;
            this.smartUpdate("autocheck", this.isAutocheck());
        }
    }

    public String getHref() {
        return this._auxinf != null ? this._auxinf.href : null;
    }

    public void setHref(String href) throws WrongValueException {
        if (href != null && href.length() == 0) {
            href = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.href : null), (Object)href)) {
            this.initAuxInfo().href = href;
            this.smartUpdate("href", new EncodedHref());
        }
    }

    public String getTarget() {
        return this._auxinf != null ? this._auxinf.target : null;
    }

    public void setTarget(String target) {
        if (target != null && target.length() == 0) {
            target = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.target : null), (Object)target)) {
            this.initAuxInfo().target = target;
            this.smartUpdate("target", this.getTarget());
        }
    }

    public boolean isTopmost() {
        return !(this.getParent() instanceof Menupopup);
    }

    public String getUpload() {
        return this._auxinf != null ? this._auxinf.upload : null;
    }

    public void setUpload(String upload) {
        if (upload != null && (upload.length() == 0 || "false".equals(upload))) {
            upload = null;
        }
        if (!Objects.equals((Object)upload, this._auxinf != null ? this._auxinf.upload : null)) {
            this.initAuxInfo().upload = upload;
            this.smartUpdate("upload", this.getUpload());
        }
    }

    private String getEncodedHref() {
        Desktop dt = this.getDesktop();
        return this._auxinf != null && this._auxinf.href != null && dt != null ? dt.getExecution().encodeURL(this._auxinf.href) : null;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Menupopup) && !(parent instanceof Menubar)) {
            throw new UiException("Unsupported parent for menuitem: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public Object clone() {
        Menuitem clone = (Menuitem)((Object)super.clone());
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    protected boolean isChildable() {
        return false;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "checkmark", this.isCheckmark());
        this.render(renderer, "disabled", this.isDisabled());
        this.render(renderer, "checked", this.isChecked());
        this.render(renderer, "autocheck", this.isAutocheck());
        this.render(renderer, "autodisable", this.getAutodisable());
        String href = this.getEncodedHref();
        this.render(renderer, "href", href);
        this.render(renderer, "target", this.getTarget());
        this.render(renderer, "upload", this.getUpload());
        this.render(renderer, "value", this.getValue());
        Utils.renderCrawlableA(href, this.getLabel());
    }

    protected void renderCrawlable(String label) throws IOException {
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onCheck")) {
            CheckEvent evt = CheckEvent.getCheckEvent((AuRequest)request);
            this.initAuxInfo().checked = evt.isChecked();
            if (this._auxinf.checked) {
                this._auxinf.checkmark = true;
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    protected void updateByClient(String name, Object value) {
        if ("disabled".equals(name)) {
            this.setDisabled(value instanceof Boolean ? ((Boolean)value).booleanValue() : "true".equals(Objects.toString((Object)value)));
        } else {
            super.updateByClient(name, value);
        }
    }

    private AuxInfo initAuxInfo() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    static {
        Menuitem.addClientEvent(Menuitem.class, (String)"onCheck", (int)1);
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private String value = "";
        private String href;
        private String target;
        private String autodisable;
        protected String upload;
        private boolean disabled;
        private boolean autocheck;
        private boolean checked;
        private boolean checkmark;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }

    private class EncodedHref
    implements DeferredValue {
        private EncodedHref() {
        }

        public Object getValue() {
            return Menuitem.this.getEncodedHref();
        }
    }
}

