/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Strings;
import org.zkoss.util.Dates;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.ClientConstraint;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.mesg.MZul;

public class SimpleConstraint
implements Constraint,
ClientConstraint,
Serializable {
    private static final long serialVersionUID = 20070411L;
    public static final int NO_POSITIVE = 1;
    public static final int NO_NEGATIVE = 2;
    public static final int NO_ZERO = 4;
    public static final int NO_EMPTY = 256;
    public static final int STRICT = 512;
    public static final int SERVER = 1024;
    public static final int NO_FUTURE = 1;
    public static final int NO_PAST = 2;
    public static final int NO_TODAY = 4;
    public static final int BEFORE_START = 4096;
    public static final int BEFORE_END = 8192;
    public static final int END_BEFORE = 12288;
    public static final int END_AFTER = 16384;
    public static final int AFTER_END = 20480;
    public static final int AFTER_START = 24576;
    public static final int START_AFTER = 28672;
    public static final int START_BEFORE = 32768;
    public static final int OVERLAP = 36864;
    public static final int OVERLAP_END = 40960;
    public static final int OVERLAP_BEFORE = 45056;
    public static final int OVERLAP_AFTER = 49152;
    public static final int AT_POINTER = 53248;
    public static final int AFTER_POINTER = 57344;
    protected int _flags;
    private Pattern _regex;
    private String _errmsg;
    private String _raw;

    public SimpleConstraint(int flags) {
        this(flags, null, null);
    }

    public SimpleConstraint(int flags, String errmsg) {
        this(flags, null, errmsg);
    }

    public SimpleConstraint(String regex, String errmsg) {
        this(0, regex, errmsg);
    }

    public SimpleConstraint(int flags, String regex, String errmsg) {
        this._flags = flags;
        this._regex = regex == null || regex.length() == 0 ? null : Pattern.compile(regex);
        this._errmsg = errmsg == null || errmsg.length() == 0 ? null : errmsg;
        this._raw = null;
    }

    public SimpleConstraint(String constraint) {
        String regex = null;
        String errmsg = null;
        int j = 0;
        int k = 0;
        int len = constraint.length();
        block4: while (k >= 0) {
            block5: while (j < len) {
                char cc = constraint.charAt(j);
                switch (cc) {
                    case '/': {
                        k = ++j;
                        while (true) {
                            if (k >= len) {
                                k = -1;
                                break;
                            }
                            cc = constraint.charAt(k);
                            if (cc == '/') break;
                            if (cc == '\\') {
                                ++k;
                            }
                            ++k;
                        }
                        regex = k >= 0 ? constraint.substring(j, k) : constraint.substring(j);
                        break;
                    }
                    case ':': {
                        errmsg = constraint.substring(j + 1).trim();
                        break block4;
                    }
                    default: {
                        String s;
                        if (Character.isWhitespace(cc)) {
                            ++j;
                            continue block5;
                        }
                        k = j;
                        while (true) {
                            if (k >= len) {
                                s = constraint.substring(j);
                                k = -1;
                                break;
                            }
                            char cc2 = constraint.charAt(k);
                            if (cc2 == ',' || cc2 == ':' || cc2 == ';' || cc2 == '/') {
                                s = constraint.substring(j, k);
                                if (cc2 != ':' && cc2 != '/') break;
                                --k;
                                break;
                            }
                            ++k;
                        }
                        this._flags |= this.parseConstraint(s.trim().toLowerCase(Locale.ENGLISH));
                    }
                }
                j = k + 1;
                continue block4;
            }
            break block4;
        }
        this._raw = constraint;
        this._regex = regex == null || regex.length() == 0 ? null : Pattern.compile(regex);
        this._errmsg = errmsg == null || errmsg.length() == 0 ? null : errmsg;
    }

    public static SimpleConstraint getInstance(String constraint) {
        return new SimpleConstraint(constraint);
    }

    protected int parseConstraint(String constraint) throws UiException {
        if (constraint.equals("no positive")) {
            return 1;
        }
        if (constraint.equals("no negative")) {
            return 2;
        }
        if (constraint.equals("no zero")) {
            return 4;
        }
        if (constraint.equals("no empty")) {
            return 256;
        }
        if (constraint.equals("no future")) {
            return 1;
        }
        if (constraint.equals("no past")) {
            return 2;
        }
        if (constraint.equals("no today")) {
            return 4;
        }
        if (constraint.equals("strict")) {
            return 512;
        }
        if (constraint.equals("server")) {
            return 1024;
        }
        if (constraint.equals("before_start")) {
            return 4096;
        }
        if (constraint.equals("before_end")) {
            return 8192;
        }
        if (constraint.equals("end_before")) {
            return 12288;
        }
        if (constraint.equals("end_after")) {
            return 16384;
        }
        if (constraint.equals("after_end")) {
            return 20480;
        }
        if (constraint.equals("after_start")) {
            return 24576;
        }
        if (constraint.equals("start_after")) {
            return 28672;
        }
        if (constraint.equals("start_before")) {
            return 32768;
        }
        if (constraint.equals("overlap")) {
            return 36864;
        }
        if (constraint.equals("overlap_end")) {
            return 40960;
        }
        if (constraint.equals("overlap_before")) {
            return 45056;
        }
        if (constraint.equals("overlap_after")) {
            return 49152;
        }
        if (constraint.equals("at_pointer")) {
            return 53248;
        }
        if (constraint.equals("after_pointer")) {
            return 57344;
        }
        if (constraint.length() > 0) {
            throw new UiException("Unknown constraint: " + constraint);
        }
        return 0;
    }

    public int getFlags() {
        return this._flags;
    }

    public String getErrorMessage(Component comp) {
        return this._errmsg;
    }

    public void validate(Component comp, Object value) throws WrongValueException {
        if (value == null) {
            if ((this._flags & 0x100) != 0) {
                throw this.wrongValue(comp, MZul.EMPTY_NOT_ALLOWED);
            }
        } else if (value instanceof Number) {
            if ((this._flags & 7) == 0) {
                return;
            }
            int cmp = SimpleConstraint.compareTo((Comparable)value, Classes.coerce(value.getClass(), null, (boolean)false));
            if (cmp > 0 ? (this._flags & 1) != 0 : (cmp == 0 ? (this._flags & 4) != 0 : (this._flags & 2) != 0)) {
                throw this.wrongValue(comp, this.getMessageForNumberDenied());
            }
        } else if (value instanceof String) {
            String s = (String)value;
            if ((this._flags & 0x100) != 0 && s.length() == 0) {
                throw this.wrongValue(comp, MZul.EMPTY_NOT_ALLOWED);
            }
            if (this._regex != null && !this._regex.matcher(s != null ? s : "").matches()) {
                throw this.wrongValue(comp, MZul.ILLEGAL_VALUE);
            }
            if ((this._flags & 0x200) != 0 && s.length() > 0 && comp instanceof Combobox) {
                for (Comboitem ci : ((Combobox)comp).getItems()) {
                    if (ci.isDisabled() || !ci.isVisible() || !s.equalsIgnoreCase(ci.getLabel())) continue;
                    return;
                }
                throw this.wrongValue(comp, MZul.VALUE_NOT_MATCHED);
            }
        } else if (value instanceof Date) {
            if ((this._flags & 7) == 0) {
                return;
            }
            Date date = Dates.beginOfDate((Date)((Date)value), null);
            int cmp = date.compareTo(Dates.today());
            if (cmp > 0 ? (this._flags & 1) != 0 : (cmp == 0 ? (this._flags & 4) != 0 : (this._flags & 2) != 0)) {
                throw this.wrongValue(comp, this.getMessageForDateDenied());
            }
        }
    }

    private static int compareTo(Comparable v1, Object v2) {
        return v1.compareTo(v2);
    }

    private WrongValueException wrongValue(Component comp, int errcode) {
        return this._errmsg != null ? new WrongValueException(comp, this._errmsg) : new WrongValueException(comp, errcode);
    }

    private int getMessageForNumberDenied() {
        switch (this._flags & 7) {
            case 5: {
                return MZul.NO_POSITIVE_ZERO;
            }
            case 1: {
                return MZul.NO_POSITIVE;
            }
            case 6: {
                return MZul.NO_NEGATIVE_ZERO;
            }
            case 2: {
                return MZul.NO_NEGATIVE;
            }
            case 4: {
                return MZul.NO_ZERO;
            }
            case 7: {
                return MZul.NO_POSITIVE_NEGATIVE_ZERO;
            }
            case 3: {
                return MZul.NO_POSITIVE_NEGATIVE;
            }
        }
        throw new InternalError();
    }

    private int getMessageForDateDenied() {
        switch (this._flags & 7) {
            case 5: {
                return MZul.NO_FUTURE_TODAY;
            }
            case 1: {
                return MZul.NO_FUTURE;
            }
            case 6: {
                return MZul.NO_PAST_TODAY;
            }
            case 2: {
                return MZul.NO_PAST;
            }
            case 4: {
                return MZul.NO_TODAY;
            }
            case 7: {
                return MZul.NO_FUTURE_PAST_TODAY;
            }
            case 3: {
                return MZul.NO_FUTURE_PAST;
            }
        }
        throw new InternalError();
    }

    public String getClientConstraint() {
        if (this._raw != null) {
            return '\'' + Strings.escape((String)this._raw, (String)"'\n\r\t\f\\/!") + '\'';
        }
        StringBuffer sb = new StringBuffer("new zul.inp.SimpleConstraint(");
        if (this._flags != 0 || this._regex != null || this._errmsg != null) {
            sb.append(this._flags);
            if (this._regex != null || this._errmsg != null) {
                sb.append(',');
                if (this._regex != null) {
                    sb.append('\'');
                    Strings.escape((StringBuffer)sb, (CharSequence)this._regex.pattern(), (String)"'\n\r\t\f\\/!");
                    sb.append('\'');
                } else {
                    sb.append("null");
                }
                if (this._errmsg != null) {
                    sb.append(",'");
                    Strings.escape((StringBuffer)sb, (CharSequence)this._errmsg, (String)"'\n\r\t\f\\/!");
                    sb.append('\'');
                }
            }
        }
        return sb.append(')').toString();
    }

    public String getClientPackages() {
        return null;
    }
}

