/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import javax.servlet.ServletRequest;
import org.zkoss.lang.Objects;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Paging;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Paginated;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public abstract class MeshElement
extends XulElement
implements Paginated {
    private String _span;
    private boolean _sizedByContent;
    private boolean _autopaging;
    private String _pagingPosition = "bottom";

    public String getSpan() {
        return this._span;
    }

    public void setSpan(String span) {
        if (!Objects.equals((Object)this._span, (Object)span)) {
            this._span = span;
            this.smartUpdate("span", span);
        }
    }

    public void setSpan(boolean span) {
        if (span && !"true".equals(this._span) || !span && this._span != null && !"false".equals(this._span)) {
            this._span = span ? "true" : "false";
            this.smartUpdate("span", span);
        }
    }

    public boolean isSpan() {
        return this._span != null && !"false".equals(this._span);
    }

    public void setSizedByContent(boolean byContent) {
        if (this._sizedByContent != byContent) {
            this._sizedByContent = byContent;
            this.smartUpdate("sizedByContent", byContent);
        }
    }

    public boolean isSizedByContent() {
        String s = (String)this.getAttribute("sized-by-content");
        if (s == null) {
            s = (String)this.getAttribute("fixed-layout");
            return s != null ? !"true".equalsIgnoreCase(s) : this._sizedByContent;
        }
        return "true".equalsIgnoreCase(s);
    }

    public void setAutopaging(boolean autopaging) {
        if (this._autopaging != autopaging) {
            this._autopaging = autopaging;
            this.smartUpdate("autopaging", autopaging);
        }
    }

    public boolean isAutopaging() {
        return this._autopaging;
    }

    public void setPagingPosition(String pagingPosition) {
        if (pagingPosition == null || !pagingPosition.equals("top") && !pagingPosition.equals("bottom") && !pagingPosition.equals("both")) {
            throw new WrongValueException("Unsupported position : " + pagingPosition);
        }
        if (!Objects.equals((Object)this._pagingPosition, (Object)pagingPosition)) {
            this._pagingPosition = pagingPosition;
            this.smartUpdate("pagingPosition", pagingPosition);
        }
    }

    protected abstract boolean isAutohidePaging();

    public String getPagingPosition() {
        return this._pagingPosition;
    }

    protected abstract Paginal pgi();

    public int getPageSize() {
        return this.pgi().getPageSize();
    }

    public void setPageSize(int pgsz) throws WrongValueException {
        this.pgi().setPageSize(pgsz);
    }

    public int getPageCount() {
        return this.pgi().getPageCount();
    }

    public int getActivePage() {
        return this.pgi().getActivePage();
    }

    public void setActivePage(int pg) throws WrongValueException {
        this.pgi().setActivePage(pg);
    }

    boolean isNativeScrollbar() {
        boolean isIE8 = Servlets.isBrowser((ServletRequest)((ServletRequest)Executions.getCurrent().getNativeRequest()), (String)"ie8-");
        return isIE8 ? true : Utils.testAttribute((Component)this, "org.zkoss.zul.nativebar", true, true);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this.isSizedByContent()) {
            renderer.render("sizedByContent", true);
        }
        if (this._span != null) {
            renderer.render("span", this._span);
        }
        if (this.isAutopaging()) {
            renderer.render("autopaging", true);
        }
        if (!"bottom".equals(this._pagingPosition)) {
            this.render(renderer, "pagingPosition", this._pagingPosition);
        }
        if (this.isNativeScrollbar()) {
            renderer.render("_nativebar", true);
        }
    }

    protected class InternalPaging
    extends Paging {
        private boolean autohideModify = false;

        public boolean isAutohide() {
            if (!this.autohideModify) {
                return MeshElement.this.isAutohidePaging();
            }
            return super.isAutohide();
        }

        public void setAutohide(boolean autohide) {
            this.autohideModify = true;
            super.setAutohide(autohide);
        }

        public boolean isAutohideModify() {
            return this.autohideModify;
        }
    }
}

