/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.mesg.MZul;

public class SimpleDoubleSpinnerConstraint
extends SimpleConstraint {
    private Double _min;
    private Double _max;

    public SimpleDoubleSpinnerConstraint() {
        super(0);
    }

    public SimpleDoubleSpinnerConstraint(int flags) {
        super(flags);
    }

    public SimpleDoubleSpinnerConstraint(String constraint) {
        super(constraint);
    }

    public Double getMin() {
        return this._min;
    }

    public void setMin(Double min) {
        this._min = min;
    }

    public Double getMax() {
        return this._max;
    }

    public void setMax(Double max) {
        this._max = max;
    }

    protected int parseConstraint(String constraint) throws UiException {
        int minIndex = constraint.indexOf("min");
        int maxIndex = constraint.indexOf("max");
        try {
            if (minIndex >= 0 && maxIndex >= 0) {
                if (maxIndex > minIndex) {
                    this._min = new Double(constraint.substring(minIndex + 3, maxIndex).trim());
                    this._max = new Double(constraint.substring(maxIndex + 3).trim());
                } else {
                    this._min = new Double(constraint.substring(minIndex + 3).trim());
                    this._max = new Double(constraint.substring(maxIndex + 3, minIndex).trim());
                }
                if (this._min.compareTo(this._max) > 0) {
                    throw new UiException("Constraint error: " + this._min + " > " + this._max);
                }
                return 0;
            }
            if (minIndex >= 0) {
                this._min = new Double(constraint.substring(minIndex + 3).trim());
                return 0;
            }
            if (maxIndex >= 0) {
                this._max = new Double(constraint.substring(maxIndex + 3).trim());
                return 0;
            }
        }
        catch (NumberFormatException e) {
            throw new UiException("Constraint error: " + constraint);
        }
        return super.parseConstraint(constraint);
    }

    public void validate(Component comp, Object value) throws WrongValueException {
        super.validate(comp, value);
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            if (this._min != null && this._min.compareTo(doubleValue) > 0) {
                throw this.outOfRangeValue(comp);
            }
            if (this._max != null && this._max.compareTo(doubleValue) < 0) {
                throw this.outOfRangeValue(comp);
            }
        }
    }

    private WrongValueException outOfRangeValue(Component comp) {
        String errmsg = this.getErrorMessage(comp);
        if (errmsg != null) {
            return new WrongValueException(comp, errmsg);
        }
        String s = this._min != null ? (this._max != null ? this._min + " ~ " + this._max : ">= " + this._min) : "<= " + this._max;
        return new WrongValueException(comp, MZul.OUT_OF_RANGE, (Object)s);
    }
}

