/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zkoss.util.Dates;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.AbstractSimpleDateTimeConstraint;
import org.zkoss.zul.Datebox;

public class SimpleDateConstraint
extends AbstractSimpleDateTimeConstraint<Date> {
    public SimpleDateConstraint(int flags) {
        super(flags);
    }

    public SimpleDateConstraint(int flags, String errmsg) {
        super(flags, errmsg);
    }

    public SimpleDateConstraint(String regex, String errmsg) {
        super(regex == null || regex.length() == 0 ? null : Pattern.compile(regex), errmsg);
    }

    public SimpleDateConstraint(Pattern regex, String errmsg) {
        super(regex, errmsg);
    }

    public SimpleDateConstraint(int flags, String regex, String errmsg) {
        super(flags, regex == null || regex.length() == 0 ? null : Pattern.compile(regex), errmsg);
    }

    public SimpleDateConstraint(int flags, Pattern regex, String errmsg) {
        super(flags, regex, errmsg);
    }

    public SimpleDateConstraint(int flags, Date begin, Date end, String errmsg) {
        super(flags, errmsg);
        this._beg = begin;
        this._end = end;
        this.fixConstraint();
    }

    public SimpleDateConstraint(String constraint) {
        super(constraint);
        this.checkValidConstraint(constraint);
    }

    private void checkValidConstraint(String constraint) {
        int constraintFormatLength = "yyyyMMdd".length();
        String[] constraintParts = constraint.split(",");
        Pattern numberStartWithKeyword = Pattern.compile("((?<=before |after |between |and )(\\d+))");
        for (String part : constraintParts) {
            String partWithoutMessage = part.split(":")[0];
            Matcher matcher = numberStartWithKeyword.matcher(partWithoutMessage);
            while (matcher.find()) {
                if (matcher.group().length() == constraintFormatLength) continue;
                throw new UiException("Invalid constraint: " + part + " (the constraint should be formatted in yyyyMMdd)");
            }
        }
    }

    @Override
    protected void fixConstraint() {
        if ((this._flags & 1) != 0 && this._end == null) {
            this._end = Dates.today();
        }
        if ((this._flags & 2) != 0 && this._beg == null) {
            this._beg = Dates.today();
        }
    }

    @Override
    protected Date parseFrom(String val) throws UiException {
        try {
            return SimpleDateConstraint.getDateFormat(this._tzone).parse(val.trim());
        }
        catch (ParseException ex) {
            throw new UiException("Not a date: " + val + ". Format: yyyyMMdd", (Throwable)ex);
        }
    }

    private static SimpleDateFormat getDateFormat(TimeZone tzone) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd", Locales.getCurrent());
        df.setTimeZone(tzone != null ? tzone : TimeZones.getCurrent());
        return df;
    }

    @Override
    public void validate(Component comp, Object value) throws WrongValueException {
        super.validate(comp, value);
        if (value instanceof Date) {
            this.validate0(comp, Dates.beginOfDate((Date)((Date)value), (TimeZone)this._tzone));
        }
    }

    @Override
    protected String valueToString(Component comp, Date value) {
        if (value == null) {
            return "";
        }
        if (comp instanceof Datebox) {
            return ((Datebox)comp).coerceToString(value);
        }
        return SimpleDateConstraint.getDateFormat(this._tzone).format(value);
    }
}

