/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Toolbar
extends XulElement {
    private static final String PRELOAD_IMAGE = "org.zkoss.zul.image.preload";
    private String _orient = "horizontal";
    private String _align = "start";
    private boolean _overflowPopup;
    private String _overflowPopupIconSclass = "z-icon-ellipsis-h";

    public Toolbar() {
    }

    public Toolbar(String orient) {
        this();
        this.setOrient(orient);
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (align == null) {
            align = "start";
        }
        if (!("start".equals(align) || "center".equals(align) || "end".equals(align))) {
            throw new WrongValueException("align cannot be " + align);
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    boolean inPanelMold() {
        return "panel".equals(this.getMold());
    }

    public String getZclass() {
        return this._zclass == null ? "z-toolbar" : this._zclass;
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public boolean isOverflowPopup() {
        return this._overflowPopup;
    }

    public void setOverflowPopup(boolean overflowPopup) {
        if (this._overflowPopup != overflowPopup) {
            this._overflowPopup = overflowPopup;
            this.smartUpdate("overflowPopup", this._overflowPopup);
            if (this._overflowPopup) {
                this.setAttribute(PRELOAD_IMAGE, "true");
            } else {
                this.removeAttribute(PRELOAD_IMAGE);
            }
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"horizontal".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
        if (!"start".equals(this._align)) {
            this.render(renderer, "align", this._align);
        }
        this.render(renderer, "overflowPopup", this._overflowPopup);
        if (!"z-icon-ellipsis-h".equals(this._overflowPopupIconSclass)) {
            this.render(renderer, "overflowPopupIconSclass", this.getOverflowPopupIconSclass());
        }
    }

    public String getOverflowPopupIconSclass() {
        return this._overflowPopupIconSclass;
    }

    public void setOverflowPopupIconSclass(String overflowPopupIconSclass) {
        if (!Objects.equals((Object)this._overflowPopupIconSclass, (Object)overflowPopupIconSclass)) {
            this._overflowPopupIconSclass = overflowPopupIconSclass;
            this.smartUpdate("overflowPopupIconSclass", this._overflowPopupIconSclass);
        }
    }
}

