/* BranchTag.java

{{IS_NOTE
	Purpose:
		
	Description:
		
	History:
		Fri Jul 20 17:09:09     2007, Created by tomyeh
}}IS_NOTE

Copyright (C) 2007 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
	This program is distributed under GPL Version 2.0 in the hope that
	it will be useful, but WITHOUT ANY WARRANTY.
}}IS_RIGHT
*/
package org.zkoss.jsp.zul.impl;

import java.io.StringWriter;
import java.io.IOException;

import javax.servlet.jsp.JspException;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;

/**
 * The skeletal class used to implement the JSP tag for ZK components
 * that might have child tags (and/or components).
 *
 * <p>Remember to declare the following in the TLD file:
 * &lt;body-content&gt;scriptless&lt;/body-content&gt;
 *
 * @author tomyeh
 */
abstract public class BranchTag extends LeafTag {
	/** Adds a child tag.
	 */
	public void addChildTag(ComponentTag child) {
		Component parent = getComponent();
		if(child.isInline())
		{
			Component[] comps = child.getComponents();
			for(int i=0;i<comps.length;i++)
				comps[i].setParent(parent);
		}
		else child.getComponent().setParent(parent);
	}



	/** To process this page tag.
	 * The deriving class rarely need to override this method.
	 */
	public void doComponentContent() throws Exception {

		if(!this.isInline())
			ComponentJspContextStack.push(this.getJspContext(), _comp);
		
		
		final StringWriter out = new StringWriter();
		if(getJspBody()!=null)getJspBody().invoke(out);
		if(this.isInline()){
			Component[] comps = getComponents();
			for(int i=0;i<comps.length;i++){
				Utils.adjustChildren( 
						null, comps[i], comps[i].getChildren(), out.toString());
			}
		}else{
			Component comp = getComponent();
			Utils.adjustChildren(
				null, comp, comp.getChildren(), out.toString());	
		}
		
		if(!this.isInline())
			ComponentJspContextStack.pop(this.getJspContext());
		
	}
	
}
