/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsp.zul;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.JspTag;
import org.zkoss.jsp.zul.AttributesInfo;
import org.zkoss.jsp.zul.IllegalJspTagException;
import org.zkoss.jsp.zul.PageTag;
import org.zkoss.jsp.zul.impl.AbstractTag;
import org.zkoss.jsp.zul.impl.BranchTag;

public class CustomAttributesTag
extends AbstractTag
implements DynamicAttributes {
    private BranchTag _branchTag;
    private PageTag _pageTag;
    private HashMap _custAttrs = new HashMap();
    private String _scope;
    private CompositeConverter _composite = new CompositeConverter(){

        public Map convert(Map attr) {
            return attr;
        }

        public Object handleAttr(Object value) {
            return null;
        }
    };

    public void doTag() throws JspException, IOException {
        if (!this.isEffective()) {
            return;
        }
        AttributesInfo attrInfo = new AttributesInfo(this._composite.convert(this._custAttrs), this._scope);
        if (this._branchTag != null) {
            attrInfo.apply(this._branchTag.getComponent());
        } else {
            attrInfo.apply(this._pageTag.getPage());
        }
    }

    public void setParent(JspTag parent) {
        super.setParent(parent);
        if (parent instanceof BranchTag) {
            this._branchTag = (BranchTag)parent;
        } else if (parent instanceof PageTag) {
            this._pageTag = (PageTag)parent;
        } else {
            throw new IllegalJspTagException("Parent tag is not a valid ZK container Tag: " + (Object)((Object)this));
        }
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        if (localName.equals("scope")) {
            this._scope = (String)value;
        } else if (localName.equals("composite")) {
            if ("list".equals(value)) {
                this._composite = new CompositeConverter(){

                    protected Object handleAttr(Object value) {
                        try {
                            String[] arr = value.toString().split("[,]");
                            ArrayList<String> list = new ArrayList<String>(arr.length);
                            for (String str : arr) {
                                list.add(str);
                            }
                            return list;
                        }
                        catch (Exception e) {
                            throw CustomAttributesTag.wrapError("list", (String)value, e);
                        }
                    }
                };
            } else if ("map".equals(value)) {
                this._composite = new CompositeConverter(){

                    protected Object handleAttr(Object value) {
                        try {
                            String[] arr = value.toString().split("[,]");
                            HashMap<String, String> map = new HashMap<String, String>();
                            for (String str : arr) {
                                String[] pair = str.split("[=]");
                                map.put(pair[0], pair[1]);
                            }
                            return map;
                        }
                        catch (Exception e) {
                            throw CustomAttributesTag.wrapError("map", (String)value, e);
                        }
                    }
                };
            }
        } else {
            this._custAttrs.put(localName, value);
        }
    }

    private static IllegalArgumentException wrapError(String composite, String input, Exception e) {
        return new IllegalArgumentException("in custom-attributes composite[" + composite + "], illformat of input:" + input, e);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(40).append("[custom-attributes:");
        if (this._custAttrs != null) {
            Iterator it = this._custAttrs.keySet().iterator();
            while (it.hasNext()) {
                sb.append(' ').append(it.next());
            }
        }
        return sb.append(']').toString();
    }

    private abstract class CompositeConverter {
        private CompositeConverter() {
        }

        public Map convert(Map attrs) {
            HashMap ans = new HashMap();
            Iterator i$ = attrs.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = i$.next();
                ans.put(entry.getKey(), this.handleAttr(entry.getValue()));
            }
            return ans;
        }

        protected abstract Object handleAttr(Object var1);
    }
}

