/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsp.zul.impl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.JspTag;
import org.zkoss.jsp.zul.impl.AbstractTag;
import org.zkoss.jsp.zul.impl.BranchTag;
import org.zkoss.jsp.zul.impl.ComponentTag;
import org.zkoss.jsp.zul.impl.Initiators;
import org.zkoss.jsp.zul.impl.Jsps;
import org.zkoss.jsp.zul.impl.PageRequestContext;
import org.zkoss.jsp.zul.impl.Utils;
import org.zkoss.jsp.zul.impl.VariableResolvers;
import org.zkoss.jsp.zul.impl.ZkProxy;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.servlet.xel.RequestContext;
import org.zkoss.web.servlet.xel.RequestContexts;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.RichletConfig;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.sys.PageCtrl;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Initiator;

public abstract class RootTag
extends AbstractTag {
    private static final Log log = Log.lookup(RootTag.class);
    private LanguageDefinition _langdef = LanguageDefinition.lookup((String)this._lang);
    private Page _page;
    private String _zsLang = "Java";
    private String _lang = "xul/html";
    private String _cacheable;
    private List<AbstractTag> _rootCompTags = new ArrayList<AbstractTag>();

    public Page getPage() {
        return this._page;
    }

    protected RootTag() {
    }

    void addRootComponent(AbstractTag comp) {
        this._rootCompTags.add(comp);
    }

    public void addChildTag(ComponentTag child) {
        if (child.isInline()) {
            for (int i = 0; i < child.getComponents().length; ++i) {
                child.getComponents()[i].setPage(this._page);
            }
        } else {
            child.getComponent().setPage(this._page);
        }
    }

    public String getZScriptLanguage() {
        return this._zsLang;
    }

    public void setZScriptLanguage(String lang) {
        this._zsLang = lang != null ? lang : "Java";
    }

    public void setZscriptLanguage(String lang) {
        this.setZScriptLanguage(lang);
    }

    public String getLanguage() {
        return this._lang;
    }

    public void setLanguage(String lang) {
        if (lang == null || "".equals(lang)) {
            throw new IllegalArgumentException("language can't be null or empty!!!");
        }
        this._langdef = LanguageDefinition.lookup((String)this._lang);
    }

    public String getCacheable() {
        return this._cacheable;
    }

    public void setCacheable(String cacheable) {
        this._cacheable = cacheable;
    }

    protected void init(Execution exec, Page page) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTag() throws JspException, IOException {
        if (!this.isEffective()) {
            return;
        }
        AbstractTag pt = (AbstractTag)RootTag.findAncestorWithClass((JspTag)this, AbstractTag.class);
        if (pt instanceof RootTag || pt instanceof BranchTag) {
            throw new JspTagException("<page> can be placed inside of " + (Object)((Object)pt));
        }
        JspContext jspctx = this.getJspContext();
        PageContext pgctx = Jsps.getPageContext(jspctx);
        ServletContext svlctx = pgctx.getServletContext();
        HttpServletRequest request = (HttpServletRequest)pgctx.getRequest();
        HttpServletResponse response = (HttpServletResponse)pgctx.getResponse();
        WebManager webman = WebManager.getWebManager((ServletContext)svlctx);
        Session sess = WebManager.getSession((ServletContext)svlctx, (HttpServletRequest)request);
        RequestContexts.push((RequestContext)new PageRequestContext(pgctx));
        SessionsCtrl.setCurrent((Session)sess);
        Object old = I18Ns.setup((Session)sess, (ServletRequest)request, (ServletResponse)response, (String)"UTF-8");
        try {
            boolean cacheable;
            WebApp wapp = sess.getWebApp();
            WebAppCtrl wappc = (WebAppCtrl)wapp;
            String path = Https.getThisServletPath((ServletRequest)request);
            Desktop desktop = webman.getDesktop(sess, (ServletRequest)request, (ServletResponse)response, path, true);
            RequestInfoImpl ri = new RequestInfoImpl(wapp, sess, desktop, (Object)request, PageDefinitions.getLocator((WebApp)wapp, (String)path));
            ((SessionCtrl)sess).notifyClientRequest(true);
            UiFactory uf = wappc.getUiFactory();
            MyRichlet richlet = new MyRichlet();
            this._page = uf.newPage((RequestInfo)ri, (Richlet)richlet, path);
            if (this._zsLang != null) {
                this._page.setZScriptLanguage(this._zsLang);
            }
            ExecutionImpl exec = new ExecutionImpl(svlctx, request, response, desktop, this._page);
            ZkProxy.Proxy zkproxy = ZkProxy.getProxy();
            zkproxy.setPageOnly((Execution)exec);
            boolean bl = cacheable = this._cacheable != null ? Boolean.getBoolean(this._cacheable) : exec.getDesktop().getDevice().isCacheable();
            if (!cacheable) {
                try {
                    exec.setResponseHeader("Pragma", "no-cache");
                    exec.addResponseHeader("Cache-Control", "no-cache");
                    exec.addResponseHeader("Cache-Control", "no-store");
                    exec.setResponseHeader("Expires", "-1");
                    zkproxy.setAttribute((Execution)exec, "org.zkoss.zk.desktop.nocache", Boolean.TRUE);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            this.init((Execution)exec, this._page);
            Jsps.setZkPageObject(jspctx, this._page);
            zkproxy.beforeRender((Execution)exec, this._page);
            try {
                wappc.getUiEngine().execNewPage((Execution)exec, (Richlet)richlet, this._page, (Writer)jspctx.getOut());
            }
            finally {
                zkproxy.afterRender((Execution)exec, this._page);
            }
        }
        finally {
            SessionsCtrl.setCurrent((Session)null);
            RequestContexts.pop();
            I18Ns.cleanup((ServletRequest)request, (Object)old);
        }
    }

    public void processZScript(Component parent, ZScript zs) throws IOException {
        RootTag.processZScript(this._page, parent, zs);
    }

    public static void processZScript(Page page, Component parent, ZScript zs) throws IOException {
        if (zs.getLanguage() == null) {
            zs.setLanguage(page.getZScriptLanguage());
        }
        if (zs.isDeferred()) {
            ((PageCtrl)page).addDeferredZScript(parent, zs);
        } else {
            ZkProxy.getProxy().interpret(page, parent, zs);
        }
    }

    private class MyRichlet
    implements Richlet {
        private MyRichlet() {
        }

        public void init(RichletConfig config) {
        }

        public void destroy() {
        }

        public void service(Page page) {
            WebApp wapp;
            String currentVersion;
            VariableResolvers vResolvs = VariableResolvers.getInstance(RootTag.this.getJspContext());
            try {
                vResolvs.initPageVariableResolvers(RootTag.this._page);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Initiators inits = Initiators.getInstance(RootTag.this.getJspContext());
            Initiator[] sysinits = null;
            if (page != null && org.zkoss.util.Utils.compareVersion((int[])org.zkoss.util.Utils.parseVersion((String)(currentVersion = (wapp = page.getDesktop().getWebApp()).getVersion())), (int[])org.zkoss.util.Utils.parseVersion((String)"5.0.7")) > -1) {
                sysinits = wapp.getConfiguration().getInitiators();
            }
            if (inits != null) {
                inits.doInit(page, sysinits);
            }
            try {
                StringWriter out = new StringWriter();
                JspFragment frag = RootTag.this.getJspBody();
                if (frag != null) {
                    frag.invoke((Writer)out);
                }
                if (inits != null) {
                    inits.doAfterCompose(page, RootTag.this._rootCompTags);
                }
                if (frag != null) {
                    Utils.adjustChildren(page, null, page.getRoots(), out.toString());
                }
            }
            catch (Exception ex) {
                log.realCauseBriefly((Throwable)ex);
                if (inits != null) {
                    inits.doCatch(ex);
                }
                throw UiException.Aide.wrap((Throwable)ex);
            }
            finally {
                if (inits != null) {
                    inits.doFinally();
                }
            }
        }

        public LanguageDefinition getLanguageDefinition() {
            return RootTag.this._langdef;
        }
    }
}

