/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsp.zul.impl;

import java.util.LinkedList;
import java.util.List;
import javax.servlet.jsp.JspContext;
import org.zkoss.jsp.zul.impl.VariableResolverInfo;
import org.zkoss.zk.ui.Page;

public class VariableResolvers {
    private static final String KEY = VariableResolvers.class.getName() + "!KEY";
    private final List<VariableResolverInfo> varResInfoList;
    private final JspContext context;

    public VariableResolvers(JspContext context) {
        this.context = context;
        this.varResInfoList = new LinkedList<VariableResolverInfo>();
    }

    public static VariableResolvers getInstance(JspContext context) {
        VariableResolvers vres = (VariableResolvers)context.getAttribute(KEY);
        if (vres == null) {
            vres = new VariableResolvers(context);
            context.setAttribute(KEY, (Object)vres);
        }
        return vres;
    }

    public void add(VariableResolverInfo reso) {
        this.varResInfoList.add(reso);
    }

    public void initPageVariableResolvers(Page page) throws Exception {
        for (VariableResolverInfo vrInfo : this.varResInfoList) {
            page.addVariableResolver(vrInfo.newVariableResolver());
        }
    }

    public JspContext getContext() {
        return this.context;
    }
}

